/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import java.io.UnsupportedEncodingException;

class BaseByteArrayWriter {
    private String encoding;
    private byte[] byteArray;
    private int next = 0;
    private static final int SHORT_LENGTH = 2;
    private static final String ENCODING = System.getProperty("file.encoding");

    public BaseByteArrayWriter(int size, String encoding) {
        this.byteArray = new byte[size];
        this.encoding = encoding;
    }

    public static BaseByteArrayWriter newBaseByteArrayWriter(int length) {
        return new BaseByteArrayWriter(length, ENCODING);
    }

    public void write(String s, int length) {
        if (s != null && s.length() > 0 && length > 0) {
            byte[] b = null;
            try {
                b = s.getBytes(this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            int n = Math.min(b.length, length);
            System.arraycopy(b, 0, this.byteArray, this.next, n);
        }
        this.next += length;
    }

    public void write(char c) throws UnsupportedEncodingException {
        this.byteArray[this.next++] = this.getCharAsByte(c);
    }

    public void writeBinaryShort(short value) {
        short tmpValue = value;
        for (int i = 1; i >= 0; --i) {
            this.byteArray[this.next + i] = (byte)(tmpValue & 0xFF);
            tmpValue = (short)(tmpValue >> 8);
        }
        this.next += 2;
    }

    public void writeShort(short value) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("Method is deprecated. Use write(String, int) instead.");
    }

    public void writeInt(int value) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("Method is deprecated. Use write(String, int) instead.");
    }

    public void skip(int n) {
        this.next += n;
    }

    public byte[] getBytes() {
        return this.byteArray;
    }

    private byte getCharAsByte(char c) throws UnsupportedEncodingException {
        String s = String.valueOf(c);
        byte[] bytes = s.getBytes(this.encoding);
        return bytes[0];
    }
}

