/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.GeoStan;
import com.centrus.geostan.GeoStanException;
import com.centrus.geostan.MinBoundingRect;

public class City {
    private GeoStan geostan = null;
    private long recordNumber = 0L;

    City(GeoStan geostan, long recordNumber) {
        this.geostan = geostan;
        this.recordNumber = recordNumber;
    }

    City(GeoStan geostan) {
        this(geostan, 0L);
    }

    public boolean isValid() {
        return this.geostan != null && this.recordNumber != 0L;
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    public String getData(int field) throws GeoStanException {
        if (!this.isValid()) {
            throw new GeoStanException("The city is invalid.");
        }
        return this.geostan.getCityData(this, field);
    }

    public MinBoundingRect getMinBoundingRect() throws GeoStanException {
        String qcity = this.geostan.getCityData(this, 6);
        if (qcity == null || qcity.equals("")) {
            throw new GeoStanException("Invalid QCity string");
        }
        return this.geostan.getMinBoundingRect(qcity.substring(0, 6));
    }
}

