/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.City;
import com.centrus.geostan.GeoStan;
import com.centrus.geostan.GeoStanException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CityIterator
implements Iterator {
    private GeoStan geostan = null;
    private String state = null;
    private String cityPattern = null;
    private boolean needNext = false;
    private City nextCity = null;
    private boolean gotFirst = false;

    CityIterator(GeoStan geostan, String state, String cityPattern) {
        this.geostan = geostan;
        this.state = state;
        this.cityPattern = cityPattern;
        this.needNext = true;
    }

    public String getState() {
        return this.state;
    }

    public String getCityPattern() {
        return this.cityPattern;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("City elements cannot be removed.");
    }

    @Override
    public boolean hasNext() {
        if (this.needNext) {
            this.getNext();
            this.needNext = false;
        }
        return this.nextCity != null && this.nextCity.isValid();
    }

    public Object next() {
        if (this.needNext) {
            this.getNext();
        } else {
            this.needNext = true;
        }
        if (this.nextCity == null || !this.nextCity.isValid()) {
            throw new NoSuchElementException("Invalid City object");
        }
        return this.nextCity;
    }

    private void getNext() {
        if (this.geostan == null) {
            throw new NoSuchElementException("Invalid GeoStan object");
        }
        try {
            if (!this.gotFirst) {
                this.nextCity = this.geostan.findFirstCity(this.state, this.cityPattern);
                this.gotFirst = true;
            } else {
                this.nextCity = this.geostan.findNextCity();
            }
        }
        catch (GeoStanException ex) {
            throw new NoSuchElementException(ex.getMessage());
        }
    }
}

