/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.GeoProps;
import com.centrus.geostan.GeoStanBase;
import com.centrus.geostan.GeoStanException;

public class FindProps
extends GeoProps {
    public static final int STREETOFFSET_DEFAULT = 50;
    public static final int CORNEROFFSET_DEFAULT = 50;
    public static final int CLIENTCRS_DEFAULT = 1;
    public static final boolean MIXEDCASE_DEFAULT = false;
    public static final boolean WIDE_SEARCH_DEFAULT = false;
    public static final int FIND_ADDRCODE = 1000;
    public static final int FIND_Z9_CODE = 1001;
    public static final int FIND_WIDE_SEARCH = 1002;
    public static final int FIND_SEARCH_AREA = 1003;
    public static final int FIND_Z7_CODE = 1004;
    public static final int FIND_Z5_CODE = 1005;
    public static final int FIND_CENTERLN_PROJ_OF_POINT = 1006;
    public static final int FIND_APN_SEARCH = 1007;
    public static final int FIND_PREFER_POBOX = 1008;
    public static final int FIND_PREFER_STREET = 1009;
    public static final int FIND_BUILDING_SEARCH = 1010;
    public static final int FIND_NEAREST_ADDRESS = 1011;
    public static final int FIND_NEAREST_INTERSECTION = 1012;
    public static final int FIND_NEAREST_UNRANGED = 1013;
    public static final int FIND_Z_CODE = 1014;
    public static final int FIND_SEARCH_DIST = 1015;
    public static final int FIND_STREET_OFFSET = 1016;
    public static final int FIND_CORNER_OFFSET = 1017;
    public static final int FIND_MATCH_MODE = 1018;
    public static final int FIND_ZIP_SEARCH = 1019;
    public static final int FIND_CITY_SEARCH = 1020;
    public static final int FIND_SDX_SEARCH = 1021;
    public static final int FIND_STATE_SEARCH = 1022;
    public static final int FIND_EXTRA_SEARCH = 1023;
    public static final int FIND_CLIENT_CRS = 1024;
    public static final int FIND_MUST_MATCH_ADDRNUM = 1025;
    public static final int FIND_MUST_MATCH_MAINADDR = 1026;
    public static final int FIND_MUST_MATCH_STATE = 1027;
    public static final int FIND_MUST_MATCH_ZIPCODE = 1028;
    public static final int FIND_MUST_MATCH_CITY = 1029;
    public static final int FIND_AVAILABLE_FOR_USE = 1030;
    public static final int FIND_EXPANDED_SEARCH_RADIUS = 1031;
    public static final int FIND_EXPND_SRCH_LIM_TO_STATE = 1032;
    public static final int FIND_DPV = 1033;
    public static final int FIND_ALTERNATE_LOOKUP = 1034;
    public static final int FIND_LACSLINK = 1035;
    public static final int FIND_STREET_CENTROID = 1036;
    public static final int FIND_RET_INTERSECTION_NUM = 1037;
    public static final int FIND_MIXED_CASE = 1038;
    public static final int FIND_CENTERLINE_OFFSET = 1039;
    public static final int FIND_POINT_ZIP_MATCH = 1040;
    public static final int FIND_ADDR_POINT_INTERP = 1041;
    public static final int FIND_FIRST_LETTER_EXPANDED = 1042;
    public static final int FIND_ADDRESS_RANGE = 1043;
    public static final int FIND_SUITELINK = 1044;
    public static final int FIND_DB_ORDER = 1045;
    public static final int FIND_CORRECT_LASTLINE = 1046;
    public static final int FIND_PREFER_ZIP_OVER_CITY = 1047;
    public static final int FIND_CLOSEST_POINT = 1048;
    public static final int FIND_APPROXIMATE_PBKEY = 1049;
    public static final int FIND_LAST_ENTRY = 1049;
    public static final int NUM_FIND_ELEMENTS = 50;
    private int m_hash = 0;
    private long m_handle = 0L;
    private static final FindProps PRIMING_FIND_PROPS = new FindProps();

    public FindProps() {
        this.m_listType = 2;
        this.reset();
    }

    public FindProps(FindProps other) {
        super(other);
        this.m_listType = 2;
        this.m_hash = other.m_hash;
        this.m_handle = other.m_handle;
    }

    @Override
    public void set(int key, String value) throws IllegalArgumentException {
        this.checkValidKeyValueList(key, 1);
        String old = this.m_Props.put(new Integer(key), value);
        if (value != old || old != null && !old.equals(value)) {
            this.m_bDirty = true;
            this.m_hash = 0;
        }
    }

    @Override
    public void set(int key, boolean value) throws IllegalArgumentException {
        this.checkValidKeyValueList(key, 4);
        Boolean valueObject = new Boolean(value);
        if (key == 1014) {
            Boolean old5 = this.m_Props.put(new Integer(1005), valueObject);
            Boolean old7 = this.m_Props.put(new Integer(1004), valueObject);
            Boolean old9 = this.m_Props.put(new Integer(1001), valueObject);
            if (valueObject != old5 || old5 != null && !((Object)old5).equals(valueObject)) {
                this.m_bDirty = true;
                this.m_hash = 0;
            } else if (valueObject != old7 || old7 != null && !((Object)old7).equals(valueObject)) {
                this.m_bDirty = true;
                this.m_hash = 0;
            } else if (valueObject != old9 || old9 != null && !((Object)old9).equals(valueObject)) {
                this.m_bDirty = true;
                this.m_hash = 0;
            }
        } else {
            Boolean old = this.m_Props.put(new Integer(key), valueObject);
            if (valueObject != old || old != null && !((Object)old).equals(valueObject)) {
                this.m_bDirty = true;
                this.m_hash = 0;
            }
        }
    }

    @Override
    public void set(int key, int value) throws IllegalArgumentException {
        this.checkValidKeyValueList(key, 2);
        if (key == 1018 && !GeoStanBase.MatchMode.isValid((short)value)) {
            throw new IllegalArgumentException("Invalid match mode: " + value);
        }
        Integer valueObject = new Integer(value);
        Integer old = this.m_Props.put(new Integer(key), valueObject);
        this.m_Props.put(new Integer(key), valueObject);
        if (valueObject != old || old != null && !((Object)old).equals(valueObject)) {
            this.m_bDirty = true;
            this.m_hash = 0;
        }
    }

    @Override
    public boolean getBool(int key) throws GeoStanException {
        this.checkValidKeyValueList(key, 4);
        Object obj = this.m_Props.get(new Integer(key));
        if (obj == null) {
            if (key == 1014) {
                obj = this.m_Props.get(new Integer(1005));
                if (obj != null && ((Boolean)obj).booleanValue()) {
                    return true;
                }
                obj = this.m_Props.get(new Integer(1004));
                if (obj != null && ((Boolean)obj).booleanValue()) {
                    return true;
                }
                obj = this.m_Props.get(new Integer(1001));
                if (obj != null && ((Boolean)obj).booleanValue()) {
                    return true;
                }
            }
            throw new GeoStanException("Property list does not contain prop ID: " + key);
        }
        return (Boolean)obj;
    }

    @Override
    public void remove(int key) {
        this.checkValidKeyList(key);
        if (key == 1014) {
            this.m_Props.remove(new Integer(1005));
            this.m_Props.remove(new Integer(1004));
            this.m_Props.remove(new Integer(1001));
        } else {
            this.m_Props.remove(new Integer(key));
        }
        this.m_bDirty = true;
    }

    @Override
    public boolean contains(int key) {
        this.checkValidKeyList(key);
        if (key == 1014) {
            try {
                return this.getBool(key);
            }
            catch (GeoStanException ex) {
                return false;
            }
        }
        Integer keyInt = new Integer(key);
        return this.m_Props.containsKey(keyInt);
    }

    public int hashCode() {
        if (this.m_hash != 0) {
            return this.m_hash;
        }
        this.m_handle = 0L;
        for (int index = 1000; index <= 1049; ++index) {
            Integer findOp = new Integer(index);
            this.m_hash += 37 * String.valueOf(this.m_Props.get(findOp)).hashCode();
        }
        String threadStr = new String(Thread.currentThread().toString());
        this.m_hash += threadStr.hashCode();
        return this.m_hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FindProps)) {
            return false;
        }
        if (this.m_handle != 0L && this.m_handle == ((FindProps)obj).getHandle()) {
            return true;
        }
        return super.equals(obj);
    }

    public void reset() throws IllegalArgumentException {
        this.clear();
        this.set(1016, 50);
        this.set(1017, 50);
        this.set(1024, GeoStanBase.DataSetStatus.DATUM_NAMES[1]);
        this.set(1038, false);
        this.set(1002, false);
    }

    long getHandle() {
        if (this.m_hash != 0) {
            return this.m_handle;
        }
        return 0L;
    }

    void setHandle(long handle) {
        this.m_handle = handle;
    }

    public abstract class StreetFirmPref {
        public static final int PREFER_UNDEFINED = 0;
        public static final int PREFER_STREET_LOOKUP = 1;
        public static final int PREFER_FIRM_LOOKUP = 2;
        public static final int STREET_LOOKUP_ONLY = 3;
    }

    public abstract class PropSearchType {
        public static final int FIND_SEARCH_AREA_CITY = 0;
        public static final int FIND_SEARCH_AREA_FINANCE = 1;
        public static final int FIND_SEARCH_AREA_EXPANDED = 2;
    }
}

