/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.GeoStanException;
import java.io.File;

class GeoStanLoader {
    private static boolean m_bLoadedLibraries = false;

    GeoStanLoader() {
    }

    public boolean isLoaded() {
        return m_bLoadedLibraries;
    }

    public void loadGeoStanLibrary(String GeoStanLibraryPath) throws GeoStanException {
        if (m_bLoadedLibraries) {
            return;
        }
        String libPath = GeoStanLibraryPath.trim();
        if (libPath == null) {
            libPath = "";
        }
        libPath = new File(libPath).getAbsolutePath();
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        try {
            if (osName.startsWith("Windows")) {
                String tempPath = libPath.toUpperCase();
                if (tempPath.indexOf("DEBUG") > 0) {
                    System.load(libPath + "/FileMapd.dll");
                    System.load(libPath + "/STELINKd.dll");
                    System.load(libPath + "/DPVd.dll");
                    System.load(libPath + "/LACSd.dll");
                } else {
                    System.load(libPath + "/FileMap.dll");
                    System.load(libPath + "/STELINK.dll");
                    System.load(libPath + "/DPV.dll");
                    System.load(libPath + "/LACS.dll");
                }
                if (osArch.indexOf("x86") >= 0) {
                    System.load(libPath + "/geostn32MT.dll");
                } else {
                    System.load(libPath + "/geostn64MT.dll");
                }
            } else if (osName.startsWith("HP")) {
                System.load(libPath + "/libgeostanMT.sl");
            } else {
                System.load(libPath + "/libgeostanMT.so");
            }
        }
        catch (UnsatisfiedLinkError ex) {
            throw new GeoStanException(ex.getMessage());
        }
        m_bLoadedLibraries = true;
    }
}

