/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.BaseByteArrayWriter;
import com.centrus.geostan.ByteBufferUtil;
import com.centrus.geostan.GeoStan;
import com.centrus.geostan.GeoStanBase;
import com.centrus.geostan.GeoStanException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

class NativeInput {
    private Map fields;
    private int bytesLength;
    private static final int BASE_SIZE = 1000;
    private ByteBuffer inputBuf = ByteBuffer.allocateDirect(1000);

    NativeInput() {
        this.init();
    }

    private void init() {
        this.fields = new HashMap();
        this.bytesLength = 2;
    }

    void clear() {
        this.init();
    }

    void setData(String value, short element) {
        String oldValue = this.fields.put(new Short(element), value);
        if (oldValue == null) {
            this.bytesLength += 4 + GeoStanBase.getFieldLength(element);
        }
    }

    private byte[] toBytes() {
        short count = (short)this.fields.size();
        BaseByteArrayWriter writer = BaseByteArrayWriter.newBaseByteArrayWriter(this.bytesLength);
        writer.writeBinaryShort(count);
        for (Map.Entry entry : this.fields.entrySet()) {
            short fieldID = (Short)entry.getKey();
            writer.writeBinaryShort(fieldID);
            short fieldLength = GeoStanBase.getFieldLength(fieldID);
            writer.writeBinaryShort(fieldLength);
            writer.write((String)entry.getValue(), fieldLength);
        }
        return writer.getBytes();
    }

    void makeSetDataCalls(GeoStan geoStan, long gs) throws GeoStanException {
        for (Map.Entry entry : this.fields.entrySet()) {
            short fieldID = (Short)entry.getKey();
            String value = (String)entry.getValue();
            geoStan.setData(gs, value, fieldID);
        }
    }

    int getSizeof() {
        return this.bytesLength;
    }

    ByteBuffer getInputBuf() {
        int capacity;
        int sizeof = this.getSizeof();
        if (sizeof > (capacity = this.inputBuf.capacity())) {
            this.inputBuf = ByteBuffer.allocateDirect(sizeof);
        }
        ByteBufferUtil.loadBuffer(this.toBytes(), this.inputBuf);
        return this.inputBuf;
    }
}

