/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.GeoStan;
import com.centrus.geostan.GeoStanException;
import com.centrus.geostan.MinBoundingRect;
import com.centrus.geostan.Segment;
import com.centrus.geostan.Street;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SegmentIterator
implements Iterator {
    private GeoStan geostan = null;
    private Street street = null;
    private MinBoundingRect mbr = null;
    private boolean needNext = false;
    private Segment nextSegment = null;
    private boolean gotFirst = false;

    SegmentIterator(GeoStan geostan, Street street) {
        this.geostan = geostan;
        this.street = street;
        this.needNext = true;
    }

    SegmentIterator(GeoStan geostan, MinBoundingRect mbr) {
        this.geostan = geostan;
        this.mbr = mbr;
        this.needNext = true;
    }

    SegmentIterator(GeoStan geostan) {
        this.geostan = geostan;
        this.street = new Street(geostan);
        this.needNext = true;
    }

    public MinBoundingRect getMinBoundingRect() {
        return this.mbr;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Segment elements cannot be removed.");
    }

    @Override
    public boolean hasNext() {
        if (this.needNext) {
            this.getNext();
            this.needNext = false;
        }
        return this.nextSegment != null && this.nextSegment.isValid();
    }

    public Object next() {
        if (this.needNext) {
            this.getNext();
        } else {
            this.needNext = true;
        }
        if (this.nextSegment == null || !this.nextSegment.isValid()) {
            throw new NoSuchElementException("Invalid Segment object");
        }
        return this.nextSegment;
    }

    private void getNext() {
        if (this.geostan == null) {
            throw new NoSuchElementException("Invalid GeoStan object");
        }
        try {
            if (!this.gotFirst) {
                this.nextSegment = this.mbr == null ? this.geostan.findFirstSegment(this.street) : this.geostan.findFirstSegmentByMbr(this.mbr);
                this.gotFirst = true;
            } else {
                this.nextSegment = this.mbr == null ? this.geostan.findNextSegment(this.nextSegment) : this.geostan.findNextSegmentByMbr(this.nextSegment);
            }
        }
        catch (GeoStanException ex) {
            throw new NoSuchElementException(ex.getMessage());
        }
    }
}

