/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys;

import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

@PublicAPI
public class CodeSet
implements Iterable<Code>,
Serializable {
    private final Collection<Code> m_codeCollection;

    public CodeSet() {
        this.m_codeCollection = Collections.emptyList();
    }

    public CodeSet(String codeSpace, String code) {
        this.m_codeCollection = Collections.singletonList(new Code(codeSpace, code));
    }

    public CodeSet(Code code) {
        this.m_codeCollection = Collections.singletonList(code);
    }

    public CodeSet(Code ... codeList) {
        this(Arrays.asList(codeList));
    }

    public CodeSet(Collection<Code> codeCollection) {
        this.m_codeCollection = Collections.unmodifiableCollection(new ArrayList<Code>(codeCollection));
    }

    public String toString() {
        String ret = "[";
        for (Code iCode : this.m_codeCollection) {
            ret = ret + iCode.toString() + ", ";
        }
        if (ret.length() > 2) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret + "]";
    }

    public int size() {
        return this.m_codeCollection.size();
    }

    public boolean isEmpty() {
        return this.m_codeCollection.isEmpty();
    }

    public Collection<Code> getCodes(String codeSpace) {
        ArrayList<Code> codeCollection = new ArrayList<Code>();
        for (Code c : this.m_codeCollection) {
            if (!c.getCodeSpace().equalsIgnoreCase(codeSpace)) continue;
            codeCollection.add(c);
        }
        return Collections.unmodifiableCollection(codeCollection);
    }

    public Code getFirstCode(String codeSpace) {
        for (Code c : this.m_codeCollection) {
            if (!c.getCodeSpace().equalsIgnoreCase(codeSpace)) continue;
            return c;
        }
        return null;
    }

    @Override
    public Iterator<Code> iterator() {
        return this.m_codeCollection.iterator();
    }

    public boolean contains(String codeSpace, String code) {
        for (Code c : this.m_codeCollection) {
            if (!c.getCodeSpace().equalsIgnoreCase(codeSpace) || !c.getCode().equalsIgnoreCase(code)) continue;
            return true;
        }
        return false;
    }
}

