/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysType;
import com.mapinfo.midev.coordsys.GeodeticDatumOperation;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.geometry.AffineTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.DoubleRect;
import java.io.Serializable;

public class GeographicCoordSys
extends CoordSys
implements Serializable {
    private static final double[] EARTH_BOUNDS;
    private final GeodeticDatumOperation m_geodeticDatumOperation;
    private final AngularUnit m_angularUnit;
    private final Projection m_projection;
    private DoubleRect m_bounds;
    private final boolean m_boundsCalculated;

    public GeographicCoordSys(String displayName, CodeSet codeSet, AffineTransform affineTransform, GeodeticDatumOperation geodeticDatumOperation, AngularUnit angularUnit, Projection projection) {
        this(displayName, codeSet, affineTransform, geodeticDatumOperation, angularUnit, projection, null);
    }

    public GeographicCoordSys(String displayName, CodeSet codeSet, AffineTransform affineTransform, GeodeticDatumOperation geodeticDatumOperation, AngularUnit angularUnit, Projection projection, DoubleRect bounds) {
        super(displayName, codeSet, affineTransform);
        ArgumentValidator.assertNotNullReference((String)"geodeticDatumOperation", (Object)geodeticDatumOperation);
        this.m_geodeticDatumOperation = geodeticDatumOperation;
        this.m_angularUnit = angularUnit;
        this.m_projection = projection;
        if (bounds != null) {
            this.m_bounds = bounds;
            this.m_boundsCalculated = false;
        } else {
            this.m_boundsCalculated = true;
        }
    }

    public GeodeticDatumOperation getGeodeticDatumOperation() {
        return this.m_geodeticDatumOperation;
    }

    public AngularUnit getAngularUnit() {
        return this.m_angularUnit;
    }

    public Projection getProjection() {
        return this.m_projection;
    }

    @Override
    public CoordSysType getType() {
        return CoordSysType.GEOGRAPHIC;
    }

    @Override
    public synchronized DoubleRect getMBR() {
        if (this.m_bounds == null) {
            if (this.m_projection == null) {
                this.m_bounds = new DoubleRect(-180.0, -90.0, 180.0, 90.0);
            } else {
                this.m_bounds = new DoubleRect();
                this.m_bounds.initBounds();
                DirectPosition tmp = new DirectPosition();
                for (int n = 0; n < EARTH_BOUNDS.length; n += 2) {
                    tmp.setXY(EARTH_BOUNDS[n], EARTH_BOUNDS[n + 1]);
                    this.m_projection.fromLongLat(tmp, tmp);
                    this.m_bounds.merge(tmp.getX(), tmp.getY());
                }
            }
        }
        return new DoubleRect(this.m_bounds);
    }

    public boolean isMBRCalculated() {
        return this.m_boundsCalculated;
    }

    @Override
    public boolean equivalent(CoordSys coordSys) {
        if (this == coordSys) {
            return true;
        }
        if (!super.equivalent(coordSys)) {
            return false;
        }
        GeographicCoordSys geographicCoordSys = (GeographicCoordSys)coordSys;
        if (!this.m_angularUnit.equals((Object)geographicCoordSys.m_angularUnit)) {
            return false;
        }
        if (!this.m_geodeticDatumOperation.equivalent(geographicCoordSys.m_geodeticDatumOperation)) {
            return false;
        }
        return !(this.m_projection == null ? geographicCoordSys.m_projection != null : !this.m_projection.equivalent(geographicCoordSys.m_projection));
    }

    public CoordSys withBounds(DoubleRect bounds) {
        return new GeographicCoordSys(this.getDisplayName(null), this.getCodes(), this.getAffineTransform(), this.m_geodeticDatumOperation, this.m_angularUnit, this.m_projection, bounds);
    }

    static {
        int n;
        EARTH_BOUNDS = new double[722];
        int count = 0;
        for (n = -90; n <= 90; n += 2) {
            GeographicCoordSys.EARTH_BOUNDS[count++] = -180.0;
            GeographicCoordSys.EARTH_BOUNDS[count++] = n;
        }
        for (n = -176; n <= 180; n += 4) {
            GeographicCoordSys.EARTH_BOUNDS[count++] = n;
            GeographicCoordSys.EARTH_BOUNDS[count++] = 90.0;
        }
        for (n = 88; n >= -90; n -= 2) {
            GeographicCoordSys.EARTH_BOUNDS[count++] = 180.0;
            GeographicCoordSys.EARTH_BOUNDS[count++] = n;
        }
        for (n = 176; n >= -176; n -= 4) {
            GeographicCoordSys.EARTH_BOUNDS[count++] = n;
            GeographicCoordSys.EARTH_BOUNDS[count++] = -90.0;
        }
    }
}

