/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.factory;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.Ellipsoid;
import com.mapinfo.midev.coordsys.EngineeringCoordSys;
import com.mapinfo.midev.coordsys.GeodeticDatum;
import com.mapinfo.midev.coordsys.GeodeticDatumOperation;
import com.mapinfo.midev.coordsys.GeographicCoordSys;
import com.mapinfo.midev.coordsys.InvalidCoordSysXMLFileException;
import com.mapinfo.midev.coordsys.PrimeMeridian;
import com.mapinfo.midev.coordsys.UnknownCodeException;
import com.mapinfo.midev.coordsys.UnknownSRSNameException;
import com.mapinfo.midev.coordsys.factory.prj.PRJCoordSysProvider;
import com.mapinfo.midev.coordsys.parser.LegacyCoordSysParams;
import com.mapinfo.midev.coordsys.parser.LegacyCoordSysParser;
import com.mapinfo.midev.coordsys.parser.LegacyMXJCoordSysParser;
import com.mapinfo.midev.coordsys.parser.LegacyProjectionParser;
import com.mapinfo.midev.coordsys.parser.MapBasicCoordSysParser;
import com.mapinfo.midev.coordsys.parser.PRJCoordSysParser;
import com.mapinfo.midev.coordsys.projection.AlbersEqualAreaConicFactory;
import com.mapinfo.midev.coordsys.projection.AzimuthalEquidistantFactory;
import com.mapinfo.midev.coordsys.projection.CassiniSoldnerFactory;
import com.mapinfo.midev.coordsys.projection.CylindricalEqualAreaFactory;
import com.mapinfo.midev.coordsys.projection.DoubleStereographicFactory;
import com.mapinfo.midev.coordsys.projection.EckertIVFactory;
import com.mapinfo.midev.coordsys.projection.EckertVIFactory;
import com.mapinfo.midev.coordsys.projection.EquidistantConicFactory;
import com.mapinfo.midev.coordsys.projection.EquidistantCylindricalFactory;
import com.mapinfo.midev.coordsys.projection.GallFactory;
import com.mapinfo.midev.coordsys.projection.HotineObliqueMercatorFactory;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.KrovakFactory;
import com.mapinfo.midev.coordsys.projection.LambertAzimuthalEqualAreaFactory;
import com.mapinfo.midev.coordsys.projection.LambertConformalConicBelgium1972Factory;
import com.mapinfo.midev.coordsys.projection.LambertConformalConicFactory;
import com.mapinfo.midev.coordsys.projection.MercatorFactory;
import com.mapinfo.midev.coordsys.projection.MillerFactory;
import com.mapinfo.midev.coordsys.projection.MollweideFactory;
import com.mapinfo.midev.coordsys.projection.NewZealandMapGridFactory;
import com.mapinfo.midev.coordsys.projection.PolyconicFactory;
import com.mapinfo.midev.coordsys.projection.RectifiedSkewOrthomorphicFactory;
import com.mapinfo.midev.coordsys.projection.RegionalMercatorFactory;
import com.mapinfo.midev.coordsys.projection.RobinsonFactory;
import com.mapinfo.midev.coordsys.projection.SinusoidalFactory;
import com.mapinfo.midev.coordsys.projection.StereographicFactory;
import com.mapinfo.midev.coordsys.projection.SwissObliqueMercatorFactory;
import com.mapinfo.midev.coordsys.projection.TransverseMercatorDenmarkS34JFactory;
import com.mapinfo.midev.coordsys.projection.TransverseMercatorDenmarkS34SFactory;
import com.mapinfo.midev.coordsys.projection.TransverseMercatorDenmarkS45BFactory;
import com.mapinfo.midev.coordsys.projection.TransverseMercatorExtendedFactory;
import com.mapinfo.midev.coordsys.projection.TransverseMercatorFactory;
import com.mapinfo.midev.coordsys.projection.TransverseMercatorFinlandFactory;
import com.mapinfo.midev.coordsys.util.CodeMap;
import com.mapinfo.midev.coordsys.util.CoordSysHashUtilities;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.coordsys.xmlprot.CoordSysConfigReader;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.DoubleRect;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;
import com.mapinfo.midev.xml.read.IXmlReader;
import com.mapinfo.midev.xml.read.XmlReaderException;
import com.mapinfo.midev.xml.read.XmlReaderImpl;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;

@PublicAPI
public final class CoordSysFactory {
    private static final String COORDSYS_XML_FILE = "/coordsys.xml";
    private static final CoordSysFactory DEFAULT = new CoordSysFactory();
    private static final Map<Code, DoubleRect> BOUNDS;
    private final CodeMap<CoordSys> m_coordSysMap = new CodeMap<CoordSys>(){

        @Override
        protected Integer calculateHash(CoordSys t) {
            return 0;
        }
    };
    private final GeodeticDatumOperationFactory m_geodeticDatumOperationMap = new GeodeticDatumOperationFactory();
    private final GeodeticDatumFactory m_geodeticDatumMap = new GeodeticDatumFactory();
    private final EllipsoidFactory m_ellipsoidMap = new EllipsoidFactory();
    private final CodeMap<IProjectionFactory> m_projectionFactoryMap = new CodeMap<IProjectionFactory>(){

        @Override
        protected Integer calculateHash(IProjectionFactory t) {
            return 0;
        }
    };

    private CoordSysFactory() {
    }

    public static CoordSysFactory getDefaultCoordSysFactory() {
        return DEFAULT;
    }

    @PrivateAPI
    public void add(CoordSys csys) {
        for (Code c : csys.getCodes()) {
            this.m_coordSysMap.put(c.getCodeSpace(), c.getCode(), csys);
            switch (csys.getType()) {
                case GEOGRAPHIC: {
                    Code codeWithNoBounds = CoordSysUtilities.removeBounds(c);
                    if (codeWithNoBounds == null) break;
                    this.m_coordSysMap.put(c.getCodeSpace(), codeWithNoBounds.getCode(), csys);
                    break;
                }
            }
        }
    }

    public CoordSys getCoordSys(String codeSpace, String code) {
        return this.getCoordSys(codeSpace, code, true);
    }

    @PrivateAPI
    public CoordSys getCoordSys(String codeSpace, String codeNumber, boolean attemptParse) {
        Code code = new Code(codeSpace, codeNumber);
        return this.getCoordSys(code, attemptParse);
    }

    public CoordSys getCoordSys(Code code) {
        return this.getCoordSys(code, true);
    }

    @PrivateAPI
    public CoordSys getCoordSys(Code code, boolean attemptParse) {
        CoordSys result = this.m_coordSysMap.get(code);
        if (result == null && attemptParse) {
            result = this.attemptParse(code);
        }
        if (result == null) {
            result = this.getCoordSysFromCodeWithBounds(code);
        }
        if (result == null) {
            throw new UnknownCodeException(code);
        }
        return result;
    }

    @PrivateAPI
    public CoordSys getCoordSys(String srsName) {
        Code code = Code.parse(srsName);
        CoordSys result = this.m_coordSysMap.get(code);
        if (result == null) {
            result = this.attemptParse(code);
        }
        if (result == null) {
            result = this.getCoordSysFromCodeWithBounds(code);
        }
        if (result == null) {
            throw new UnknownSRSNameException(srsName);
        }
        return result;
    }

    @PrivateAPI
    public CoordSys getCoordSysFromPRJ(String s) {
        return this.getCoordSys(PRJCoordSysParser.parse(s));
    }

    @PrivateAPI
    public CoordSys getCoordSysFromMapBasic(String s) {
        return this.getCoordSys(MapBasicCoordSysParser.parse(s));
    }

    @PrivateAPI
    public CoordSys getCoordSys(LegacyCoordSysParams params) {
        if (params.getCode() != null && params.getCodeSpace() != null) {
            try {
                return this.getCoordSys(params.getCodeSpace(), params.getCode(), false);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        CoordSys result = this.build(params);
        Code code = result.getCodes().getFirstCode("mapinfo");
        try {
            return this.getCoordSys(code, false);
        }
        catch (Exception ignored) {
            return result;
        }
    }

    @PrivateAPI
    public CodeSet getAllCodes(CoordSys coordSys) {
        ArrayList<Code> allCodes = new ArrayList<Code>();
        Collection<Code> mapinfoCodes = coordSys.getCodes().getCodes("mapinfo");
        for (Code mapinfoCode : mapinfoCodes) {
            List<CoordSys> allCoords = this.m_coordSysMap.getAll(mapinfoCode);
            for (CoordSys coord : allCoords) {
                for (Code c : coord.getCodes()) {
                    allCodes.add(c);
                }
            }
        }
        CodeSet codeSet = new CodeSet(allCodes);
        return codeSet;
    }

    private CoordSys build(LegacyCoordSysParams params) {
        CoordSys result;
        int projectionType = params.getProjectionType();
        if (projectionType == 0) {
            result = new EngineeringCoordSys(params.getDisplayName(), LegacyCoordSysParser.buildCodeSet(params), params.getAffineTransform(), params.getLinearUnit());
        } else {
            GeodeticDatumOperation datum = LegacyCoordSysParser.buildDatumOperation(params);
            CodeSet codeSet = LegacyCoordSysParser.buildCodeSet(params);
            DoubleRect bounds = params.getBounds();
            for (Code code : codeSet) {
                DoubleRect newBounds = BOUNDS.get(code);
                if (newBounds == null) continue;
                bounds = newBounds;
                break;
            }
            result = projectionType == 1 ? new GeographicCoordSys(params.getDisplayName(), codeSet, params.getAffineTransform(), datum, AngularUnit.DEGREE, null, bounds) : new GeographicCoordSys(params.getDisplayName(), codeSet, params.getAffineTransform(), datum, AngularUnit.DEGREE, LegacyProjectionParser.create(projectionType, params.getLinearUnit(), datum.getGeodeticDatum().getEllipsoid(), datum.getGeodeticDatum().getPrimeMeridian(), params.getProjectionParams()), bounds);
        }
        return result;
    }

    private CoordSys attemptParse(Code code) {
        CoordSys result = null;
        if (code.getCodeSpace().equalsIgnoreCase("mapinfo")) {
            if (code.getCode().startsWith("coordsys ")) {
                result = this.getCoordSysFromPRJ(code.getCode().substring("coordsys ".length()));
            } else if (code.getCode().toLowerCase().startsWith("coordsys")) {
                String mapBasic = LegacyMXJCoordSysParser.getMapBasic(code);
                if (mapBasic != null) {
                    result = this.getCoordSysFromPRJ("\"\\p" + code.getCodeSpace() + ':' + code.getCode() + "\"," + mapBasic);
                }
            } else {
                try {
                    result = this.getCoordSysFromPRJ(code.getCode());
                }
                catch (Exception e) {
                    result = this.getCoordSysFromMapBasic("CoordSys " + code.getCode());
                }
            }
        }
        return result;
    }

    @PrivateAPI
    public Set<CoordSys> getCoordSysSet() {
        return this.m_coordSysMap.values();
    }

    @PrivateAPI
    public Set<Code> getCoordSysCodeSet() {
        return this.m_coordSysMap.keySet();
    }

    @PrivateAPI
    public void add(GeodeticDatumOperation datum) {
        for (Code c : datum.getCodes()) {
            this.m_geodeticDatumOperationMap.put(c.getCodeSpace(), c.getCode(), datum);
        }
    }

    @PrivateAPI
    public GeodeticDatumOperation getGeodeticDatumOperation(String codeSpace, String code) {
        return (GeodeticDatumOperation)this.m_geodeticDatumOperationMap.get(codeSpace, code);
    }

    @PrivateAPI
    public GeodeticDatumOperation getGeodeticDatumOperation(Code code) {
        return (GeodeticDatumOperation)this.m_geodeticDatumOperationMap.get(code);
    }

    @PrivateAPI
    public GeodeticDatumOperation getGeodeticDatumOperation(String srsName) {
        return (GeodeticDatumOperation)this.m_geodeticDatumOperationMap.get(srsName);
    }

    @PrivateAPI
    public Set<GeodeticDatumOperation> getGeodeticDatumOperationSet(GeodeticDatum d, double shiftX, double shiftY, double shiftZ, double rotateX, double rotateY, double rotateZ, double scaleAdjust) {
        return this.m_geodeticDatumOperationMap.get(d, shiftX, shiftY, shiftZ, rotateX, rotateY, rotateZ, scaleAdjust);
    }

    @PrivateAPI
    public void add(GeodeticDatum datum) {
        for (Code c : datum.getCodes()) {
            this.m_geodeticDatumMap.put(c.getCodeSpace(), c.getCode(), datum);
        }
    }

    @PrivateAPI
    public GeodeticDatum getGeodeticDatum(String codeSpace, String code) {
        return (GeodeticDatum)this.m_geodeticDatumMap.get(codeSpace, code);
    }

    @PrivateAPI
    public GeodeticDatum getGeodeticDatum(Code code) {
        return (GeodeticDatum)this.m_geodeticDatumMap.get(code);
    }

    @PrivateAPI
    public GeodeticDatum getGeodeticDatum(String srsName) {
        return (GeodeticDatum)this.m_geodeticDatumMap.get(srsName);
    }

    @PrivateAPI
    public Set<GeodeticDatum> getGeodeticDatumSet(Ellipsoid e, PrimeMeridian primeMeridian) {
        return this.m_geodeticDatumMap.get(e, primeMeridian);
    }

    @PrivateAPI
    public void add(Ellipsoid ellipsoid) {
        for (Code c : ellipsoid.getCodes()) {
            this.m_ellipsoidMap.put(c.getCodeSpace(), c.getCode(), ellipsoid);
        }
    }

    @PrivateAPI
    public Ellipsoid getEllipsoid(String codeSpace, String code) {
        return (Ellipsoid)this.m_ellipsoidMap.get(codeSpace, code);
    }

    @PrivateAPI
    public Ellipsoid getEllipsoid(Code code) {
        return (Ellipsoid)this.m_ellipsoidMap.get(code);
    }

    @PrivateAPI
    public Ellipsoid getEllipsoid(String srsName) {
        return (Ellipsoid)this.m_ellipsoidMap.get(srsName);
    }

    @PrivateAPI
    public Set<Ellipsoid> getEllipsoidSet(double semiMajorAxis, double inverseFlattening) {
        return this.m_ellipsoidMap.get(semiMajorAxis, inverseFlattening);
    }

    @PrivateAPI
    public void add(IProjectionFactory projectionFactory) {
        for (Code c : projectionFactory.getSupportedCodes()) {
            this.m_projectionFactoryMap.put(c.getCodeSpace(), c.getCode(), projectionFactory);
        }
    }

    @PrivateAPI
    public IProjectionFactory getProjectionFactory(String codeSpace, String code) {
        return this.m_projectionFactoryMap.get(codeSpace, code);
    }

    @PrivateAPI
    public IProjectionFactory getProjectionFactory(Code code) {
        return this.m_projectionFactoryMap.get(code);
    }

    @PrivateAPI
    public IProjectionFactory getProjectionFactory(String srsName) {
        return this.m_projectionFactoryMap.get(srsName);
    }

    private static void readCoordSysConfig() {
        XmlReaderImpl reader = null;
        try {
            InputStream is = CoordSysFactory.class.getResourceAsStream(COORDSYS_XML_FILE);
            if (is == null) {
                throw new RuntimeException(new FileNotFoundException("coordsys.xml not found on the CLASSPATH."));
            }
            reader = new XmlReaderImpl((InputStream)new BufferedInputStream(is), false);
            CoordSysConfigReader.read((IXmlReader)reader, DEFAULT);
        }
        catch (XmlReaderException e) {
            try {
                throw new InvalidCoordSysXMLFileException(COORDSYS_XML_FILE, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)reader);
    }

    private CoordSys getCoordSysFromCodeWithBounds(Code codeWithNoBounds) {
        Code codeWithBounds = CoordSysUtilities.addBounds(codeWithNoBounds);
        return this.m_coordSysMap.get(codeWithBounds);
    }

    static {
        HashMap<Code, DoubleRect> bounds = new HashMap<Code, DoubleRect>();
        bounds.put(new Code("mapinfo", "coordsys 10, 157, 7, 0.0"), new DoubleRect(-2.003750834E7, -2.003750834E7, 2.003750834E7, 2.003750834E7));
        bounds.put(new Code("mapinfo", "coordsys 1, 104"), new DoubleRect(-180.0, -90.0, 180.0, 90.0));
        bounds.put(new Code("epsg", "27700"), new DoubleRect(0.0, 0.0, 700000.0, 1300000.0));
        BOUNDS = bounds;
        DEFAULT.add(new CylindricalEqualAreaFactory());
        DEFAULT.add(new LambertConformalConicFactory());
        DEFAULT.add(new LambertAzimuthalEqualAreaFactory());
        DEFAULT.add(new AzimuthalEquidistantFactory());
        DEFAULT.add(new EquidistantConicFactory());
        DEFAULT.add(new HotineObliqueMercatorFactory());
        DEFAULT.add(new TransverseMercatorFactory());
        DEFAULT.add(new AlbersEqualAreaConicFactory());
        DEFAULT.add(new MercatorFactory());
        DEFAULT.add(new MillerFactory());
        DEFAULT.add(new RobinsonFactory());
        DEFAULT.add(new MollweideFactory());
        DEFAULT.add(new EckertIVFactory());
        DEFAULT.add(new EckertVIFactory());
        DEFAULT.add(new SinusoidalFactory());
        DEFAULT.add(new GallFactory());
        DEFAULT.add(new NewZealandMapGridFactory());
        DEFAULT.add(new LambertConformalConicBelgium1972Factory());
        DEFAULT.add(new StereographicFactory());
        DEFAULT.add(new TransverseMercatorDenmarkS34JFactory());
        DEFAULT.add(new TransverseMercatorDenmarkS34SFactory());
        DEFAULT.add(new TransverseMercatorDenmarkS45BFactory());
        DEFAULT.add(new TransverseMercatorFinlandFactory());
        DEFAULT.add(new SwissObliqueMercatorFactory());
        DEFAULT.add(new RegionalMercatorFactory());
        DEFAULT.add(new PolyconicFactory());
        DEFAULT.add(new CassiniSoldnerFactory());
        DEFAULT.add(new DoubleStereographicFactory());
        DEFAULT.add(new KrovakFactory());
        DEFAULT.add(new EquidistantCylindricalFactory());
        DEFAULT.add(new TransverseMercatorExtendedFactory());
        DEFAULT.add(new RectifiedSkewOrthomorphicFactory());
        CoordSysFactory.readCoordSysConfig();
        for (LegacyCoordSysParams params : PRJCoordSysProvider.list()) {
            DEFAULT.add(DEFAULT.build(params));
        }
    }

    private static class GeodeticDatumOperationFactory
    extends CodeMap<GeodeticDatumOperation> {
        private GeodeticDatumOperationFactory() {
        }

        private Set<GeodeticDatumOperation> get(GeodeticDatum d, double shiftX, double shiftY, double shiftZ, double rotateX, double rotateY, double rotateZ, double scaleAdjust) {
            return this.getFromHash(CoordSysHashUtilities.calcGeodeticDatumOperationHash(null, d, shiftX, shiftY, shiftZ, rotateX, rotateY, rotateZ, scaleAdjust));
        }

        @Override
        protected Integer calculateHash(GeodeticDatumOperation d) {
            return CoordSysHashUtilities.calcGeodeticDatumOperationHash(null, d.getGeodeticDatum(), d.getShiftX(), d.getShiftY(), d.getShiftZ(), d.getRotateX(), d.getRotateY(), d.getRotateZ(), d.getScaleAdjust());
        }
    }

    private static class GeodeticDatumFactory
    extends CodeMap<GeodeticDatum> {
        private GeodeticDatumFactory() {
        }

        private Set<GeodeticDatum> get(Ellipsoid e, PrimeMeridian primeMeridian) {
            return this.getFromHash(CoordSysHashUtilities.calcGeodeticDatumHash(null, e, primeMeridian));
        }

        @Override
        protected Integer calculateHash(GeodeticDatum d) {
            return CoordSysHashUtilities.calcGeodeticDatumHash(null, d.getEllipsoid(), d.getPrimeMeridian());
        }
    }

    private static class EllipsoidFactory
    extends CodeMap<Ellipsoid> {
        private EllipsoidFactory() {
        }

        private Set<Ellipsoid> get(double semiMajorAxis, double inverseFlattening) {
            return this.getFromHash(CoordSysHashUtilities.calcEllipsoidHash(null, semiMajorAxis, inverseFlattening));
        }

        @Override
        protected Integer calculateHash(Ellipsoid e) {
            return CoordSysHashUtilities.calcEllipsoidHash(null, e.getSemiMajorAxis(), e.getInverseFlattening());
        }
    }
}

