/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.parser;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.Ellipsoid;
import com.mapinfo.midev.coordsys.GeodeticDatum;
import com.mapinfo.midev.coordsys.GeodeticDatumOperation;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.coordsys.parser.LegacyCoordSysParams;
import com.mapinfo.midev.coordsys.parser.LegacyEllipsoidParser;
import com.mapinfo.midev.coordsys.parser.LegacyGeodeticDatumParser;
import com.mapinfo.midev.util.Code;
import java.util.Set;

public class LegacyCoordSysParser {
    private LegacyCoordSysParser() {
    }

    public static CodeSet buildCodeSet(LegacyCoordSysParams params) {
        String mapInfoCode = params.toMapInfoCode();
        CodeSet codeSet = params.getCodeSpace() != null && params.getCode() != null ? ("mapinfo".equals(params.getCodeSpace()) ? new CodeSet("mapinfo", mapInfoCode) : new CodeSet(new Code("mapinfo", mapInfoCode), new Code(params.getCodeSpace(), params.getCode()))) : new CodeSet("mapinfo", params.toMapInfoCode());
        return codeSet;
    }

    public static GeodeticDatumOperation buildDatumOperation(LegacyCoordSysParams params) {
        GeodeticDatumOperation result;
        int datumIndex = params.getDatumIndex();
        if (datumIndex == 999 || datumIndex == 9999) {
            Ellipsoid ellipsoid = LegacyEllipsoidParser.parse(params.getEllipsoidIndex());
            Set<GeodeticDatum> datumSet = CoordSysFactory.getDefaultCoordSysFactory().getGeodeticDatumSet(ellipsoid, params.getPrimeMeridian());
            GeodeticDatum datum = datumSet.isEmpty() ? new GeodeticDatum(null, null, ellipsoid, params.getPrimeMeridian()) : datumSet.iterator().next();
            Set<GeodeticDatumOperation> opSet = CoordSysFactory.getDefaultCoordSysFactory().getGeodeticDatumOperationSet(datum, params.getDatumShiftX(), params.getDatumShiftY(), params.getDatumShiftZ(), params.getDatumRotateX(), params.getDatumRotateY(), params.getDatumRotateZ(), params.getDatumScaleAdjust());
            if (opSet.isEmpty()) {
                result = new GeodeticDatumOperation(null, null, datum, params.getDatumShiftX(), params.getDatumShiftY(), params.getDatumShiftZ(), params.getDatumRotateX(), params.getDatumRotateY(), params.getDatumRotateZ(), params.getDatumScaleAdjust());
            } else {
                result = opSet.iterator().next();
                Code newDatumCode = result.getCodes().getFirstCode("mapinfo");
                if (newDatumCode != null) {
                    params.setDatumIndex(Integer.parseInt(newDatumCode.getCode().substring("geodeticdatumoperation".length())));
                }
            }
        } else {
            result = LegacyGeodeticDatumParser.parse(datumIndex);
            if (result == null) {
                throw new UnsupportedOperationException("Unknown datum index: " + datumIndex);
            }
        }
        return result;
    }
}

