/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.parser;

import com.mapinfo.midev.coordsys.parser.InvalidMapBasicAffineTransformException;
import com.mapinfo.midev.coordsys.parser.InvalidMapBasicBoundsException;
import com.mapinfo.midev.coordsys.parser.InvalidMapBasicCoordSysStatement;
import com.mapinfo.midev.coordsys.parser.LegacyCoordSysParams;
import com.mapinfo.midev.coordsys.parser.PRJCoordSysParser;
import com.mapinfo.midev.geometry.AffineTransform;
import com.mapinfo.midev.util.DoubleRect;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MapBasicCoordSysParser {
    private MapBasicCoordSysParser() {
    }

    public static LegacyCoordSysParams parse(String s) {
        LegacyCoordSysParams params;
        String[] ss = MapBasicCoordSysParser.parseCoordSysString(s);
        Matcher m = Pattern.compile("CoordSys\\s+Earth\\s+Projection\\s+(.+)", 10).matcher(ss[0]);
        if (m.matches()) {
            params = PRJCoordSysParser.parsePrjString(m.group(1));
        } else {
            m = Pattern.compile("CoordSys\\s+NonEarth\\s+Units\\s+(.+)", 10).matcher(ss[0]);
            if (m.matches()) {
                params = MapBasicCoordSysParser.parseNonEarthString(m.group(1));
            } else {
                throw new InvalidMapBasicCoordSysStatement(s);
            }
        }
        if (ss[1] != null) {
            params.setAffineTransform(MapBasicCoordSysParser.parseAffineTransform(ss[1]));
        }
        if (ss[2] != null) {
            DoubleRect bounds = MapBasicCoordSysParser.parseBounds(ss[2]);
        }
        return params;
    }

    private static String[] parseCoordSysString(String s) {
        String[] ss = null;
        String affineClause = null;
        String boundsClause = null;
        String csysClause = s.trim().replaceAll("\\s+", " ");
        ss = Pattern.compile("\\s+Bounds\\s+", 10).split(csysClause);
        if (ss.length < 1 || ss.length > 2) {
            throw new InvalidMapBasicCoordSysStatement(s);
        }
        if (ss.length == 2) {
            boundsClause = ss[1];
        }
        csysClause = ss[0];
        ss = Pattern.compile("\\s+Affine\\s+Units\\s+", 10).split(csysClause);
        if (ss.length < 1 || ss.length > 2) {
            throw new InvalidMapBasicCoordSysStatement(s);
        }
        if (ss.length == 2) {
            affineClause = ss[1];
        }
        csysClause = ss[0];
        ss = new String[]{csysClause, affineClause, boundsClause};
        return ss;
    }

    private static LegacyCoordSysParams parseNonEarthString(String s) {
        LegacyCoordSysParams params = new LegacyCoordSysParams();
        params.setProjectionType(0);
        params.setDatumIndex(-1);
        params.setPrimeMeridian(null);
        params.setLinearUnit(PRJCoordSysParser.parseLinearUnit(s));
        return params;
    }

    private static AffineTransform parseAffineTransform(String s) {
        String[] ss = s.split("\\s*,\\s*");
        if (ss.length != 7) {
            throw new InvalidMapBasicAffineTransformException(s);
        }
        return PRJCoordSysParser.parseAffineTransform(ss, 0);
    }

    private static DoubleRect parseBounds(String s) {
        Object bounds = null;
        Matcher m = Pattern.compile("\\(\\s*(.+),\\s*(.*)\\s*\\)\\s*\\(\\s*(.+),\\s*(.*)\\s*\\)", 10).matcher(s);
        if (m.matches() || m.groupCount() != 4) {
            return new DoubleRect(Double.parseDouble(m.group(1)), Double.parseDouble(m.group(2)), Double.parseDouble(m.group(3)), Double.parseDouble(m.group(4)));
        }
        throw new InvalidMapBasicBoundsException(s);
    }
}

