/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.MathUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AlbersEqualAreaConicFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE, ProjectionParamType.ORIGIN_LATITUDE, ProjectionParamType.STANDARD_PARALLEL_1, ProjectionParamType.STANDARD_PARALLEL_2, ProjectionParamType.FALSE_EASTING, ProjectionParamType.FALSE_NORTHING};
    private static final Set<Code> CODE_SET;

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return new AlbersEqualAreaConic(new CodeSet(this.getSupportedCodes()), projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("epsg", "9822"));
        result.add(new Code("mapinfo", "projection9"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class AlbersEqualAreaConic
    extends Projection
    implements Serializable {
        private double m_e;
        private double m_one_minus_e2;
        private double m_one_over_2e;
        private double m_lambda0;
        private double m_n;
        private double m_a_over_n;
        private double m_n2_over_a2;
        private double m_C;
        private double m_rho0;
        private double m_DivQ;
        private double m_Aprime;
        private double m_Bprime;
        private double m_Cprime;
        private boolean m_bZeroE;
        private boolean m_bNegativeN;

        public AlbersEqualAreaConic(CodeSet codeSet, ProjectionParams projectionParams) {
            super("Albers Equal-Area Conic", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            int i;
            ProjectionParams projectionParams = this.getProjectionParams();
            double[] phi = new double[3];
            double[] sinphi = new double[3];
            double[] esinphi = new double[3];
            double[] esinphi2 = new double[3];
            double[] m = new double[3];
            double[] q = new double[3];
            this.m_e = projectionParams.getEllipsoid().getEccentricity();
            this.m_one_minus_e2 = 1.0 - projectionParams.getEllipsoid().getEccentricitySquared();
            boolean bl = this.m_bZeroE = this.m_e == 0.0;
            if (!this.m_bZeroE) {
                this.m_one_over_2e = 1.0 / (2.0 * this.m_e);
            }
            this.m_lambda0 = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
            phi[0] = CoordSysUtilities.convertClip(projectionParams.getOriginLatitude(), AngularUnit.RADIAN, -90.0, 90.0);
            phi[1] = CoordSysUtilities.convertClip(projectionParams.getStandardParallel1(), AngularUnit.RADIAN, -90.0, 90.0);
            phi[2] = CoordSysUtilities.convertClip(projectionParams.getStandardParallel2(), AngularUnit.RADIAN, -90.0, 90.0);
            for (i = 0; i < 3; ++i) {
                sinphi[i] = Math.sin(phi[i]);
                esinphi[i] = this.m_e * sinphi[i];
                esinphi2[i] = esinphi[i] * esinphi[i];
            }
            for (i = 1; i < 3; ++i) {
                m[i] = Math.cos(phi[i]) / Math.sqrt(1.0 - esinphi2[i]);
            }
            for (i = 0; i < 3; ++i) {
                q[i] = this.m_bZeroE ? 2.0 * sinphi[i] : this.m_one_minus_e2 * (sinphi[i] / (1.0 - esinphi2[i]) - this.m_one_over_2e * Math.log((1.0 - esinphi[i]) / (1.0 + esinphi[i])));
            }
            double temp = q[2] - q[1];
            this.m_n = temp != 0.0 ? (m[1] * m[1] - m[2] * m[2]) / temp : sinphi[1];
            if (this.m_n == 0.0) {
                this.m_n = 1.0;
            }
            this.m_a_over_n = projectionParams.getEllipsoid().getSemiMajorAxis() / this.m_n;
            this.m_n2_over_a2 = this.m_n * this.m_n / (projectionParams.getEllipsoid().getSemiMajorAxis() * projectionParams.getEllipsoid().getSemiMajorAxis());
            this.m_bNegativeN = this.m_n < 0.0;
            this.m_C = m[1] * m[1] + this.m_n * q[1];
            temp = this.m_C - this.m_n * q[0];
            this.m_rho0 = temp > 0.0 ? this.m_a_over_n * Math.sqrt(temp) : 0.0;
            this.m_DivQ = this.m_bZeroE ? 1.0 : 1.0 - this.m_one_minus_e2 * this.m_one_over_2e * Math.log((1.0 - this.m_e) / (1.0 + this.m_e));
            double e4 = projectionParams.getEllipsoid().getEccentricitySquared() * projectionParams.getEllipsoid().getEccentricitySquared();
            double e6 = projectionParams.getEllipsoid().getEccentricitySquared() * e4;
            double A = projectionParams.getEllipsoid().getEccentricitySquared() / 3.0 + 31.0 * e4 / 180.0 + 517.0 * e6 / 5040.0;
            double B = 23.0 * e4 / 360.0 + 251.0 * e6 / 3780.0;
            double C = 761.0 * e6 / 45360.0;
            this.m_Aprime = A - C;
            this.m_Bprime = 2.0 * B;
            this.m_Cprime = 4.0 * C;
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = CoordSysUtilities.convertClip(source.getX(), AngularUnit.DEGREE, AngularUnit.RADIAN, -360.0, 360.0);
            double y = CoordSysUtilities.convertClip(source.getY(), AngularUnit.DEGREE, AngularUnit.RADIAN, -90.0, 90.0);
            double lambda = x;
            double phi = y;
            double sinphi = Math.sin(phi);
            double esinphi = this.m_e * sinphi;
            double esinphi2 = esinphi * esinphi;
            double q = this.m_bZeroE ? 2.0 * sinphi : this.m_one_minus_e2 * (sinphi / (1.0 - esinphi2) - this.m_one_over_2e * Math.log((1.0 - esinphi) / (1.0 + esinphi)));
            double temp = this.m_C - this.m_n * q;
            double rho = temp > 0.0 ? this.m_a_over_n * Math.sqrt(temp) : 0.0;
            double theta = this.m_n * (lambda - this.m_lambda0);
            x = rho * Math.sin(theta);
            y = this.m_rho0 - rho * Math.cos(theta);
            x = LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit());
            y = LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit());
            destination.setXY(x + projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit()), y + projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = source.getX() - projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit());
            double y = source.getY() - projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit());
            x = LinearUnit.convert((double)x, (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            y = LinearUnit.convert((double)y, (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double ydiff = this.m_rho0 - y;
            double rho = Math.sqrt(x * x + ydiff * ydiff);
            if (this.m_bNegativeN) {
                x = -x;
                ydiff = -ydiff;
            }
            double theta = x != 0.0 || ydiff != 0.0 ? Math.atan2(x, ydiff) : 0.0;
            double q = (this.m_C - rho * rho * this.m_n2_over_a2) / this.m_n;
            double temp = q / this.m_DivQ;
            double beta = Math.asin(MathUtil.clip((double)temp, (double)-1.0, (double)1.0));
            x = this.m_lambda0 + theta / this.m_n;
            double beta2 = 2.0 * beta;
            double cosbeta2 = Math.cos(beta2);
            y = beta + Math.sin(beta2) * (this.m_Aprime + cosbeta2 * (this.m_Bprime + cosbeta2 * this.m_Cprime));
            destination.setXY(CoordSysUtilities.convertClip(x, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0), CoordSysUtilities.convertClip(y, AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0));
            return destination;
        }
    }
}

