/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.MathUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AzimuthalEquidistantFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE, ProjectionParamType.ORIGIN_LATITUDE, ProjectionParamType.RANGE};
    private static final Set<Code> CODE_SET;

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        double originLatitude = projectionParams.getOriginLatitude().getValue(AngularUnit.DEGREE);
        CodeSet codeSet = originLatitude == 90.0 || originLatitude == -90.0 ? new CodeSet("mapinfo", "projection5") : new CodeSet("mapinfo", "projection28");
        return new AzimuthalEquidistant(codeSet, projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("mapinfo", "projection5"));
        result.add(new Code("mapinfo", "projection28"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class AzimuthalEquidistant
    extends Projection
    implements Serializable {
        private double m_phi1;
        private double m_sinphi1;
        private double m_cosphi1;
        private double m_R;
        private double m_lambda0;
        private double m_radius;
        private double m_MinY;
        private double m_MaxY;
        private int m_polar;

        public AzimuthalEquidistant(CodeSet codeSet, ProjectionParams projectionParams) {
            super("Azimuthal Equidistant", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            ProjectionParams projectionParams = this.getProjectionParams();
            this.m_lambda0 = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
            this.m_phi1 = MathUtil.clip((double)projectionParams.getOriginLatitude().getValue(AngularUnit.DEGREE), (double)-90.0, (double)90.0);
            this.m_polar = this.m_phi1 == 90.0 ? 1 : (this.m_phi1 == -90.0 ? -1 : 0);
            this.m_phi1 = Math.toRadians(this.m_phi1);
            this.m_sinphi1 = Math.sin(this.m_phi1);
            this.m_cosphi1 = Math.cos(this.m_phi1);
            this.m_R = projectionParams.getEllipsoid().getSemiMajorAxis();
            double range = CoordSysUtilities.convertClip(projectionParams.getRange(), AngularUnit.RADIAN, 1.0, 180.0);
            this.m_radius = this.m_R * range;
            this.m_MinY = MathUtil.clip((double)(this.m_phi1 - range), (double)-1.5707963267948966, (double)1.5707963267948966);
            this.m_MaxY = MathUtil.clip((double)(this.m_phi1 + range), (double)-1.5707963267948966, (double)1.5707963267948966);
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            double temp;
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = CoordSysUtilities.convertClip(source.getX(), AngularUnit.DEGREE, AngularUnit.RADIAN, -360.0, 360.0);
            double y = CoordSysUtilities.convertClip(source.getY(), AngularUnit.DEGREE, AngularUnit.RADIAN, -90.0, 90.0);
            double lambdadiff = x - this.m_lambda0;
            if (1 == this.m_polar) {
                temp = this.m_R * (1.5707963267948966 - y);
                x = temp * Math.sin(lambdadiff);
                y = -temp * Math.cos(lambdadiff);
            } else if (-1 == this.m_polar) {
                temp = this.m_R * (1.5707963267948966 + y);
                x = temp * Math.sin(lambdadiff);
                y = temp * Math.cos(lambdadiff);
            } else {
                double cosphi = Math.cos(y);
                double sinphi = Math.sin(y);
                double coslambdadiff = Math.cos(lambdadiff);
                double c = Math.acos(this.m_sinphi1 * sinphi + this.m_cosphi1 * cosphi * coslambdadiff);
                double kprime = c / Math.sin(c);
                temp = this.m_R * kprime;
                x = temp * cosphi * Math.sin(lambdadiff);
                y = temp * (this.m_cosphi1 * sinphi - this.m_sinphi1 * cosphi * coslambdadiff);
            }
            temp = Math.sqrt(x * x + y * y);
            if (temp > this.m_radius) {
                temp = this.m_radius / temp;
                x *= temp;
                y *= temp;
            }
            destination.setXY(LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()), LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = LinearUnit.convert((double)source.getX(), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double y = LinearUnit.convert((double)source.getY(), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double rho = Math.sqrt((x = MathUtil.clip((double)x, (double)-1.0E9, (double)1.0E9)) * x + (y = MathUtil.clip((double)y, (double)-1.0E9, (double)1.0E9)) * y);
            if (rho != 0.0) {
                double c = rho / this.m_R;
                double cosc = Math.cos(c);
                if (0 != this.m_polar) {
                    x = this.m_lambda0 + Math.atan2(x, (double)(-this.m_polar) * y);
                    y = Math.asin(MathUtil.clip((double)(cosc * this.m_sinphi1), (double)-1.0, (double)1.0));
                } else {
                    double sinc = Math.sin(c);
                    x = this.m_lambda0 + Math.atan2(x * sinc, rho * this.m_cosphi1 * cosc - y * this.m_sinphi1 * sinc);
                    y = Math.asin(MathUtil.clip((double)(cosc * this.m_sinphi1 + y * sinc * this.m_cosphi1 / rho), (double)-1.0, (double)1.0));
                }
                y = MathUtil.clip((double)y, (double)this.m_MinY, (double)this.m_MaxY);
            } else {
                x = this.m_lambda0;
                y = this.m_phi1;
            }
            if (x > Math.PI) {
                x -= Math.PI * 2;
            }
            if (x < -Math.PI) {
                x += Math.PI * 2;
            }
            destination.setXY(CoordSysUtilities.convertClip(x, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0), CoordSysUtilities.convertClip(y, AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0));
            return destination;
        }
    }
}

