/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.MathUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DoubleStereographicFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE, ProjectionParamType.ORIGIN_LATITUDE, ProjectionParamType.SCALE_FACTOR, ProjectionParamType.FALSE_EASTING, ProjectionParamType.FALSE_NORTHING};
    private static final Set<Code> CODE_SET;

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return new DoubleStereographic(new CodeSet(this.getSupportedCodes()), projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("mapinfo", "projection31"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class DoubleStereographic
    extends Projection
    implements Serializable {
        private static final double DBLS_EPSILON = 1.0E-12;
        private static final int DBLS_MAX_ITERATION = 30;
        private double m_c1;
        private double m_c2;
        private double m_chi0;
        private double m_LAMBDA0;
        private double m_R;

        public DoubleStereographic(CodeSet codeSet, ProjectionParams projectionParams) {
            super("Double Stereographic", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            ProjectionParams projectionParams = this.getProjectionParams();
            double phi0 = CoordSysUtilities.convertClip(projectionParams.getOriginLatitude(), AngularUnit.RADIAN, -90.0, 90.0);
            double sinphi0 = Math.sin(phi0);
            this.m_c1 = Math.sqrt(1.0 + projectionParams.getEllipsoid().getEccentricitySquared() * Math.pow(Math.cos(phi0), 4.0) / (1.0 - projectionParams.getEllipsoid().getEccentricitySquared()));
            this.m_chi0 = Math.asin(MathUtil.clip((double)(sinphi0 / this.m_c1), (double)-1.0, (double)1.0));
            double temp1 = Math.tan(0.7853981633974483 + this.m_chi0 / 2.0);
            double temp2 = Math.pow((1.0 - projectionParams.getEllipsoid().getEccentricity() * sinphi0) / (1.0 + projectionParams.getEllipsoid().getEccentricity() * sinphi0), projectionParams.getEllipsoid().getEccentricity() / 2.0);
            this.m_c2 = temp1 * Math.pow(Math.tan(0.7853981633974483 + phi0 / 2.0) * temp2, -this.m_c1);
            double lambda0 = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
            this.m_LAMBDA0 = this.m_c1 * lambda0;
            double temp3 = 1.0 - projectionParams.getEllipsoid().getEccentricitySquared() * sinphi0 * sinphi0;
            double sqrtof_temp3 = Math.sqrt(temp3);
            double M0 = projectionParams.getEllipsoid().getSemiMajorAxis() * (1.0 - projectionParams.getEllipsoid().getEccentricitySquared()) / (temp3 * sqrtof_temp3);
            double N0 = projectionParams.getEllipsoid().getSemiMajorAxis() / sqrtof_temp3;
            this.m_R = Math.sqrt(M0 * N0);
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double sinchi0 = Math.sin(this.m_chi0);
            double coschi0 = Math.cos(this.m_chi0);
            double x = CoordSysUtilities.convertClip(source.getX(), AngularUnit.DEGREE, AngularUnit.RADIAN, -360.0, 360.0);
            double y = CoordSysUtilities.convertClip(source.getY(), AngularUnit.DEGREE, AngularUnit.RADIAN, -90.0, 90.0);
            DirectPosition dp = this.DblStereographicEllipsToSphere(x, y);
            double chi = dp.getY();
            double LAMBDA = dp.getX();
            double coschi = Math.cos(chi);
            double sinchi = Math.sin(chi);
            double sindeltaLAMBDA = Math.sin(LAMBDA - this.m_LAMBDA0);
            double cosdeltaLAMBDA = Math.cos(LAMBDA - this.m_LAMBDA0);
            double denominator = 1.0 + sinchi * sinchi0 + coschi * coschi0 * cosdeltaLAMBDA;
            if (denominator == 0.0) {
                denominator = 1.0;
            }
            x = 2.0 * projectionParams.getScaleFactor() * this.m_R * coschi * sindeltaLAMBDA / denominator;
            y = 2.0 * projectionParams.getScaleFactor() * this.m_R * (sinchi * coschi0 - coschi * sinchi0 * cosdeltaLAMBDA) / denominator;
            x = LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit());
            y = LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit());
            destination.setXY(x += projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit()), y += projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            double cosB;
            double sinB;
            ProjectionParams projectionParams = this.getProjectionParams();
            double sinchi0 = Math.sin(this.m_chi0);
            double coschi0 = Math.cos(this.m_chi0);
            double x = source.getX() - projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit());
            double y = source.getY() - projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit());
            x = LinearUnit.convert((double)x, (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            y = LinearUnit.convert((double)y, (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double xprime = x / projectionParams.getScaleFactor();
            double yprime = y / projectionParams.getScaleFactor();
            double s = Math.sqrt(xprime * xprime + yprime * yprime);
            double delta = 2.0 * Math.atan(s / (2.0 * this.m_R));
            if (s == 0.0) {
                sinB = 0.0;
                cosB = 1.0;
            } else {
                cosB = xprime / s;
                sinB = yprime / s;
            }
            double chi = y = Math.asin(MathUtil.clip((double)(sinchi0 * Math.cos(delta) + Math.sin(delta) * coschi0 * sinB), (double)-1.0, (double)1.0));
            x = Math.cos(chi) == 0.0 ? this.m_LAMBDA0 : this.m_LAMBDA0 + Math.asin(MathUtil.clip((double)(Math.sin(delta) * cosB / Math.cos(chi)), (double)-1.0, (double)1.0));
            DirectPosition tmp = this.DblStereographicSphereToEllips(x, y);
            destination.setXY(CoordSysUtilities.convertClip(tmp.getX(), AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0), CoordSysUtilities.convertClip(tmp.getY(), AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0));
            return destination;
        }

        private DirectPosition DblStereographicEllipsToSphere(double x, double y) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double phi = y;
            double lambda = x;
            double esinphi = projectionParams.getEllipsoid().getEccentricity() * Math.sin(phi);
            double temp1 = Math.tan(0.7853981633974483 + phi / 2.0);
            double temp2 = Math.pow((1.0 - esinphi) / (1.0 + esinphi), projectionParams.getEllipsoid().getEccentricity() / 2.0);
            double temp3 = this.m_c2 * Math.pow(temp1 * temp2, this.m_c1);
            return new DirectPosition(this.m_c1 * lambda, 2.0 * Math.atan(temp3) - 1.5707963267948966);
        }

        private DirectPosition DblStereographicSphereToEllips(double x, double y) {
            double itprev;
            double chi = y;
            double LAMBDA = x;
            double itval = itprev = chi;
            double diff = 1.0;
            for (int counter = 1; diff > 1.0E-12 && counter <= 30; ++counter) {
                itval = this.DblStereographicNextIteration(itprev, chi);
                diff = Math.abs(itval - itprev);
                itprev = itval;
            }
            return new DirectPosition(LAMBDA / this.m_c1, itval);
        }

        private double DblStereographicNextIteration(double phi, double chi) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double temp1 = Math.tan(0.7853981633974483 + phi / 2.0);
            double esinphi = projectionParams.getEllipsoid().getEccentricity() * Math.sin(phi);
            double temp2 = Math.pow((1.0 - esinphi) / (1.0 + esinphi), projectionParams.getEllipsoid().getEccentricity() / 2.0);
            double sec = 1.0 / Math.cos(0.7853981633974483 + phi / 2.0);
            double sec2 = sec * sec;
            double f = this.m_c2 * Math.pow(temp1 * temp2, this.m_c1) - Math.tan(0.7853981633974483 + chi / 2.0);
            double fprime = this.m_c1 * this.m_c2 * Math.pow(temp1 * temp2, this.m_c1 - 1.0) * temp2 * (0.5 * sec2 - projectionParams.getEllipsoid().getEccentricity() * projectionParams.getEllipsoid().getEccentricity() * Math.cos(phi) * temp1 / (1.0 - esinphi * esinphi));
            return fprime == 0.0 ? phi : phi - f / fprime;
        }
    }
}

