/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.MathUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EckertIVFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE};
    private static final Set<Code> CODE_SET;

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return new EckertIV(new CodeSet(this.getSupportedCodes()), projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("mapinfo", "projection14"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class EckertIV
    extends Projection
    implements Serializable {
        private double m_lambda0;
        private double m_MultX;
        private double m_MultY;

        public EckertIV(CodeSet codeSet, ProjectionParams projectionParams) {
            super("Eckert IV", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            ProjectionParams projectionParams = this.getProjectionParams();
            double r = projectionParams.getEllipsoid().getSemiMajorAxis();
            this.m_MultX = 2.0 * r / Math.sqrt(22.43597501544853);
            this.m_MultY = 2.0 * r * Math.sqrt(0.43990084648844263);
            this.m_lambda0 = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            double costheta;
            double sintheta;
            double delta;
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = CoordSysUtilities.convertClip(source.getX(), AngularUnit.DEGREE, AngularUnit.RADIAN, -360.0, 360.0);
            double y = CoordSysUtilities.convertClip(source.getY(), AngularUnit.DEGREE, AngularUnit.RADIAN, -90.0, 90.0);
            double lambda = x;
            double phi = y;
            double temp = 3.5707963267948966 * Math.sin(phi);
            double theta = phi / 2.0;
            while (!((delta = (theta + (sintheta = Math.sin(theta)) * ((costheta = Math.cos(theta)) + 2.0) - temp) / (2.0 * costheta * (1.0 + costheta))) > -1.0E-7) || !(delta < 1.0E-7)) {
                theta -= delta;
            }
            x = this.m_MultX * (lambda - this.m_lambda0) * (1.0 + costheta);
            y = this.m_MultY * sintheta;
            destination.setXY(LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()), LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = LinearUnit.convert((double)source.getX(), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double y = LinearUnit.convert((double)source.getY(), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double temp = y / this.m_MultY;
            double theta = Math.asin(MathUtil.clip((double)temp, (double)-1.0, (double)1.0));
            double costheta = Math.cos(theta);
            temp = (theta + Math.sin(theta) * (costheta + 2.0)) / 3.5707963267948966;
            y = Math.asin(MathUtil.clip((double)temp, (double)-1.0, (double)1.0));
            x = this.m_lambda0 + x / (this.m_MultX * (1.0 + costheta));
            destination.setXY(CoordSysUtilities.convertClip(x, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0), CoordSysUtilities.convertClip(y, AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0));
            return destination;
        }
    }
}

