/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.MathUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EquidistantConicFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE, ProjectionParamType.ORIGIN_LATITUDE, ProjectionParamType.STANDARD_PARALLEL_1, ProjectionParamType.STANDARD_PARALLEL_2, ProjectionParamType.FALSE_EASTING, ProjectionParamType.FALSE_NORTHING};
    private static final Set<Code> CODE_SET;

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return new EquidistantConic(new CodeSet(this.getSupportedCodes()), projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("mapinfo", "projection6"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class EquidistantConic
    extends Projection
    implements Serializable {
        private double m_lambda0;
        private double m_n;
        private double m_aG;
        private double m_rho0;
        private double m_MultY;
        private double m_Aprime;
        private double m_Bprime;
        private double m_Cprime;
        private double m_Aprime2;
        private double m_Bprime2;
        private double m_Cprime2;
        private double m_Dprime2;
        private boolean m_bNegativeN;

        public EquidistantConic(CodeSet codeSet, ProjectionParams projectionParams) {
            super("Equidistant Conic", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            int i;
            ProjectionParams projectionParams = this.getProjectionParams();
            double[] phi = new double[3];
            double[] m = new double[3];
            double[] M = new double[3];
            this.m_lambda0 = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
            double e = projectionParams.getEllipsoid().getEccentricity();
            phi[0] = CoordSysUtilities.convertClip(projectionParams.getOriginLatitude(), AngularUnit.RADIAN, -90.0, 90.0);
            phi[1] = CoordSysUtilities.convertClip(projectionParams.getStandardParallel1(), AngularUnit.RADIAN, -90.0, 90.0);
            phi[2] = CoordSysUtilities.convertClip(projectionParams.getStandardParallel2(), AngularUnit.RADIAN, -90.0, 90.0);
            double e4 = projectionParams.getEllipsoid().getEccentricitySquared() * projectionParams.getEllipsoid().getEccentricitySquared();
            double e6 = projectionParams.getEllipsoid().getEccentricitySquared() * e4;
            this.m_MultY = projectionParams.getEllipsoid().getSemiMajorAxis() * (1.0 - projectionParams.getEllipsoid().getEccentricitySquared() / 4.0 - 3.0 * e4 / 64.0 - 5.0 * e6 / 256.0);
            double A = projectionParams.getEllipsoid().getSemiMajorAxis() * -(3.0 * projectionParams.getEllipsoid().getEccentricitySquared() / 8.0 + 3.0 * e4 / 32.0 + 45.0 * e6 / 1024.0);
            double B = projectionParams.getEllipsoid().getSemiMajorAxis() * (15.0 * e4 / 256.0 + 45.0 * e6 / 1024.0);
            double C = projectionParams.getEllipsoid().getSemiMajorAxis() * -35.0 * e6 / 3072.0;
            this.m_Aprime = A - C;
            this.m_Bprime = 2.0 * B;
            this.m_Cprime = 4.0 * C;
            for (i = 0; i < 3; ++i) {
                double phi2 = phi[i] * 2.0;
                double cosphi2 = Math.cos(phi2);
                M[i] = this.m_MultY * phi[i] + Math.sin(phi2) * (this.m_Aprime + cosphi2 * (this.m_Bprime + cosphi2 * this.m_Cprime));
            }
            for (i = 1; i < 3; ++i) {
                double sinphi = Math.sin(phi[i]);
                m[i] = Math.cos(phi[i]) / Math.sqrt(1.0 - projectionParams.getEllipsoid().getEccentricitySquared() * sinphi * sinphi);
            }
            double temp = M[2] - M[1];
            this.m_n = temp != 0.0 ? projectionParams.getEllipsoid().getSemiMajorAxis() * (m[1] - m[2]) / temp : Math.sin(phi[1]);
            if (this.m_n == 0.0) {
                this.m_n = 1.0;
            }
            this.m_bNegativeN = this.m_n < 0.0;
            double G = m[1] / this.m_n + M[1] / projectionParams.getEllipsoid().getSemiMajorAxis();
            this.m_aG = projectionParams.getEllipsoid().getSemiMajorAxis() * G;
            this.m_rho0 = this.m_aG - M[0];
            temp = Math.sqrt(1.0 - projectionParams.getEllipsoid().getEccentricitySquared());
            double e1 = (1.0 - temp) / (1.0 + temp);
            double e12 = e1 * e1;
            double e13 = e12 * e1;
            double e14 = e12 * e12;
            A = 3.0 * e1 / 2.0 - 27.0 * e13 / 32.0;
            B = 21.0 * e12 / 16.0 - 55.0 * e14 / 32.0;
            C = 151.0 * e13 / 96.0;
            double D = 1097.0 * e14 / 512.0;
            this.m_Aprime2 = A - C;
            this.m_Bprime2 = 2.0 * B - 4.0 * D;
            this.m_Cprime2 = 4.0 * C;
            this.m_Dprime2 = 8.0 * D;
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            double y;
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = CoordSysUtilities.convertClip(source.getX(), AngularUnit.DEGREE, AngularUnit.RADIAN, -360.0, 360.0);
            double phi = y = CoordSysUtilities.convertClip(source.getY(), AngularUnit.DEGREE, AngularUnit.RADIAN, -90.0, 90.0);
            double theta = this.m_n * (x - this.m_lambda0);
            double phi2 = phi * 2.0;
            double cosphi2 = Math.cos(phi2);
            double M = this.m_MultY * phi + Math.sin(phi2) * (this.m_Aprime + cosphi2 * (this.m_Bprime + cosphi2 * this.m_Cprime));
            double rho = this.m_aG - M;
            x = rho * Math.sin(theta);
            y = this.m_rho0 - rho * Math.cos(theta);
            destination.setXY(LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()) + projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit()), LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()) + projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = LinearUnit.convert((double)(source.getX() - projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit())), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double y = LinearUnit.convert((double)(source.getY() - projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit())), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            x = MathUtil.clip((double)x, (double)-1.0E9, (double)1.0E9);
            y = MathUtil.clip((double)y, (double)-1.0E9, (double)1.0E9);
            double ydiff = this.m_rho0 - y;
            double rho = Math.sqrt(x * x + ydiff * ydiff);
            if (this.m_bNegativeN) {
                rho = -rho;
                x = -x;
                ydiff = -ydiff;
            }
            double theta = x != 0.0 || ydiff != 0.0 ? Math.atan2(x, ydiff) : 0.0;
            double M = this.m_aG - rho;
            double mu = M / this.m_MultY;
            x = this.m_lambda0 + theta / this.m_n;
            double mu2 = 2.0 * mu;
            double cosmu2 = Math.cos(mu2);
            y = mu + Math.sin(mu2) * (this.m_Aprime2 + cosmu2 * (this.m_Bprime2 + cosmu2 * (this.m_Cprime2 + cosmu2 * this.m_Dprime2)));
            destination.setXY(CoordSysUtilities.convertClip(x, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0), CoordSysUtilities.convertClip(y, AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0));
            return destination;
        }
    }
}

