/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.ComplexNumber;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.DoubleRect;
import com.mapinfo.midev.util.MathUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class NewZealandMapGridFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE, ProjectionParamType.ORIGIN_LATITUDE, ProjectionParamType.FALSE_EASTING, ProjectionParamType.FALSE_NORTHING};
    private static final Set<Code> CODE_SET;

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return new NewZealandMapGrid(new CodeSet(this.getSupportedCodes()), projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("epsg", "9811"));
        result.add(new Code("mapinfo", "projection18"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class NewZealandMapGrid
    extends Projection
    implements Serializable {
        private double m_phi0;
        private double m_lambda0;
        private DoubleRect m_LLClipRect;
        private DoubleRect m_ProjClipRect;
        private static final double[] m_ForwardConstants = new double[]{0.0, 0.6399175073, -0.1358797613, 0.063294409, -0.02526853, 0.0117879, -0.0055161, 0.0026906, -0.001333, 6.7E-4, -3.4E-4};
        private static final double[] m_InverseConstants = new double[]{0.0, 1.5627014243, 0.5185406398, -0.03333098, -0.1052906, -0.0368594, 0.007317, 0.0122, 0.00394, -0.0013};
        private static final double[] m_ScaleConstants = new double[]{1.3230946238, -0.8680281742, 0.6629999306, -0.14371346, 0.05551665, -0.00729966, 0.001708, -2.1E-4};
        private static final double[][] m_B = new double[][]{{0.0, 0.0}, {0.7557853228, 0.0}, {0.249204646, 0.003371507}, {-0.001541739, 0.04105856}, {-0.10162907, 0.01727609}, {-0.26623489, -0.36249218}, {-0.6870983, -1.1651967}};
        private static final double[][] m_b = new double[][]{{0.0, 0.0}, {1.3231270439, 0.0}, {-0.577245789, -0.007809598}, {0.508307513, -0.112208952}, {-0.15094762, 0.18200602}, {1.01418179, 1.64497696}, {1.9660549, 2.5127645}};

        public NewZealandMapGrid(CodeSet codeSet, ProjectionParams projectionParams) {
            super("New Zealand Map Grid", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            double centerY;
            ProjectionParams projectionParams = this.getProjectionParams();
            double centerX = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.DEGREE, -360.0, 360.0);
            this.m_phi0 = centerY = CoordSysUtilities.convertClip(projectionParams.getOriginLatitude(), AngularUnit.DEGREE, -90.0, 90.0);
            this.m_lambda0 = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
            this.m_LLClipRect = new DoubleRect(centerX - 15.0, centerY - 15.0, centerX + 15.0, centerY + 15.0);
            this.m_ProjClipRect = new DoubleRect(0.0, 0.0, 0.0, 0.0);
            this.LLToProjRect(this.m_LLClipRect, this.m_ProjClipRect, this.m_lambda0);
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            double y;
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = MathUtil.clip((double)source.getX(), (double)this.m_LLClipRect.getMinX(), (double)this.m_LLClipRect.getMaxX());
            double phi = y = MathUtil.clip((double)source.getY(), (double)this.m_LLClipRect.getMinY(), (double)this.m_LLClipRect.getMaxY());
            double deltaphi = (phi - this.m_phi0) * 0.036;
            double lambda = Math.toRadians(x);
            double deltalambda = lambda - this.m_lambda0;
            double deltaphipow = 1.0;
            double deltapsi = m_ForwardConstants[0];
            for (int i = 1; i < m_ForwardConstants.length; ++i) {
                deltapsi += m_ForwardConstants[i] * (deltaphipow *= deltaphi);
            }
            ComplexNumber c_zeta = new ComplexNumber(deltapsi, deltalambda);
            ComplexNumber c_zetapow = new ComplexNumber(1.0, 0.0);
            ComplexNumber c_z = new ComplexNumber(m_B[0][0], m_B[0][1]);
            ComplexNumber c_temp = new ComplexNumber();
            for (int i = 1; i < m_B.length; ++i) {
                c_zetapow.mult(c_zeta);
                c_temp.set(m_B[i][0], m_B[i][1]);
                c_temp.mult(c_zetapow);
                c_z.add(c_temp);
            }
            c_z.mult(projectionParams.getEllipsoid().getSemiMajorAxis());
            y = c_z.getReal();
            x = c_z.getImaginary();
            destination.setXY(LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()) + projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit()), LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()) + projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            int i;
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = MathUtil.clip((double)source.getX(), (double)this.m_ProjClipRect.getMinX(), (double)this.m_ProjClipRect.getMaxX());
            double y = MathUtil.clip((double)source.getY(), (double)this.m_ProjClipRect.getMinY(), (double)this.m_ProjClipRect.getMaxY());
            x = LinearUnit.convert((double)(x - projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit())), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            y = LinearUnit.convert((double)(y - projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit())), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            ComplexNumber c_z = new ComplexNumber(y / projectionParams.getEllipsoid().getSemiMajorAxis(), x / projectionParams.getEllipsoid().getSemiMajorAxis());
            ComplexNumber c_zpow = new ComplexNumber(1.0, 0.0);
            ComplexNumber c_zeta = new ComplexNumber(m_b[0][0], m_b[0][1]);
            ComplexNumber c_temp = new ComplexNumber();
            for (int i2 = 1; i2 < m_b.length; ++i2) {
                c_zpow.mult(c_z);
                c_temp.set(m_b[i2][0], m_b[i2][1]);
                c_temp.mult(c_zpow);
                c_zeta.add(c_temp);
            }
            ComplexNumber c_zetapow = new ComplexNumber(1.0, 0.0);
            ComplexNumber c_denom = new ComplexNumber(m_B[1][0], m_B[1][1]);
            for (i = 1; i < m_B.length; ++i) {
                c_zetapow.mult(c_zeta);
                if (i > 1) {
                    c_temp.set(m_B[i][0], m_B[i][1]);
                    c_temp.mult(c_zetapow);
                    c_temp.mult(i - 1);
                    c_z.add(c_temp);
                }
                if (i + 1 >= m_B.length) continue;
                c_temp.set(m_B[i + 1][0], m_B[i + 1][1]);
                c_temp.mult(c_zetapow);
                c_temp.mult(i + 1);
                c_denom.add(c_temp);
            }
            c_z.div(c_denom);
            double deltapsi = c_z.getReal();
            double deltalambda = c_z.getImaginary();
            double deltapsipow = 1.0;
            double deltaphi = m_InverseConstants[0];
            for (i = 1; i < m_InverseConstants.length; ++i) {
                deltaphi += m_InverseConstants[i] * (deltapsipow *= deltapsi);
            }
            x = Math.toDegrees(this.m_lambda0 + deltalambda);
            y = this.m_phi0 + deltaphi / 0.036;
            destination.setXY(x, y);
            return destination;
        }

        private DoubleRect LLToProjRect(DoubleRect source, DoubleRect destination, double originLongitude) {
            DirectPosition[] Pnts = new DirectPosition[6];
            int numpoints = 4;
            Pnts[0] = new DirectPosition(source.getMinX(), source.getMinY());
            Pnts[1] = new DirectPosition(source.getMinX(), source.getMaxY());
            Pnts[2] = new DirectPosition(source.getMaxX(), source.getMaxY());
            Pnts[3] = new DirectPosition(source.getMaxX(), source.getMinY());
            Pnts[4] = new DirectPosition();
            Pnts[5] = new DirectPosition();
            if (source.getMinX() < originLongitude && source.getMaxX() > originLongitude) {
                Pnts[numpoints].setXY(originLongitude, source.getMinY());
                Pnts[numpoints + 1].setXY(originLongitude, source.getMaxY());
                numpoints += 2;
            }
            for (int n = 0; n < Pnts.length; ++n) {
                Pnts[n] = this.fromLongLat(Pnts[n], Pnts[n]);
            }
            destination.initBounds();
            for (int i = 0; i < numpoints; ++i) {
                destination.merge(Pnts[i].getX(), Pnts[i].getY());
            }
            return destination;
        }
    }
}

