/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PolyconicFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE, ProjectionParamType.ORIGIN_LATITUDE, ProjectionParamType.FALSE_EASTING, ProjectionParamType.FALSE_NORTHING};
    private static final Set<Code> CODE_SET;

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return new Polyconic(new CodeSet(this.getSupportedCodes()), projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("mapinfo", "projection27"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class Polyconic
    extends Projection
    implements Serializable {
        private double m_lambda0;
        private double m_MultY;
        private double m_Aprime;
        private double m_Bprime;
        private double m_Cprime;
        private double m_Aprime2;
        private double m_Bprime2;
        private double m_Cprime2;
        private double m_Dprime2;
        private double m_M0;

        public Polyconic(CodeSet codeSet, ProjectionParams projectionParams) {
            super("Polyconic", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            ProjectionParams projectionParams = this.getProjectionParams();
            this.m_lambda0 = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
            double phi0 = CoordSysUtilities.convertClip(projectionParams.getOriginLatitude(), AngularUnit.RADIAN, -90.0, 90.0);
            double e4 = projectionParams.getEllipsoid().getEccentricitySquared() * projectionParams.getEllipsoid().getEccentricitySquared();
            double e6 = projectionParams.getEllipsoid().getEccentricitySquared() * e4;
            double A = projectionParams.getEllipsoid().getSemiMajorAxis() * -(3.0 * projectionParams.getEllipsoid().getEccentricitySquared() / 8.0 + 3.0 * e4 / 32.0 + 45.0 * e6 / 1024.0);
            double B = projectionParams.getEllipsoid().getSemiMajorAxis() * (15.0 * e4 / 256.0 + 45.0 * e6 / 1024.0);
            double C = projectionParams.getEllipsoid().getSemiMajorAxis() * -35.0 * e6 / 3072.0;
            this.m_MultY = projectionParams.getEllipsoid().getSemiMajorAxis() * (1.0 - projectionParams.getEllipsoid().getEccentricitySquared() / 4.0 - 3.0 * e4 / 64.0 - 5.0 * e6 / 256.0);
            this.m_Aprime = A - C;
            this.m_Bprime = 2.0 * B;
            this.m_Cprime = 4.0 * C;
            A = 1.0 - projectionParams.getEllipsoid().getEccentricitySquared() / 4.0 - 3.0 * e4 / 64.0 - 5.0 * e6 / 256.0;
            B = -2.0 * (3.0 * projectionParams.getEllipsoid().getEccentricitySquared() / 8.0 + 3.0 * e4 / 32.0 + 45.0 * e6 / 1024.0);
            C = 4.0 * (15.0 * e4 / 256.0 + 45.0 * e6 / 1024.0);
            double D = -6.0 * (35.0 * e6 / 3072.0);
            this.m_Aprime2 = A - C;
            this.m_Bprime2 = B - 3.0 * D;
            this.m_Cprime2 = 2.0 * C;
            this.m_Dprime2 = 4.0 * D;
            double phi2 = phi0 * 2.0;
            double cosphi2 = Math.cos(phi2);
            this.m_M0 = this.m_MultY * phi0 + Math.sin(phi2) * (this.m_Aprime + cosphi2 * (this.m_Bprime + cosphi2 * this.m_Cprime));
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = source.getX() - projectionParams.getOriginLongitude().getValue(AngularUnit.DEGREE);
            double y = source.getY();
            x = CoordSysUtilities.convertClip(x, AngularUnit.DEGREE, AngularUnit.RADIAN, -180.0, 180.0);
            y = CoordSysUtilities.convertClip(y, AngularUnit.DEGREE, AngularUnit.RADIAN, -90.0, 90.0);
            double lambdadiff = x;
            double phi = y;
            if (0.0 == phi) {
                x = projectionParams.getEllipsoid().getSemiMajorAxis() * lambdadiff;
                y = -this.m_M0;
            } else {
                double E = lambdadiff * Math.sin(phi);
                double phi2 = phi * 2.0;
                double cosphi2 = Math.cos(phi2);
                double M = this.m_MultY * phi + Math.sin(phi2) * (this.m_Aprime + cosphi2 * (this.m_Bprime + cosphi2 * this.m_Cprime));
                double sinphi = Math.sin(phi);
                double N = projectionParams.getEllipsoid().getSemiMajorAxis() / Math.sqrt(1.0 - projectionParams.getEllipsoid().getEccentricitySquared() * sinphi * sinphi);
                x = N * Polyconic.cot(phi) * Math.sin(E);
                y = M - this.m_M0 + N * Polyconic.cot(phi) * (1.0 - Math.cos(E));
            }
            x = LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit());
            y = LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit());
            destination.setXY(x += projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit()), y += projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double C = 0.0;
            double phinplus1 = 0.0;
            double x = source.getX() - projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit());
            double y = source.getY() - projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit());
            x = LinearUnit.convert((double)x, (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            if ((y = LinearUnit.convert((double)y, (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit())) == -this.m_M0) {
                x = x / projectionParams.getEllipsoid().getSemiMajorAxis() + this.m_lambda0;
                y = 0.0;
            } else {
                boolean bConverged = false;
                double A = (this.m_M0 + y) / projectionParams.getEllipsoid().getSemiMajorAxis();
                while (!bConverged) {
                    double B = x * x / (projectionParams.getEllipsoid().getSemiMajorAxis() * projectionParams.getEllipsoid().getSemiMajorAxis()) + A * A;
                    double phin = A;
                    for (int loopcount = 0; !bConverged && loopcount < 100; ++loopcount) {
                        double sinphin = Math.sin(phin);
                        C = Math.sqrt(1.0 - projectionParams.getEllipsoid().getEccentricitySquared() * sinphin * sinphin) * Math.tan(phin);
                        double phin2 = phin * 2.0;
                        double cosphin2 = Math.cos(phin2);
                        double M = this.m_MultY * phin + Math.sin(phin2) * (this.m_Aprime + cosphin2 * (this.m_Bprime + cosphin2 * this.m_Cprime));
                        double Ma = M / projectionParams.getEllipsoid().getSemiMajorAxis();
                        double Ma2 = Ma * Ma;
                        double Mprime = this.m_Aprime2 + cosphin2 * (this.m_Bprime2 + cosphin2 * (this.m_Cprime2 + cosphin2 * this.m_Dprime2));
                        double sinphin2 = Math.sin(phin2);
                        phinplus1 = phin - (A * (C * Ma + 1.0) - Ma - 0.5 * (Ma2 + B) * C) / (projectionParams.getEllipsoid().getEccentricitySquared() * sinphin2 * (Ma2 + B - 2.0 * A * Ma) / 4.0 * C + (A - Ma) * (C * Mprime - 2.0 / sinphin2) - Mprime);
                        double delta = phinplus1 - phin;
                        if (delta > -1.0E-7 && delta < 1.0E-7) {
                            bConverged = true;
                        }
                        phin = phinplus1;
                    }
                    if (bConverged) continue;
                    x = x < 0.0 ? x + 100.0 : x - 100.0;
                }
                y = phinplus1;
                x = Math.asin(x * C / projectionParams.getEllipsoid().getSemiMajorAxis()) / Math.sin(phinplus1) + this.m_lambda0;
            }
            destination.setXY(CoordSysUtilities.convertClip(x, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0), CoordSysUtilities.convertClip(y, AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0));
            return destination;
        }

        private static double cot(double a) {
            return 1.0 / Math.tan(a);
        }
    }
}

