/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.util.ArgumentValidator;
import java.io.Serializable;

public abstract class Projection
implements Serializable {
    protected static final double COORD_MIN = -1.0E9;
    protected static final double COORD_MAX = 1.0E9;
    private final String m_displayName;
    private final CodeSet m_codeSet;
    private final ProjectionParams m_projectionParams;

    public Projection(String displayName, CodeSet codeSet, ProjectionParams projectionParams) {
        ArgumentValidator.assertNotNullReference((String)"projectionParams", (Object)projectionParams);
        this.m_displayName = displayName;
        this.m_codeSet = codeSet == null ? new CodeSet() : codeSet;
        this.m_projectionParams = projectionParams;
    }

    public ProjectionParams getProjectionParams() {
        return this.m_projectionParams;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public CodeSet getCodes() {
        return this.m_codeSet;
    }

    public abstract DirectPosition fromLongLat(DirectPosition var1, DirectPosition var2);

    public abstract DirectPosition toLongLat(DirectPosition var1, DirectPosition var2);

    public boolean equivalent(Projection projection) {
        if (projection == null) {
            return false;
        }
        return this.m_projectionParams.equivalent(projection.getProjectionParams()) && this.getClass().equals(projection.getClass());
    }
}

