/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.Ellipsoid;
import com.mapinfo.midev.coordsys.PrimeMeridian;
import com.mapinfo.midev.unit.Angle;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.unit.Offset;
import com.mapinfo.midev.util.ArgumentValidator;
import java.io.Serializable;

public class ProjectionParams
implements Serializable {
    public static final Angle DEFAULT_ORIGIN_LONGITUDE = new Angle(0.0, AngularUnit.DEGREE);
    public static final Angle DEFAULT_ORIGIN_LATITUDE = new Angle(0.0, AngularUnit.DEGREE);
    public static final Angle DEFAULT_STANDARD_PARALLEL_1 = new Angle(0.0, AngularUnit.DEGREE);
    public static final Angle DEFAULT_STANDARD_PARALLEL_2 = new Angle(0.0, AngularUnit.DEGREE);
    public static final Offset DEFAULT_FALSE_EASTING = new Offset(0.0, LinearUnit.METER);
    public static final Offset DEFAULT_FALSE_NORTHING = new Offset(0.0, LinearUnit.METER);
    public static final double DEFAULT_SCALE_FACTOR = 1.0;
    public static final Angle DEFAULT_RANGE = new Angle(0.0, AngularUnit.DEGREE);
    public static final Angle DEFAULT_AZIMUTH = new Angle(0.0, AngularUnit.DEGREE);
    public static final Angle DEFAULT_BEARING = new Angle(0.0, AngularUnit.DEGREE);
    private final LinearUnit m_linearUnit;
    private final Ellipsoid m_ellipsoid;
    private final PrimeMeridian m_primeMeridian;
    private final Angle m_originLongitude;
    private final Angle m_originLatitude;
    private final Angle m_standardParallel1;
    private final Angle m_standardParallel2;
    private final Offset m_falseEasting;
    private final Offset m_falseNorthing;
    private final double m_scaleFactor;
    private final Angle m_range;
    private final Angle m_azimuth;
    private final Angle m_bearing;

    public ProjectionParams(LinearUnit linearUnit, Ellipsoid ellipsoid, PrimeMeridian primeMeridian, Angle originLongitude, Angle originLatitude, Angle standardParallel1, Angle standardParallel2, Angle azimuth, Angle bearing, double scaleFactor, Offset falseEasting, Offset falseNorthing, Angle range) {
        ArgumentValidator.assertNotNullReference((String)"linearUnit", (Object)linearUnit);
        ArgumentValidator.assertNotNullReference((String)"ellipsoid", (Object)ellipsoid);
        ArgumentValidator.assertNotNullReference((String)"primeMeridian", (Object)primeMeridian);
        this.m_linearUnit = linearUnit;
        this.m_ellipsoid = ellipsoid;
        this.m_primeMeridian = primeMeridian;
        this.m_originLongitude = originLongitude;
        this.m_originLatitude = originLatitude;
        this.m_standardParallel1 = standardParallel1;
        this.m_standardParallel2 = standardParallel2;
        this.m_falseEasting = falseEasting;
        this.m_falseNorthing = falseNorthing;
        this.m_scaleFactor = scaleFactor;
        this.m_range = range;
        this.m_azimuth = azimuth;
        this.m_bearing = bearing;
    }

    public LinearUnit getLinearUnit() {
        return this.m_linearUnit;
    }

    public Ellipsoid getEllipsoid() {
        return this.m_ellipsoid;
    }

    public PrimeMeridian getPrimeMeridian() {
        return this.m_primeMeridian;
    }

    public Angle getOriginLongitude() {
        return this.m_originLongitude;
    }

    public Angle getOriginLatitude() {
        return this.m_originLatitude;
    }

    public Angle getStandardParallel1() {
        return this.m_standardParallel1;
    }

    public Angle getStandardParallel2() {
        return this.m_standardParallel2;
    }

    public Offset getFalseEasting() {
        return this.m_falseEasting;
    }

    public Offset getFalseNorthing() {
        return this.m_falseNorthing;
    }

    public double getScaleFactor() {
        return this.m_scaleFactor;
    }

    public Angle getRange() {
        return this.m_range;
    }

    public Angle getAzimuth() {
        return this.m_azimuth;
    }

    public Angle getBearing() {
        return this.m_bearing;
    }

    public boolean equivalent(ProjectionParams projectionParams) {
        if (projectionParams == null) {
            return false;
        }
        return this.m_linearUnit.equals((Object)projectionParams.m_linearUnit) && this.m_ellipsoid.equivalent(projectionParams.m_ellipsoid) && this.m_originLongitude.equivalent(projectionParams.m_originLongitude) && this.m_originLatitude.equivalent(projectionParams.m_originLatitude) && this.m_standardParallel1.equivalent(projectionParams.m_standardParallel1) && this.m_standardParallel2.equivalent(projectionParams.m_standardParallel2) && this.m_falseEasting.equivalent(projectionParams.m_falseEasting) && this.m_falseNorthing.equivalent(projectionParams.m_falseNorthing) && Double.compare(this.m_scaleFactor, projectionParams.m_scaleFactor) == 0 && this.m_range.equivalent(projectionParams.m_range) && this.m_azimuth.equivalent(projectionParams.m_azimuth) && this.m_bearing.equivalent(projectionParams.m_bearing);
    }
}

