/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.MathUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SwissObliqueMercatorFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE, ProjectionParamType.ORIGIN_LATITUDE, ProjectionParamType.FALSE_EASTING, ProjectionParamType.FALSE_NORTHING};
    private static final Set<Code> CODE_SET;

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return new SwissObliqueMercator(new CodeSet(this.getSupportedCodes()), projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("epsg", "9814"));
        result.add(new Code("mapinfo", "projection25"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class SwissObliqueMercator
    extends Projection
    implements Serializable {
        private double m_e;
        private double m_e_over_2;
        private double m_L0;
        private double m_B0;
        private double m_alpha;
        private double m_alpha_over_2;
        private double m_one_over_alpha;
        private double m_sinb0;
        private double m_cosb0;
        private double m_R;
        private double m_R_over_2;
        private double m_one_over_R;
        private double m_K;

        public SwissObliqueMercator(CodeSet codeSet, ProjectionParams projectionParams) {
            super("Swiss Oblique Mercator", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            ProjectionParams projectionParams = this.getProjectionParams();
            this.m_L0 = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
            this.m_B0 = CoordSysUtilities.convertClip(projectionParams.getOriginLatitude(), AngularUnit.RADIAN, -90.0, 90.0);
            this.m_e = projectionParams.getEllipsoid().getEccentricity();
            this.m_e_over_2 = this.m_e / 2.0;
            double cosB0 = Math.cos(this.m_B0);
            double sinB0 = Math.sin(this.m_B0);
            double esinB0 = this.m_e * sinB0;
            this.m_R = projectionParams.getEllipsoid().getSemiMajorAxis() * Math.sqrt(1.0 - projectionParams.getEllipsoid().getEccentricitySquared()) / (1.0 - esinB0 * esinB0);
            this.m_R_over_2 = this.m_R / 2.0;
            this.m_one_over_R = 1.0 / this.m_R;
            this.m_alpha = Math.sqrt(1.0 + projectionParams.getEllipsoid().getEccentricitySquared() / (1.0 - projectionParams.getEllipsoid().getEccentricitySquared()) * Math.pow(cosB0, 4.0));
            this.m_alpha_over_2 = this.m_alpha / 2.0;
            this.m_one_over_alpha = 1.0 / this.m_alpha;
            this.m_sinb0 = sinB0 / this.m_alpha;
            this.m_sinb0 = MathUtil.clip((double)this.m_sinb0, (double)-1.0, (double)1.0);
            this.m_cosb0 = Math.cos(Math.asin(this.m_sinb0));
            this.m_K = sinB0 == 1.0 || sinB0 == -1.0 || this.m_sinb0 == 1.0 || this.m_sinb0 == -1.0 ? 0.0 : (Math.log((1.0 + this.m_sinb0) / (1.0 - this.m_sinb0)) - this.m_alpha * Math.log((1.0 + sinB0) / (1.0 - sinB0)) + this.m_alpha * this.m_e * Math.log((1.0 + esinB0) / (1.0 - esinB0))) / 2.0;
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            double temp1;
            double b;
            ProjectionParams projectionParams = this.getProjectionParams();
            double L = CoordSysUtilities.convertClip(source.getX(), AngularUnit.DEGREE, AngularUnit.RADIAN, -360.0, 360.0);
            double B = CoordSysUtilities.convertClip(source.getY(), AngularUnit.DEGREE, AngularUnit.RADIAN, -90.0, 90.0);
            double sinB = Math.sin(B);
            double esinB = this.m_e * sinB;
            if (sinB == 1.0 || sinB == -1.0) {
                b = B;
            } else {
                temp1 = this.m_alpha_over_2 * (Math.log((1.0 + sinB) / (1.0 - sinB)) - this.m_e * Math.log((1.0 + esinB) / (1.0 - esinB))) + this.m_K;
                b = 2.0 * (Math.atan(Math.exp(temp1)) - 0.7853981633974483);
            }
            double l = this.m_alpha * (L - this.m_L0);
            double sinb = Math.sin(b);
            double cosb = Math.cos(b);
            double sinl = Math.sin(l);
            double cosl = Math.cos(l);
            double sinbbar = this.m_cosb0 * sinb - this.m_sinb0 * cosb * cosl;
            sinbbar = MathUtil.clip((double)sinbbar, (double)-1.0, (double)1.0);
            temp1 = cosb * sinl;
            double temp2 = this.m_sinb0 * sinb + this.m_cosb0 * cosb * cosl;
            double lbar = temp1 == 0.0 && temp2 == 0.0 ? 0.0 : Math.atan2(temp1, temp2);
            double y = sinbbar == 1.0 ? 1.0E9 : (sinbbar == -1.0 ? -1.0E9 : this.m_R_over_2 * Math.log((1.0 + sinbbar) / (1.0 - sinbbar)));
            double x = this.m_R * lbar;
            destination.setXY(LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()) + projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit()), LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()) + projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            double B;
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = LinearUnit.convert((double)(source.getX() - projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit())), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double y = LinearUnit.convert((double)(source.getY() - projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit())), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double lbar = x * this.m_one_over_R;
            double bbar = 2.0 * (Math.atan(Math.exp(y * this.m_one_over_R)) - 0.7853981633974483);
            double sinlbar = Math.sin(lbar);
            double coslbar = Math.cos(lbar);
            double sinbbar = Math.sin(bbar);
            double cosbbar = Math.cos(bbar);
            double sinb = this.m_cosb0 * sinbbar + this.m_sinb0 * cosbbar * coslbar;
            sinb = MathUtil.clip((double)sinb, (double)-1.0, (double)1.0);
            double b = Math.asin(sinb);
            double temp1 = cosbbar * sinlbar;
            double temp2 = -this.m_sinb0 * sinbbar + this.m_cosb0 * cosbbar * coslbar;
            double l = temp1 == 0.0 && temp2 == 0.0 ? 0.0 : Math.atan2(temp1, temp2);
            if (sinb == 1.0 || sinb == -1.0) {
                B = b;
            } else {
                temp1 = (0.5 * Math.log((1.0 + sinb) / (1.0 - sinb)) - this.m_K) * this.m_one_over_alpha;
                B = this.m_B0;
                boolean keepgoing = true;
                while (keepgoing) {
                    double Bprev = B;
                    double esinB = this.m_e * Math.sin(B);
                    temp2 = temp1 + this.m_e_over_2 * Math.log((1.0 + esinB) / (1.0 - esinB));
                    keepgoing = Math.abs((B = 2.0 * (Math.atan(Math.exp(temp2)) - 0.7853981633974483)) - Bprev) > 1.0E-9;
                }
            }
            double L = this.m_L0 + l * this.m_one_over_alpha;
            destination.setXY(CoordSysUtilities.convertClip(L, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0), CoordSysUtilities.convertClip(B, AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0));
            return destination;
        }
    }
}

