/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.transform.config;

import com.mapinfo.midev.coordsys.transform.IGeographicTransformFactory;
import com.mapinfo.midev.coordsys.transform.config.IDatumTransformConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDatumTransformConfiguration
implements IDatumTransformConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDatumTransformConfiguration.class);
    private final List<IGeographicTransformFactory> m_transformList = Collections.unmodifiableList(DefaultDatumTransformConfiguration.buildList());

    @Override
    public void dispose() {
        for (IGeographicTransformFactory t : this.m_transformList) {
            t.dispose();
        }
    }

    @Override
    public List<IGeographicTransformFactory> getTransforms() {
        return this.m_transformList;
    }

    private static List<IGeographicTransformFactory> buildList() {
        ArrayList<IGeographicTransformFactory> result = new ArrayList<IGeographicTransformFactory>();
        for (IGeographicTransformFactory factory : ServiceLoader.load(IGeographicTransformFactory.class)) {
            LOG.debug("Loaded geographic transform: " + factory.getClass().getName());
            result.add(factory);
        }
        return result;
    }
}

