/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.util;

import com.mapinfo.midev.util.Code;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CodeMap<T> {
    private final Map<Code, List<T>> m_codeToObjectMap = new LinkedHashMap<Code, List<T>>();
    private final Map<Integer, Set<T>> m_hashToObjectSetMap = new LinkedHashMap<Integer, Set<T>>();

    protected abstract Integer calculateHash(T var1);

    protected Set<T> getFromHash(Integer hash) {
        Set<T> result = this.m_hashToObjectSetMap.get(hash);
        if (result == null) {
            return new HashSet();
        }
        return new LinkedHashSet<T>(result);
    }

    public void put(String codeSpace, String code, T t) {
        Code absoluteCode = new Code(codeSpace, code);
        List<T> codeList = this.m_codeToObjectMap.get(absoluteCode);
        if (codeList == null) {
            codeList = new ArrayList<T>();
            codeList.add(t);
            this.m_codeToObjectMap.put(absoluteCode, codeList);
        } else {
            codeList.add(t);
        }
        Integer hash = this.calculateHash(t);
        Set<T> s = this.m_hashToObjectSetMap.get(hash);
        if (s == null) {
            s = new LinkedHashSet<T>();
            this.m_hashToObjectSetMap.put(hash, s);
        }
        s.add(t);
    }

    public T get(String codeSpace, String codeNumber) {
        Code code = new Code(codeSpace, codeNumber);
        return this.get(code);
    }

    public T get(Code code) {
        List<T> result = this.m_codeToObjectMap.get(code);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public List<T> getAll(Code code) {
        List<T> result = this.m_codeToObjectMap.get(code);
        if (result == null || result.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    public T get(String srsName) {
        Code code = Code.parse(srsName);
        return this.get(code);
    }

    public Set<Code> keySet() {
        return new HashSet<Code>(this.m_codeToObjectMap.keySet());
    }

    public Set<T> values() {
        HashSet<T> valuz = new HashSet<T>();
        for (List<T> codez : this.m_codeToObjectMap.values()) {
            valuz.addAll(codez);
        }
        return valuz;
    }
}

