/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.util;

import com.mapinfo.midev.xml.read.XmlReaderException;
import com.mapinfo.midev.xml.read.XmlReaderImpl;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public final class EpsgAxisOrderFileReader {
    private static final String EPSG_AXIS_ORDER_INFO_FILE = "/CSYSInfo.xml";
    private static final String EPSG_PREFIX = "EPSG-";
    private static final int EPSG_PREFIX_LENGTH = "EPSG-".length();

    private EpsgAxisOrderFileReader() {
    }

    public static List<String> getEpsgCodesWithLatLongAxisOrder() {
        ArrayList<String> codes = new ArrayList<String>();
        InputStream is = null;
        XmlReaderImpl reader = null;
        try {
            is = EpsgAxisOrderFileReader.class.getResourceAsStream(EPSG_AXIS_ORDER_INFO_FILE);
            if (is == null) {
                throw new RuntimeException("File not found: /CSYSInfo.xml");
            }
            reader = new XmlReaderImpl((InputStream)new BufferedInputStream(is), false);
            reader.readStartElement("CSYSInfo");
            while (reader.getLocalName().startsWith(EPSG_PREFIX)) {
                String axis1 = reader.getAttribute("axis1");
                if (axis1.equalsIgnoreCase("north") || axis1.equalsIgnoreCase("south")) {
                    String code = reader.getLocalName().substring(EPSG_PREFIX_LENGTH);
                    codes.add(code);
                }
                reader.skip();
            }
        }
        catch (XmlReaderException e) {
            try {
                throw new RuntimeException("Error reading: /CSYSInfo.xml", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Closeable)reader);
        return codes;
    }
}

