/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.xmlprot;

import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.xml.read.IXmlReader;
import com.mapinfo.midev.xml.read.XmlReaderException;
import org.slf4j.LoggerFactory;

public class ProjectionConfigReader {
    private ProjectionConfigReader() {
    }

    public static void read(IXmlReader r, CoordSysFactory factory) throws XmlReaderException {
        r.readStartElement("ProjectionConfig", "http://www.mapinfo.com/mxp/csys");
        r.readStartElement("ProjectionSet", "http://www.mapinfo.com/mxp/csys");
        while (r.isStartElement("Projection", "http://www.mapinfo.com/mxp/csys")) {
            factory.add(ProjectionConfigReader.readProjection(r));
        }
        r.readEndElement();
        r.readEndElement();
    }

    private static IProjectionFactory readProjection(IXmlReader r) throws XmlReaderException {
        IProjectionFactory result = null;
        r.readStartElement("Projection", "http://www.mapinfo.com/mxp/csys");
        String projectionFactoryString = r.readElementString("ProjectionFactoryString", "http://www.mapinfo.com/mxp/csys");
        try {
            result = (IProjectionFactory)Class.forName(projectionFactoryString).newInstance();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ProjectionConfigReader.class).error("Unable to load projection.", (Throwable)e);
        }
        r.readEndElement();
        return result;
    }
}

