/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.util;

import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;

@PublicAPI
public final class Code
implements Serializable {
    private final String m_codeSpace;
    private final String m_code;

    public Code(String codeSpace, String code) {
        ArgumentValidator.assertNotEmptyString((String)"codeSpace", (String)codeSpace);
        ArgumentValidator.assertNotEmptyString((String)"code", (String)code);
        this.m_codeSpace = codeSpace.toLowerCase();
        this.m_code = code.toLowerCase();
    }

    public String getCodeSpace() {
        return this.m_codeSpace;
    }

    public String getCode() {
        return this.m_code;
    }

    public static Code parse(String codeSpaceAndCode) {
        ArgumentValidator.assertNotNullReference((String)"codeSpaceAndCode", (Object)codeSpaceAndCode);
        int index = codeSpaceAndCode.indexOf(58);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid code: " + codeSpaceAndCode + ". Must be of the format \"codespace:code\".");
        }
        return new Code(codeSpaceAndCode.substring(0, index), codeSpaceAndCode.substring(index + 1));
    }

    public String toString() {
        return this.m_codeSpace + ":" + this.m_code;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Code code = (Code)o;
        if (!this.m_code.equals(code.m_code)) {
            return false;
        }
        return this.m_codeSpace.equals(code.m_codeSpace);
    }

    public int hashCode() {
        int result = this.m_codeSpace.hashCode();
        result = 29 * result + this.m_code.hashCode();
        return result;
    }
}

