/*
 * Decompiled with CFR 0.152.
 */
package com.pb.geocoding.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pb.geocoding.config.ConfigCountry;
import com.pb.geocoding.config.ConfigurationModel;
import com.pb.geocoding.config.DataSet;
import com.pb.geocoding.config.api.GeocodingConfiguration;
import com.pb.geocoding.config.util.FileListUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JsonConfigurationImpl
implements GeocodingConfiguration {
    private File jsonConfigFile;
    private final String JSON_DEFAULT_FILENAME = "JsonDataConfig.json";
    ConfigurationModel configurations;
    ObjectMapper mapper;

    public JsonConfigurationImpl() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.jsonConfigFile = new File(classLoader.getResource("JsonDataConfig.json").getFile());
        this.configurations = new ConfigurationModel();
        this.mapper = new ObjectMapper();
        this.parse();
    }

    public JsonConfigurationImpl(File jsonConfigFile) {
        this.jsonConfigFile = jsonConfigFile;
        this.configurations = new ConfigurationModel();
        this.mapper = new ObjectMapper();
        this.parse();
    }

    public JsonConfigurationImpl(String json) throws IOException {
        this.configurations = (ConfigurationModel)this.mapper.readValue(json, ConfigurationModel.class);
        this.mapper = new ObjectMapper();
    }

    public JsonConfigurationImpl(ConfigurationModel model) {
        this.configurations = model;
    }

    public void parse() {
        try {
            this.configurations = (ConfigurationModel)this.mapper.readValue(this.jsonConfigFile, ConfigurationModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File getJsonConfigFile() throws FileNotFoundException {
        if (this.jsonConfigFile == null) {
            throw new FileNotFoundException("File does not exist");
        }
        return this.jsonConfigFile;
    }

    public void setJsonConfigFile(File jsonConfigFile) {
        this.jsonConfigFile = jsonConfigFile;
    }

    @Override
    public ConfigCountry getConfigByCountry(String iso3) throws Exception {
        if (this.configurations != null && iso3 != null) {
            List<ConfigCountry> configCountries = this.configurations.getCountries();
            for (ConfigCountry country : configCountries) {
                if (!iso3.equalsIgnoreCase(country.getCountry())) continue;
                return country;
            }
        }
        return null;
    }

    private List<DataSet> fixDataSetPaths(ConfigCountry configCountry) {
        List<DataSet> dataSets = this.getClone(configCountry.getDataSets());
        for (DataSet dataSet : dataSets) {
            if (!dataSet.isUseRoot()) continue;
            dataSet.setPath(this.configurations.getRoots().get(dataSet.getRootId()) + dataSet.getPath());
        }
        return dataSets;
    }

    private List<DataSet> getClone(List<DataSet> dataSetList) {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>(dataSetList.size());
        for (DataSet dataSet : dataSetList) {
            DataSet dataSet1 = new DataSet();
            dataSet1.setUseRoot(dataSet.isUseRoot());
            dataSet1.setPath(dataSet.getPath());
            dataSet1.setName(dataSet.getName());
            dataSet1.setRootId(dataSet.getRootId());
            dataSet1.setInteractive(dataSet.isInteractive());
            dataSets.add(dataSet1);
        }
        return dataSets;
    }

    @Override
    public List<ConfigCountry> getConfigForAllCountries() throws Exception {
        if (this.configurations != null) {
            return this.configurations.getCountries();
        }
        return null;
    }

    @Override
    public Map<String, Properties> getCountryProperties() throws Exception {
        List<ConfigCountry> configCountries;
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        if (this.configurations != null && (configCountries = this.configurations.getCountries()) != null) {
            for (ConfigCountry country : configCountries) {
                ConfigCountry configCountry = new ConfigCountry();
                configCountry.setDataSets(country.getDataSets());
                configCountry.setCountry(country.getCountry());
                configCountry.setProperties(country.getProperties());
                configCountry.setDataSets(this.fixDataSetPaths(configCountry));
                Properties properties = new Properties();
                int count = 1;
                boolean hasData = false;
                if (configCountry.getDataSets() != null) {
                    for (DataSet dataSet : configCountry.getDataSets()) {
                        if (dataSet.isInteractive()) continue;
                        hasData = true;
                        properties.setProperty("DICTIONARY_PATH" + count, dataSet.getPath());
                        ++count;
                    }
                }
                properties.setProperty("DICTIONARY_COUNT", String.valueOf(count - 1));
                Map<String, String> internal = configCountry.getProperties();
                if (internal != null) {
                    for (String key : internal.keySet()) {
                        if (internal.get(key) == null) continue;
                        properties.setProperty(key, internal.get(key));
                    }
                }
                if (!hasData && !"CORE_SETTINGS".equals(configCountry.getCountry())) continue;
                map.put(configCountry.getCountry(), properties);
            }
        }
        return map;
    }

    @Override
    public Map<String, Properties> getCountryPropertiesInteractive() throws Exception {
        List<ConfigCountry> configCountries;
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        if (this.configurations != null && (configCountries = this.configurations.getCountries()) != null) {
            for (ConfigCountry country : configCountries) {
                Map<String, String> internal;
                ConfigCountry configCountry = new ConfigCountry();
                configCountry.setDataSets(country.getDataSets());
                configCountry.setCountry(country.getCountry());
                configCountry.setProperties(country.getProperties());
                configCountry.setDataSets(this.fixDataSetPaths(configCountry));
                Properties properties = new Properties();
                int count = 1;
                boolean hasData = false;
                if (configCountry.getDataSets() != null) {
                    for (DataSet dataSet : configCountry.getDataSets()) {
                        if (!dataSet.isInteractive()) continue;
                        hasData = true;
                        properties.setProperty("dictionary_index_file_" + count, dataSet.getPath());
                        ++count;
                    }
                }
                if ((internal = configCountry.getProperties()) != null) {
                    for (String key : internal.keySet()) {
                        if (internal.get(key) == null) continue;
                        properties.setProperty(key, internal.get(key));
                    }
                }
                if (!hasData) continue;
                map.put(configCountry.getCountry(), properties);
            }
        }
        return map;
    }

    @Override
    public Map<String, Object> getConfigurations() throws Exception {
        return this.configurations.getConfig();
    }

    @Override
    public Object getConfig(String key) throws Exception {
        if (this.configurations != null && this.configurations.getConfig() != null) {
            return this.configurations.getConfig().get(key);
        }
        return null;
    }

    @Override
    public void addConfig(String key, Object value) {
        if (this.configurations != null && this.configurations.getConfig() != null) {
            this.configurations.getConfig().put(key, value);
        }
    }

    @Override
    public void createConfigurationFile(File file) throws IOException {
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)this.configurations);
    }

    public void createConfigurationFile(File file, ConfigurationModel configurations) throws IOException {
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)configurations);
    }

    @Override
    public void createConfigurationFileMerge(File file) throws Exception {
        if (file.exists()) {
            JsonConfigurationImpl first_config = new JsonConfigurationImpl(file);
            if (!first_config.configurations.getRoots().equals(this.configurations.getRoots())) {
                FileListUtils.resolveRoot(this.configurations, first_config.configurations);
            } else {
                this.configurations.getRoots().putAll(first_config.configurations.getRoots());
            }
            for (ConfigCountry configCountry : first_config.configurations.countries) {
                boolean add = false;
                for (ConfigCountry configCountry1 : this.configurations.countries) {
                    if (!configCountry.getCountry().equalsIgnoreCase(configCountry1.getCountry())) continue;
                    add = true;
                    configCountry1.getDataSets().addAll(configCountry.getDataSets());
                }
                if (add) continue;
                this.configurations.countries.add(configCountry);
            }
            for (ConfigCountry country : this.configurations.getCountries()) {
                FileListUtils.removeDuplicate(country.getDataSets());
            }
        }
        this.createConfigurationFile(file);
    }

    @Override
    public void createConfigurationFileReplace(File to) throws Exception {
        if (to.exists()) {
            JsonConfigurationImpl to_config = new JsonConfigurationImpl(to);
            if (!to_config.configurations.getRoots().equals(this.configurations.getRoots())) {
                FileListUtils.resolveRoot(this.configurations, to_config.configurations);
            } else {
                to_config.configurations.getRoots().putAll(this.configurations.getRoots());
            }
            for (ConfigCountry from_configCountry : this.configurations.countries) {
                boolean add = false;
                for (ConfigCountry to_configCountry : to_config.configurations.countries) {
                    if (!to_configCountry.getCountry().equalsIgnoreCase(from_configCountry.getCountry())) continue;
                    add = true;
                    to_configCountry.setDataSets(from_configCountry.getDataSets());
                    to_configCountry.setProperties(from_configCountry.getProperties());
                }
                if (add) continue;
                to_config.configurations.countries.add(from_configCountry);
            }
            this.cleanUpRoots(to_config);
            this.createConfigurationFile(to, to_config.configurations);
        }
    }

    public void cleanUpRoots(JsonConfigurationImpl to_config) {
        HashSet<String> rootToPreserve = new HashSet<String>();
        for (ConfigCountry country : to_config.configurations.getCountries()) {
            for (DataSet dataSet : country.getDataSets()) {
                rootToPreserve.add(dataSet.getRootId());
            }
        }
        HashSet<String> rootToRemove = new HashSet<String>();
        for (String rootId : to_config.configurations.getRoots().keySet()) {
            if (rootToPreserve.contains(rootId)) continue;
            rootToRemove.add(rootId);
        }
        for (String key : rootToRemove) {
            to_config.configurations.getRoots().remove(key);
        }
    }

    @Override
    public boolean addDataSetByCountry(String country, DataSet dataSet) {
        boolean res = false;
        boolean countryExists = false;
        for (ConfigCountry country1 : this.configurations.countries) {
            if (!country1.getCountry().equals(country)) continue;
            countryExists = true;
            if (country1.getDataSets().contains(dataSet)) continue;
            country1.getDataSets().add(dataSet);
            res = true;
        }
        if (!countryExists) {
            ConfigCountry country1 = new ConfigCountry();
            country1.setCountry(country);
            ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
            dataSets.add(dataSet);
            country1.setDataSets(dataSets);
            this.configurations.countries.add(country1);
            res = true;
        }
        return res;
    }

    @Override
    public void removeAllOtherDataSetsByCountry(String country, List<String> datSetsToPreserve) throws Exception {
        ConfigCountry configCountry = this.getConfigByCountry(country);
        if (configCountry != null && datSetsToPreserve != null) {
            ArrayList<DataSet> dataSetsForRemoval = new ArrayList<DataSet>();
            for (DataSet dataSet : configCountry.getDataSets()) {
                if (datSetsToPreserve.contains(dataSet.getName())) continue;
                dataSetsForRemoval.add(dataSet);
            }
            configCountry.getDataSets().removeAll(dataSetsForRemoval);
        }
    }

    @Override
    public void preserverOnly(Map<String, List<String>> map) throws Exception {
        for (String country : map.keySet()) {
            this.removeAllOtherDataSetsByCountry(country, map.get(country));
        }
        ArrayList<ConfigCountry> configCountries = new ArrayList<ConfigCountry>();
        for (ConfigCountry country : this.getConfigForAllCountries()) {
            if (map.containsKey(country.getCountry())) continue;
            configCountries.add(country);
        }
        this.getConfigForAllCountries().removeAll(configCountries);
    }

    @Override
    public void setConfig(Map<String, Object> config) {
        this.configurations.setConfig(config);
    }

    @Override
    public Map<String, String> getRoots() {
        return this.configurations.getRoots();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonConfigurationImpl)) {
            return false;
        }
        JsonConfigurationImpl that = (JsonConfigurationImpl)o;
        if ("JsonDataConfig.json" != null ? !"JsonDataConfig.json".equals(that.JSON_DEFAULT_FILENAME) : that.JSON_DEFAULT_FILENAME != null) {
            return false;
        }
        return !(this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null);
    }

    public int hashCode() {
        int result = this.jsonConfigFile != null ? this.jsonConfigFile.hashCode() : 0;
        result = 31 * result + ("JsonDataConfig.json" != null ? "JsonDataConfig.json".hashCode() : 0);
        result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
        result = 31 * result + (this.mapper != null ? this.mapper.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JsonConfigurationImpl{");
        sb.append("jsonConfigFile=").append(this.jsonConfigFile);
        sb.append(", JSON_DEFAULT_FILENAME='").append("JsonDataConfig.json").append('\'');
        sb.append(", configurations=").append(this.configurations);
        sb.append(", mapper=").append(this.mapper);
        sb.append('}');
        return sb.toString();
    }
}

