/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys;

import com.mapinfo.util.DoubleRect;
import java.io.Serializable;

public final class AffineTransform
implements Serializable {
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;
    private double g;
    private double h;
    private double i;
    private double j;
    private double k;
    private double l;
    private boolean m;
    private boolean n;
    public static final AffineTransform identity = new AffineTransform();
    private static final String o = "Degenerate control points";
    private static final String p = "Noninvertible affine transform";
    private static final String q = "At least three control points required";
    private static final String r = "a";
    private static final String s = "b";
    private static final String t = "c";
    private static final String u = "d";
    private static final String v = "e";
    private static final String w = "f";

    public AffineTransform(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.a = d2;
        this.b = d3;
        this.c = d4;
        this.d = d5;
        this.e = d6;
        this.f = d7;
        this.n = this.equals(identity);
        this.a();
    }

    public AffineTransform(double d2, double d3, double d4, double d5) {
        this(d2, 0.0, d3, 0.0, d4, d5);
    }

    public AffineTransform() {
        this.a = 1.0;
        this.b = 0.0;
        this.c = 0.0;
        this.d = 0.0;
        this.e = 1.0;
        this.f = 0.0;
        this.n = true;
        this.a();
    }

    public AffineTransform(double[] dArray) {
        this(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
    }

    public AffineTransform(DoubleRect doubleRect, DoubleRect doubleRect2, boolean bl, boolean bl2) {
        this.a = doubleRect2.width() / (bl ? -doubleRect.width() : doubleRect.width());
        this.b = 0.0;
        this.c = doubleRect2.xmin - this.a * (bl ? doubleRect.xmax : doubleRect.xmin);
        this.d = 0.0;
        this.e = doubleRect2.height() / (bl2 ? -doubleRect.height() : doubleRect.height());
        this.f = doubleRect2.ymin - this.e * (bl2 ? doubleRect.ymax : doubleRect.ymin);
        this.n = this.equals(identity);
        this.a();
    }

    public AffineTransform(DoubleRect doubleRect, DoubleRect doubleRect2) {
        this(doubleRect, doubleRect2, false, false);
    }

    public AffineTransform(double[] dArray, double[] dArray2, int n) throws Exception {
        double d2;
        double d3;
        double d4;
        if (n < 3) {
            throw new Exception(q);
        }
        double d5 = 0.0;
        double d6 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d5 += dArray[n2 * 2];
            d6 += dArray[n2 * 2 + 1];
            ++n2;
        }
        d5 /= (double)n;
        d6 /= (double)n;
        double[] dArray3 = new double[10];
        int n3 = 0;
        while (n3 < n) {
            d4 = dArray[n3 * 2];
            d3 = dArray[n3 * 2 + 1];
            d2 = dArray2[n3 * 2];
            double d7 = dArray2[n3 * 2 + 1];
            dArray3[1] = dArray3[1] + (d4 - d5) * (d3 - d6);
            dArray3[2] = dArray3[2] + (d3 - d6) * (d3 - d6);
            dArray3[3] = dArray3[3] + (d4 - d5) * (d4 - d5);
            dArray3[4] = dArray3[4] + (d3 - d6) * (d7 - d3);
            dArray3[5] = dArray3[5] + (d4 - d5) * (d2 - d4);
            dArray3[6] = dArray3[6] + (d4 - d5) * (d7 - d3);
            dArray3[7] = dArray3[7] + (d3 - d6) * (d2 - d4);
            dArray3[8] = dArray3[8] + (d2 - d4);
            dArray3[9] = dArray3[9] + (d7 - d3);
            ++n3;
        }
        if (dArray3[2] == 0.0 || dArray3[3] == 0.0) {
            throw new Exception(o);
        }
        d4 = dArray3[1] / dArray3[2];
        d3 = dArray3[1] / dArray3[3];
        d2 = dArray3[3] - d4 * dArray3[1];
        if (d2 == 0.0) {
            throw new Exception(o);
        }
        this.d = (dArray3[6] - d4 * dArray3[4]) / d2;
        d2 = dArray3[2] - d3 * dArray3[1];
        if (d2 == 0.0) {
            throw new Exception(o);
        }
        this.b = (dArray3[7] - d3 * dArray3[5]) / d2;
        this.e = 1.0 - d4 * this.d + dArray3[4] / dArray3[2];
        this.a = 1.0 - d3 * this.b + dArray3[5] / dArray3[3];
        this.c = dArray3[8] / (double)n + d5 - this.a * d5 - this.b * d6;
        this.f = dArray3[9] / (double)n + d6 - this.e * d6 - this.d * d5;
        this.n = this.equals(identity);
        this.a();
    }

    public AffineTransform(AffineTransform affineTransform, AffineTransform affineTransform2) {
        this.a = affineTransform2.a * affineTransform.a + affineTransform2.b * affineTransform.d;
        this.b = affineTransform2.a * affineTransform.b + affineTransform2.b * affineTransform.e;
        this.c = affineTransform2.a * affineTransform.c + affineTransform2.b * affineTransform.f + affineTransform2.c;
        this.d = affineTransform2.d * affineTransform.a + affineTransform2.e * affineTransform.d;
        this.e = affineTransform2.d * affineTransform.b + affineTransform2.e * affineTransform.e;
        this.f = affineTransform2.d * affineTransform.c + affineTransform2.e * affineTransform.f + affineTransform2.f;
        this.n = this.equals(identity);
        this.a();
    }

    private void a() {
        if (this.n) {
            this.m = true;
            this.g = this.a;
            this.h = this.b;
            this.i = this.c;
            this.j = this.d;
            this.k = this.e;
            this.l = this.f;
        } else {
            double d2 = this.a * this.e - this.b * this.d;
            if (d2 == 0.0) {
                this.m = false;
            } else {
                this.m = true;
                this.g = this.e / d2;
                this.h = -this.b / d2;
                this.i = (this.b * this.f - this.c * this.e) / d2;
                this.j = -this.d / d2;
                this.k = this.a / d2;
                this.l = (this.c * this.d - this.a * this.f) / d2;
            }
        }
    }

    public boolean isInvertible() {
        return this.m;
    }

    public boolean isIdentity() {
        return this.n;
    }

    public boolean isLinear() {
        return this.b == 0.0 && this.d == 0.0;
    }

    public void getCoefficients(double[] dArray) {
        dArray[0] = this.a;
        dArray[1] = this.b;
        dArray[2] = this.c;
        dArray[3] = this.d;
        dArray[4] = this.e;
        dArray[5] = this.f;
    }

    public AffineTransform createInverse() throws Exception {
        if (!this.m) {
            throw new Exception(p);
        }
        return this.n ? identity : new AffineTransform(this.g, this.h, this.i, this.j, this.k, this.l);
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.safeTransform(dArray, n, dArray2, n2, n3, true);
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) throws Exception {
        this.transform(dArray, n, dArray2, n2, n3, false);
    }

    public void safeInverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.safeTransform(dArray, n, dArray2, n2, n3, false);
    }

    public void safeTransform(double[] dArray, int n, double[] dArray2, int n2, int n3, boolean bl) {
        try {
            this.transform(dArray, n, dArray2, n2, n3, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3, boolean bl) throws Exception {
        if (this.n) {
            System.arraycopy(dArray, n, dArray2, n2, 2 * n3);
        } else {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            if (bl) {
                d7 = this.a;
                d6 = this.b;
                d5 = this.c;
                d4 = this.d;
                d3 = this.e;
                d2 = this.f;
            } else {
                if (!this.m) {
                    throw new Exception(p);
                }
                d7 = this.g;
                d6 = this.h;
                d5 = this.i;
                d4 = this.j;
                d3 = this.k;
                d2 = this.l;
            }
            while (n3-- > 0) {
                double d8 = dArray[n++];
                double d9 = dArray[n++];
                dArray2[n2++] = d7 * d8 + d6 * d9 + d5;
                dArray2[n2++] = d4 * d8 + d3 * d9 + d2;
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof AffineTransform) {
            return this.equals((AffineTransform)object);
        }
        return false;
    }

    public boolean equals(AffineTransform affineTransform) {
        return this.equivalent(affineTransform);
    }

    public boolean equivalent(AffineTransform affineTransform) {
        return this == affineTransform || this.a == affineTransform.a && this.b == affineTransform.b && this.c == affineTransform.c && this.d == affineTransform.d && this.e == affineTransform.e && this.f == affineTransform.f;
    }

    static {
        o = o;
        p = p;
        q = q;
        r = r;
        s = s;
        t = t;
        u = u;
        v = v;
        w = w;
    }
}

