/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.GeographicCoordinateSystem;
import com.mapinfo.coordsys.GeographicTransform;
import com.mapinfo.coordsys.HorizontalDatum;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.util.MathUtil;

public class BursaWolfe
extends GeographicTransform {
    private Constants a;
    private Constants b;

    public BursaWolfe(GeographicCoordinateSystem geographicCoordinateSystem, GeographicCoordinateSystem geographicCoordinateSystem2) {
        super("Bursa-Wolfe", geographicCoordinateSystem, geographicCoordinateSystem2);
        this.a = new Constants(geographicCoordinateSystem, geographicCoordinateSystem2);
        this.b = new Constants(geographicCoordinateSystem2, geographicCoordinateSystem);
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.transform(dArray, n, dArray2, n2, n3, true);
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.transform(dArray, n, dArray2, n2, n3, false);
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3, boolean bl) {
        AngularUnit angularUnit = AngularUnit.radian;
        Constants constants = bl ? this.a : this.b;
        AngularUnit angularUnit2 = constants.a;
        AngularUnit angularUnit3 = constants.b;
        double d2 = constants.c;
        double d3 = constants.d;
        double d4 = constants.e;
        double d5 = constants.o * constants.f;
        double d6 = constants.i;
        double d7 = constants.j;
        double d8 = constants.k;
        double d9 = constants.m;
        double d10 = constants.l;
        double d11 = constants.n;
        double d12 = constants.p;
        boolean bl2 = constants.q;
        double d13 = constants.r;
        double d14 = constants.s;
        double d15 = constants.u;
        double d16 = constants.v;
        double d17 = constants.w;
        double d18 = constants.x;
        double d19 = constants.y;
        double d20 = constants.z;
        double d21 = constants.g;
        double d22 = constants.h;
        double d23 = d4 * (1.0 - constants.t);
        double d24 = constants.f;
        double d25 = constants.o;
        AngularUnit angularUnit4 = AngularUnit.degree;
        while (n3-- > 0) {
            boolean bl3 = false;
            boolean bl4 = false;
            if (angularUnit4.convert(dArray[n], angularUnit2) >= 179.0) {
                bl3 = true;
            } else if (angularUnit4.convert(dArray[n], angularUnit2) <= -179.0) {
                bl4 = true;
            }
            double d26 = angularUnit.convert(dArray[n++], angularUnit2) + d2;
            double d27 = angularUnit.convertClip(dArray[n++], angularUnit2, -89.9, 89.9);
            double d28 = Math.sin(d27);
            double d29 = Math.cos(d27);
            double d30 = Math.sin(d26);
            double d31 = Math.cos(d26);
            if (bl2) {
                double d32 = Math.sqrt(1.0 - d24 * d28 * d28);
                double d33 = d4 / d32;
                double d34 = d4 * (1.0 - d24) / (d32 * d32 * d32);
                double d35 = (-(d6 * d28 * d31) - d7 * d28 * d30 + d8 * d29 + d21 * (d33 * d24 * d28 * d29) / d4 + d22 * (d34 * d4 / d23 + d33 * d23 / d4) * d28 * d29) / d34;
                double d36 = (-d6 * d30 + d7 * d31) / (d33 * d29);
                dArray2[n2++] = angularUnit3.convertClipX(d26 + d36 - d3, angularUnit);
                dArray2[n2++] = angularUnit3.convertClipY(d27 + d35, angularUnit);
                continue;
            }
            double d37 = d4 / Math.sqrt(1.0 - d24 * d28 * d28);
            double d38 = 0.0;
            double d39 = (d37 + d38) * d29 * d31;
            double d40 = (d37 + d38) * d29 * d30;
            double d41 = ((1.0 - d24) * d37 + d38) * d28;
            double d42 = d39 + d15 + d25 * d39 + d20 * d40 - d19 * d41;
            double d43 = d40 + d16 + d25 * d40 - d20 * d39 + d18 * d41;
            double d44 = d41 + d17 + d25 * d41 + d19 * d39 - d18 * d40;
            double d45 = d27;
            int n4 = 0;
            while (n4 < 10) {
                double d46 = Math.sin(d45);
                double d47 = d13 / Math.sqrt(1.0 - d14 * d46 * d46);
                double d48 = Math.atan2(d44 + d14 * d47 * d46, Math.sqrt(d42 * d42 + d43 * d43));
                if (Math.abs(d45 - d48) < 1.0E-9) {
                    d45 = d48;
                    break;
                }
                d45 = d48;
                ++n4;
            }
            double d49 = Math.atan2(d43, d42);
            double d50 = angularUnit4.convert(d49 - d3, angularUnit);
            double d51 = angularUnit4.convert(d45, angularUnit);
            if (d50 < 0.0 && bl3) {
                d50 += 360.0;
            }
            if (d50 < 0.0 && bl4) {
                d50 -= 360.0;
            }
            dArray2[n2++] = angularUnit3.convertClipX(d50, angularUnit4);
            dArray2[n2++] = angularUnit3.convertClipY(d51, angularUnit4);
        }
    }

    private static class Constants {
        AngularUnit a;
        AngularUnit b;
        double c;
        double d;
        double e;
        double f;
        double g;
        double h;
        double i;
        double j;
        double k;
        double l;
        double m;
        double n;
        double o;
        double p;
        boolean q;
        double r;
        double s;
        double t;
        double u;
        double v;
        double w;
        double x;
        double y;
        double z;

        Constants(GeographicCoordinateSystem geographicCoordinateSystem, GeographicCoordinateSystem geographicCoordinateSystem2) {
            this.a = geographicCoordinateSystem.getAngularUnit();
            this.b = geographicCoordinateSystem2.getAngularUnit();
            this.c = AngularUnit.radian.convert(geographicCoordinateSystem.getPrimeMeridian().getLongitude(), geographicCoordinateSystem.getPrimeMeridian().getAngularUnit());
            this.d = AngularUnit.radian.convert(geographicCoordinateSystem2.getPrimeMeridian().getLongitude(), geographicCoordinateSystem2.getPrimeMeridian().getAngularUnit());
            HorizontalDatum horizontalDatum = geographicCoordinateSystem.getHorizontalDatum();
            HorizontalDatum horizontalDatum2 = geographicCoordinateSystem2.getHorizontalDatum();
            Ellipsoid ellipsoid = horizontalDatum.getEllipsoid();
            Ellipsoid ellipsoid2 = horizontalDatum2.getEllipsoid();
            this.e = LinearUnit.meter.convert(ellipsoid.a(), ellipsoid.getAxisUnit());
            this.f = ellipsoid.e2();
            this.g = LinearUnit.meter.convert(ellipsoid2.a(), ellipsoid2.getAxisUnit()) - this.e;
            this.h = ellipsoid2.f() - ellipsoid.f();
            this.i = horizontalDatum.getShiftX() - horizontalDatum2.getShiftX();
            this.j = horizontalDatum.getShiftY() - horizontalDatum2.getShiftY();
            this.k = horizontalDatum.getShiftZ() - horizontalDatum2.getShiftZ();
            this.l = MathUtil.degreesToRadians((double)((horizontalDatum.getRotateX() - horizontalDatum2.getRotateX()) / 3600.0));
            this.m = MathUtil.degreesToRadians((double)((horizontalDatum.getRotateY() - horizontalDatum2.getRotateY()) / 3600.0));
            this.n = MathUtil.degreesToRadians((double)((horizontalDatum.getRotateZ() - horizontalDatum2.getRotateZ()) / 3600.0));
            this.o = (horizontalDatum.getScaleAdjust() - horizontalDatum2.getScaleAdjust()) * 1.0E-6;
            this.q = this.l == 0.0 && this.m == 0.0 && this.n == 0.0 && this.o == 0.0;
            this.p = this.f * this.g / this.e + 2.0 * this.h;
            this.r = LinearUnit.meter.convert(ellipsoid2.a(), ellipsoid2.getAxisUnit());
            this.s = ellipsoid2.e2();
            this.t = ellipsoid.f();
            this.u = horizontalDatum.getShiftX() - horizontalDatum2.getShiftX();
            this.v = horizontalDatum.getShiftY() - horizontalDatum2.getShiftY();
            this.w = horizontalDatum.getShiftZ() - horizontalDatum2.getShiftZ();
            this.x = MathUtil.degreesToRadians((double)((horizontalDatum.getRotateX() - horizontalDatum2.getRotateX()) / 3600.0));
            this.y = MathUtil.degreesToRadians((double)((horizontalDatum.getRotateY() - horizontalDatum2.getRotateY()) / 3600.0));
            this.z = MathUtil.degreesToRadians((double)((horizontalDatum.getRotateZ() - horizontalDatum2.getRotateZ()) / 3600.0));
        }
    }
}

