/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys;

import com.mapinfo.coordsys.SpatialReferenceInfo;
import com.mapinfo.unit.LinearUnit;
import java.util.Hashtable;

public class Ellipsoid
extends SpatialReferenceInfo {
    private double m_SemiMajorAxis;
    private double m_SemiMinorAxis;
    private double m_Flattening;
    private double m_InverseFlattening;
    private double m_Eccentricity;
    private double m_EccentricitySquared;
    private LinearUnit m_AxisUnit;
    private boolean m_bIgnore;
    public static final short INDEX_GRS80 = 0;
    public static final short INDEX_WGS72 = 1;
    public static final short INDEX_AUSTRALIAN = 2;
    public static final short INDEX_KRASSOVSKY = 3;
    public static final short INDEX_INTERNATIONAL = 4;
    public static final short INDEX_HAYFORD = 5;
    public static final short INDEX_CLARKE80 = 6;
    public static final short INDEX_CLARKE66 = 7;
    public static final short INDEX_MOD_CLARKE66 = 8;
    public static final short INDEX_AIRY = 9;
    public static final short INDEX_BESSEL = 10;
    public static final short INDEX_EVEREST = 11;
    public static final short INDEX_SPHERE = 12;
    public static final short INDEX_MOD_AIRY = 13;
    public static final short INDEX_MOD1_BESSEL = 14;
    public static final short INDEX_MOD1_CLARKE80 = 15;
    public static final short INDEX_MOD2_CLARKE80 = 16;
    public static final short INDEX_MOD1_EVEREST = 17;
    public static final short INDEX_FISCHER60 = 18;
    public static final short INDEX_MOD_FISCHER60 = 19;
    public static final short INDEX_FISCHER68 = 20;
    public static final short INDEX_GRS67 = 21;
    public static final short INDEX_HELMERT = 22;
    public static final short INDEX_HOUGH = 23;
    public static final short INDEX_SOUTH_AMERICAN = 24;
    public static final short INDEX_WAR_OFFICE = 25;
    public static final short INDEX_WGS60 = 26;
    public static final short INDEX_WGS66 = 27;
    public static final short INDEX_WGS84 = 28;
    public static final short INDEX_IGNORE = 29;
    public static final short INDEX_CLARKE80_IGN = 30;
    public static final short INDEX_IAG75 = 31;
    public static final short INDEX_MERIT83 = 32;
    public static final short INDEX_NEW_INTL67 = 33;
    public static final short INDEX_WALBECK = 34;
    public static final short INDEX_MOD2_BESSEL = 35;
    public static final short INDEX_CLARKE58 = 36;
    public static final short INDEX_MOD3_CLARKE80 = 37;
    public static final short INDEX_MOD4_CLARKE80 = 38;
    public static final short INDEX_MOD2_EVEREST = 39;
    public static final short INDEX_MOD3_EVEREST = 40;
    public static final short INDEX_INDONESIAN = 41;
    public static final short INDEX_NWL_9D = 42;
    public static final short INDEX_NWL_10D = 43;
    public static final short INDEX_OSU86F = 44;
    public static final short INDEX_OSU91A = 45;
    public static final short INDEX_PLESSIS = 46;
    public static final short INDEX_STRUVE = 47;
    public static final short INDEX_MOD4_EVEREST = 48;
    public static final short INDEX_IRISH_WOFO = 49;
    public static final short INDEX_EVEREST_PAKISTAN = 50;
    public static final short INDEX_ATS77 = 51;
    public static final short INDEX_PZ90 = 52;
    public static final short INDEX_XIAN_1980 = 53;
    private static final double[] m_Constants;
    private static final String[] m_codeValues;
    public static final Ellipsoid none;
    public static final Ellipsoid GRS80;
    public static final Ellipsoid WGS84;
    public static final Ellipsoid sphere;
    public static final Ellipsoid clarke66;
    public static final Ellipsoid modClarke66;
    private static int constantsSize;
    private static Hashtable m_internalCodes;

    public Ellipsoid(String string, double d2, double d3, LinearUnit linearUnit) {
        super(string);
        this.set(d2, d3, linearUnit, false, "", "");
    }

    public Ellipsoid(String string, String string2) {
        this.init(string, string2);
    }

    Ellipsoid(double d2, double d3, LinearUnit linearUnit) {
        this.set(d2, d3, linearUnit, false, "", "");
    }

    Ellipsoid(double d2, double d3) {
        this.set(d2, d3, LinearUnit.meter, false, "", "");
    }

    Ellipsoid(String string, int n) {
        super(string);
        this.set(n);
    }

    protected Ellipsoid() {
    }

    public Ellipsoid(int n) {
        this.set(n);
    }

    private void init(String string, String string2) {
        String string3 = string2.toLowerCase() + ":" + string.toLowerCase();
        Integer n = (Integer)m_internalCodes.get(string3);
        if (n == null) {
            throw new IllegalArgumentException("Invalid code/codeSpace: " + string + "/" + string2);
        }
        int n2 = n;
        this.set(n2, string, string2);
    }

    protected void set(double d2, double d3, LinearUnit linearUnit, boolean bl, String string, String string2) {
        this.m_SemiMajorAxis = d2;
        this.m_InverseFlattening = d3;
        this.m_Flattening = this.m_InverseFlattening == 0.0 ? 0.0 : 1.0 / this.m_InverseFlattening;
        this.m_SemiMinorAxis = this.m_SemiMajorAxis * (1.0 - this.m_Flattening);
        this.m_EccentricitySquared = this.m_Flattening * (2.0 - this.m_Flattening);
        this.m_Eccentricity = Math.sqrt(this.m_EccentricitySquared);
        this.m_AxisUnit = linearUnit;
        this.m_bIgnore = bl;
        this.c(string);
        this.b(string2);
    }

    protected void init(double d2, double d3, LinearUnit linearUnit, String string, String string2) {
        this.m_SemiMajorAxis = d2;
        this.m_InverseFlattening = d3;
        this.m_Flattening = this.m_InverseFlattening == 0.0 ? 0.0 : 1.0 / this.m_InverseFlattening;
        this.m_SemiMinorAxis = this.m_SemiMajorAxis * (1.0 - this.m_Flattening);
        this.m_EccentricitySquared = this.m_Flattening * (2.0 - this.m_Flattening);
        this.m_Eccentricity = Math.sqrt(this.m_EccentricitySquared);
        this.m_AxisUnit = linearUnit;
        this.m_bIgnore = false;
        this.c(string);
        this.b(string2);
    }

    private void set(int n) {
        this.set(n, null, null);
    }

    private void set(int n, String string, String string2) {
        if (!Ellipsoid.isValidIndex(n)) {
            throw new IllegalArgumentException("Invalid Index: " + n);
        }
        if (string == null || string2 == null) {
            this.set(m_Constants[n * 2], m_Constants[n * 2 + 1], LinearUnit.meter, n == 29, m_codeValues[n * 2 + 1], m_codeValues[n * 2]);
        } else {
            this.set(m_Constants[n * 2], m_Constants[n * 2 + 1], LinearUnit.meter, n == 29, string, string2);
        }
    }

    public static boolean isValidIndex(int n) {
        return n >= 0 && n * 2 < m_Constants.length;
    }

    public int getIndex() {
        if (this.m_bIgnore) {
            return 29;
        }
        int n = 0;
        while (n < m_Constants.length) {
            if (this.m_SemiMajorAxis == m_Constants[n] && this.m_InverseFlattening == m_Constants[n + 1]) {
                return n / 2;
            }
            n += 2;
        }
        return 29;
    }

    public double a() {
        return this.m_SemiMajorAxis;
    }

    public double b() {
        return this.m_SemiMinorAxis;
    }

    public double e() {
        return this.m_Eccentricity;
    }

    public double e2() {
        return this.m_EccentricitySquared;
    }

    public double f() {
        return this.m_Flattening;
    }

    public double getSemiMajorAxis() {
        return this.m_SemiMajorAxis;
    }

    public double getSemiMinorAxis() {
        return this.m_SemiMinorAxis;
    }

    public double getInverseFlattening() {
        return this.m_InverseFlattening;
    }

    public LinearUnit getAxisUnit() {
        return this.m_AxisUnit;
    }

    public double getEccentricity() {
        return this.m_Eccentricity;
    }

    protected double getFlattening() {
        return this.m_Flattening;
    }

    protected double getEccentricitySquared() {
        return this.m_EccentricitySquared;
    }

    public boolean equals(Object object) {
        if (object instanceof Ellipsoid) {
            return this.equals((Ellipsoid)object);
        }
        return false;
    }

    public boolean equals(Ellipsoid ellipsoid) {
        if (this == ellipsoid) {
            return true;
        }
        return this.equivalent(ellipsoid) && this.e.equals(ellipsoid.e) && this.j.equals(ellipsoid.j) && this.i.equals(ellipsoid.i);
    }

    public boolean equivalent(Ellipsoid ellipsoid) {
        return this.m_SemiMajorAxis == ellipsoid.m_SemiMajorAxis && this.m_Flattening == ellipsoid.m_Flattening && this.m_AxisUnit.equivalent(ellipsoid.m_AxisUnit);
    }

    public String getWellKnownText() {
        return "SPHEROID[\"" + this.e + "\"," + LinearUnit.meter.convert(this.m_SemiMajorAxis, this.m_AxisUnit) + "," + this.m_InverseFlattening + "]";
    }

    static {
        INDEX_GRS80 = 0;
        INDEX_WGS72 = 1;
        INDEX_AUSTRALIAN = (short)2;
        INDEX_KRASSOVSKY = (short)3;
        INDEX_INTERNATIONAL = (short)4;
        INDEX_HAYFORD = (short)5;
        INDEX_CLARKE80 = (short)6;
        INDEX_CLARKE66 = (short)7;
        INDEX_MOD_CLARKE66 = (short)8;
        INDEX_AIRY = (short)9;
        INDEX_BESSEL = (short)10;
        INDEX_EVEREST = (short)11;
        INDEX_SPHERE = (short)12;
        INDEX_MOD_AIRY = (short)13;
        INDEX_MOD1_BESSEL = (short)14;
        INDEX_MOD1_CLARKE80 = (short)15;
        INDEX_MOD2_CLARKE80 = (short)16;
        INDEX_MOD1_EVEREST = (short)17;
        INDEX_FISCHER60 = (short)18;
        INDEX_MOD_FISCHER60 = (short)19;
        INDEX_FISCHER68 = (short)20;
        INDEX_GRS67 = (short)21;
        INDEX_HELMERT = (short)22;
        INDEX_HOUGH = (short)23;
        INDEX_SOUTH_AMERICAN = (short)24;
        INDEX_WAR_OFFICE = (short)25;
        INDEX_WGS60 = (short)26;
        INDEX_WGS66 = (short)27;
        INDEX_WGS84 = (short)28;
        INDEX_IGNORE = (short)29;
        INDEX_CLARKE80_IGN = (short)30;
        INDEX_IAG75 = (short)31;
        INDEX_MERIT83 = (short)32;
        INDEX_NEW_INTL67 = (short)33;
        INDEX_WALBECK = (short)34;
        INDEX_MOD2_BESSEL = (short)35;
        INDEX_CLARKE58 = (short)36;
        INDEX_MOD3_CLARKE80 = (short)37;
        INDEX_MOD4_CLARKE80 = (short)38;
        INDEX_MOD2_EVEREST = (short)39;
        INDEX_MOD3_EVEREST = (short)40;
        INDEX_INDONESIAN = (short)41;
        INDEX_NWL_9D = (short)42;
        INDEX_NWL_10D = (short)43;
        INDEX_OSU86F = (short)44;
        INDEX_OSU91A = (short)45;
        INDEX_PLESSIS = (short)46;
        INDEX_STRUVE = (short)47;
        INDEX_MOD4_EVEREST = (short)48;
        INDEX_IRISH_WOFO = (short)49;
        INDEX_EVEREST_PAKISTAN = (short)50;
        INDEX_ATS77 = (short)51;
        INDEX_PZ90 = (short)52;
        INDEX_XIAN_1980 = (short)53;
        m_Constants = new double[]{6378137.0, 298.257222101, 6378135.0, 298.26, 6378160.0, 298.25, 6378245.0, 298.3, 6378388.0, 297.0, 6378388.0, 297.0, 6378249.145, 293.465, 6378206.4, 294.9786982, 6378450.047484481, 294.9786982, 6377563.396, 299.3249646, 6377397.155, 299.1528128, 6377276.345, 300.8017, 6370997.0, 0.0, 6377340.189, 299.3249646, 6377483.865, 299.1528128, 6378249.145326, 293.4663076, 6378249.2, 293.46598, 6377304.063, 300.8017, 6378166.0, 298.3, 6378155.0, 298.3, 6378150.0, 298.3, 6378160.0, 298.247167427, 6378200.0, 298.3, 6378270.0, 297.0, 6378160.0, 298.25, 6378300.583, 296.0, 6378165.0, 298.3, 6378145.0, 298.25, 6378137.0, 298.257223563, 6378137.0, 298.257223563, 6378249.2, 293.4660213, 6378140.0, 298.257222, 6378137.0, 298.257, 6378157.5, 298.25, 6376896.0, 302.78, 6377492.0176, 299.15281, 6378293.639, 294.26068, 6378249.136, 293.46631, 6378300.79, 293.46623, 6377298.556, 300.8017, 6377301.243, 300.80174, 6378160.0, 298.247, 6378145.0, 298.25, 6378135.0, 298.26, 6378136.2, 298.25722, 6378136.3, 298.25722, 6376523.0, 308.64, 6378297.0, 294.73, 6377295.664, 300.8017, 6377542.178, 299.325, 6377309.613, 300.8017, 6378135.0, 298.257, 6378136.0, 298.257839303, 6378140.0, 298.257};
        String[] stringArray = new String[108];
        stringArray[0] = "epsg";
        stringArray[1] = "7019";
        stringArray[2] = "epsg";
        stringArray[3] = "7043";
        stringArray[4] = "epsg";
        stringArray[5] = "7003";
        stringArray[6] = "epsg";
        stringArray[7] = "7024";
        stringArray[8] = "epsg";
        stringArray[9] = "7022";
        stringArray[10] = "mapinfo";
        stringArray[11] = "ellipsoid5";
        stringArray[12] = "epsg";
        stringArray[13] = "7012";
        stringArray[14] = "mapinfo";
        stringArray[15] = "ellipsoid7";
        stringArray[16] = "epsg";
        stringArray[17] = "7008";
        stringArray[18] = "epsg";
        stringArray[19] = "7001";
        stringArray[20] = "epsg";
        stringArray[21] = "7004";
        stringArray[22] = "epsg";
        stringArray[23] = "7015";
        stringArray[24] = "mapinfo";
        stringArray[25] = "ellipsoid12";
        stringArray[26] = "epsg";
        stringArray[27] = "7002";
        stringArray[28] = "epsg";
        stringArray[29] = "7006";
        stringArray[30] = "epsg";
        stringArray[31] = "7013";
        stringArray[32] = "epsg";
        stringArray[33] = "7014";
        stringArray[34] = "epsg";
        stringArray[35] = "7018";
        stringArray[36] = "mapinfo";
        stringArray[37] = "ellipsoid18";
        stringArray[38] = "mapinfo";
        stringArray[39] = "ellipsoid19";
        stringArray[40] = "mapinfo";
        stringArray[41] = "ellipsoid20";
        stringArray[42] = "epsg";
        stringArray[43] = "7036";
        stringArray[44] = "epsg";
        stringArray[45] = "7020";
        stringArray[46] = "mapinfo";
        stringArray[47] = "ellipsoid23";
        stringArray[48] = "mapinfo";
        stringArray[49] = "ellipsoid24";
        stringArray[50] = "epsg";
        stringArray[51] = "7029";
        stringArray[52] = "mapinfo";
        stringArray[53] = "ellipsoid26";
        stringArray[54] = "mapinfo";
        stringArray[55] = "ellipsoid27";
        stringArray[56] = "epsg";
        stringArray[57] = "7030";
        stringArray[58] = "mapinfo";
        stringArray[59] = "ellipsoid29";
        stringArray[60] = "epsg";
        stringArray[61] = "7011";
        stringArray[62] = "mapinfo";
        stringArray[63] = "ellipsoid31";
        stringArray[64] = "mapinfo";
        stringArray[65] = "ellipsoid32";
        stringArray[66] = "mapinfo";
        stringArray[67] = "ellipsoid33";
        stringArray[68] = "mapinfo";
        stringArray[69] = "ellipsoid34";
        stringArray[70] = "mapinfo";
        stringArray[71] = "ellipsoid35";
        stringArray[72] = "mapinfo";
        stringArray[73] = "ellipsoid36";
        stringArray[74] = "mapinfo";
        stringArray[75] = "ellipsoid37";
        stringArray[76] = "mapinfo";
        stringArray[77] = "ellipsoid38";
        stringArray[78] = "epsg";
        stringArray[79] = "7016";
        stringArray[80] = "mapinfo";
        stringArray[81] = "ellipsoid40";
        stringArray[82] = "epsg";
        stringArray[83] = "7021";
        stringArray[84] = "epsg";
        stringArray[85] = "7025";
        stringArray[86] = "mapinfo";
        stringArray[87] = "ellipsoid43";
        stringArray[88] = "epsg";
        stringArray[89] = "7032";
        stringArray[90] = "epsg";
        stringArray[91] = "7033";
        stringArray[92] = "epsg";
        stringArray[93] = "7027";
        stringArray[94] = "mapinfo";
        stringArray[95] = "ellipsoid47";
        stringArray[96] = "mapinfo";
        stringArray[97] = "ellipsoid48";
        stringArray[98] = "mapinfo";
        stringArray[99] = "ellipsoid49";
        stringArray[100] = "mapinfo";
        stringArray[101] = "ellipsoid50";
        stringArray[102] = "epsg";
        stringArray[103] = "7041";
        stringArray[104] = "mapinfo";
        stringArray[105] = "ellipsoid52";
        stringArray[106] = "mapinfo";
        stringArray[107] = "ellipsoid53";
        m_codeValues = stringArray;
        none = new Ellipsoid("none", 29);
        GRS80 = new Ellipsoid("GRS80", 0);
        WGS84 = new Ellipsoid("WGS84", 28);
        sphere = new Ellipsoid("Sphere", 12);
        clarke66 = new Ellipsoid("Clarke 1866", 7);
        modClarke66 = new Ellipsoid("Modified Clarke 1866", 8);
        constantsSize = m_Constants.length / 2;
        m_internalCodes = new Hashtable(constantsSize);
        int n = 0;
        while (n < constantsSize) {
            String string = m_codeValues[n * 2].toLowerCase() + ":" + m_codeValues[n * 2 + 1].toLowerCase();
            m_internalCodes.put(string, new Integer(n));
            ++n;
        }
    }
}

