/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys;

import com.mapinfo.coordsys.GeodeticSpatialReferenceSystem;
import com.mapinfo.coordsys.HorizontalDatum;
import com.mapinfo.coordsys.PrimeMeridian;
import com.mapinfo.coordsys.SpatialReferenceSystem;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;

public class GeographicCoordinateSystem
extends GeodeticSpatialReferenceSystem {
    protected HorizontalDatum a;
    protected AngularUnit b;
    protected PrimeMeridian c;
    public static final GeographicCoordinateSystem datumless = new GeographicCoordinateSystem(HorizontalDatum.none);
    public static final GeographicCoordinateSystem NAD27 = new GeographicCoordinateSystem(HorizontalDatum.NAD27);
    public static final GeographicCoordinateSystem NAD83 = new GeographicCoordinateSystem(HorizontalDatum.NAD83);
    public static final GeographicCoordinateSystem WGS84 = new GeographicCoordinateSystem(HorizontalDatum.WGS84);

    public GeographicCoordinateSystem(String string, HorizontalDatum horizontalDatum, AngularUnit angularUnit, PrimeMeridian primeMeridian) {
        super(string);
        this.a = horizontalDatum;
        this.b = angularUnit;
        this.c = primeMeridian;
    }

    public GeographicCoordinateSystem(HorizontalDatum horizontalDatum, AngularUnit angularUnit, PrimeMeridian primeMeridian) {
        this("", horizontalDatum, angularUnit, primeMeridian);
    }

    public GeographicCoordinateSystem(HorizontalDatum horizontalDatum) {
        this(horizontalDatum, AngularUnit.degree, PrimeMeridian.greenwich);
    }

    public GeographicCoordinateSystem() {
        this(HorizontalDatum.none);
    }

    public GeographicCoordinateSystem getGeographicCoordinateSystem() {
        return this;
    }

    public HorizontalDatum getHorizontalDatum() {
        return this.a;
    }

    public AngularUnit getAngularUnit() {
        return this.b;
    }

    public LinearUnit getLinearUnit() {
        return null;
    }

    public PrimeMeridian getPrimeMeridian() {
        return this.c;
    }

    public String getWellKnownText() {
        return "GEOGCS[\"" + this.e + "\"," + this.a.getWellKnownText() + "," + this.c.getWellKnownText() + "," + this.b.getWellKnownText() + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof GeographicCoordinateSystem) {
            return this.equals((GeographicCoordinateSystem)object);
        }
        return false;
    }

    public boolean equals(GeographicCoordinateSystem geographicCoordinateSystem) {
        boolean bl = false;
        if (this == geographicCoordinateSystem) {
            return true;
        }
        if (geographicCoordinateSystem instanceof GeographicCoordinateSystem) {
            GeographicCoordinateSystem geographicCoordinateSystem2 = geographicCoordinateSystem;
            return this.a.equals(geographicCoordinateSystem2.a) && this.c.equals(geographicCoordinateSystem2.c) && this.e.equals(geographicCoordinateSystem2.getName()) && this.j.equals(geographicCoordinateSystem2.getCode()) && this.i.equals(geographicCoordinateSystem2.getCodeSpace());
        }
        return false;
    }

    public boolean equivalent(GeographicCoordinateSystem geographicCoordinateSystem) {
        boolean bl = this.a.equivalent(geographicCoordinateSystem.a) && this.c.equivalent(geographicCoordinateSystem.c);
        return bl;
    }

    public boolean equivalent(SpatialReferenceSystem spatialReferenceSystem) {
        if (spatialReferenceSystem instanceof GeographicCoordinateSystem) {
            return this.equivalent((GeographicCoordinateSystem)spatialReferenceSystem);
        }
        return false;
    }
}

