/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.GeographicCoordinateSystem;
import com.mapinfo.coordsys.SpatialReferenceInfo;
import java.util.Hashtable;

public class HorizontalDatum
extends SpatialReferenceInfo {
    protected Ellipsoid a;
    protected double b;
    protected double c;
    protected double d;
    protected double e;
    protected double f;
    protected double g;
    protected double h;
    private static final double[] i = new double[]{29.0, 0.0, 0.0, 0.0, 6.0, -162.0, -12.0, 206.0, 3.0, -43.0, -163.0, 45.0, 4.0, -150.0, -251.0, -2.0, 2.0, -491.0, -22.0, 435.0, 15.0, -143.0, -90.0, -294.0, 6.0, -160.0, -8.0, -300.0, 4.0, -207.0, 107.0, 52.0, 4.0, 145.0, 75.0, -272.0, 4.0, 114.0, -116.0, -333.0, 4.0, -320.0, 550.0, -494.0, 4.0, 124.0, -234.0, -25.0, 2.0, -133.0, -48.0, 148.0, 2.0, -134.0, -48.0, 149.0, 4.0, -127.0, -769.0, 472.0, 7.0, -73.0, 213.0, 296.0, 4.0, 307.0, 304.0, -318.0, 4.0, -148.0, 136.0, 90.0, 4.0, 298.0, -304.0, -375.0, 6.0, -136.0, -108.0, -292.0, 7.0, -2.0, 150.0, 181.0, 6.0, -263.0, 6.0, 431.0, 4.0, 175.0, -38.0, 113.0, 4.0, -134.0, 229.0, -29.0, 4.0, -206.0, 172.0, -6.0, 10.0, -377.0, 681.0, -50.0, 4.0, 230.0, -199.0, -752.0, 4.0, 211.0, 147.0, 111.0, 4.0, -87.0, -98.0, -121.0, 4.0, -86.0, -98.0, -119.0, 4.0, -133.0, -321.0, 50.0, 4.0, 84.0, -22.0, 209.0, 21.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.0, -100.0, -248.0, 259.0, 4.0, 252.0, -209.0, -751.0, 4.0, 16.0, 196.0, 93.0, 4.0, -73.0, 46.0, -86.0, 4.0, -156.0, -271.0, -189.0, 4.0, -634.0, -549.0, -201.0, 11.0, 214.0, 836.0, 303.0, 11.0, 289.0, 734.0, 257.0, 13.0, 506.0, -122.0, 611.0, 4.0, 208.0, -435.0, -229.0, 4.0, 191.0, -77.0, -204.0, 11.0, -97.0, 787.0, 86.0, 4.0, 145.0, -187.0, 103.0, 17.0, -11.0, 851.0, 5.0, 7.0, 42.0, 124.0, 147.0, 6.0, -90.0, 40.0, 88.0, 7.0, -133.0, -77.0, -51.0, 7.0, -133.0, -79.0, -72.0, 6.0, 41.0, -220.0, -134.0, 4.0, -289.0, -124.0, 60.0, 10.0, 639.0, 405.0, 60.0, 16.0, 31.0, 146.0, 47.0, 4.0, 912.0, -58.0, 1227.0, 6.0, -92.0, -93.0, 122.0, 6.0, -247.0, -148.0, 369.0, 6.0, -249.0, -156.0, 381.0, 6.0, -231.0, -196.0, 482.0, 4.0, -2.0, 374.0, 172.0, 7.0, -8.0, 160.0, 176.0, 7.0, -5.0, 135.0, 172.0, 7.0, -4.0, 154.0, 178.0, 7.0, 1.0, 140.0, 165.0, 7.0, -10.0, 158.0, 187.0, 7.0, 0.0, 125.0, 201.0, 7.0, -7.0, 152.0, 178.0, 7.0, 0.0, 125.0, 194.0, 7.0, -9.0, 152.0, 178.0, 7.0, 11.0, 114.0, 195.0, 7.0, -12.0, 130.0, 190.0, 8.0, -8.0, 160.0, 176.0, 0.0, 0.0, 0.0, 0.0, 4.0, -425.0, -169.0, 81.0, 22.0, -130.0, 110.0, -13.0, 7.0, 61.0, -285.0, -181.0, 6.0, -346.0, -1.0, 224.0, 9.0, 375.0, -111.0, 431.0, 4.0, -307.0, -92.0, 127.0, 4.0, 185.0, 165.0, 42.0, 4.0, -288.0, 175.0, -376.0, 7.0, 11.0, 72.0, -101.0, 4.0, -128.0, -283.0, 22.0, 4.0, 164.0, 138.0, -189.0, 4.0, 94.0, -948.0, -1262.0, 4.0, -225.0, -65.0, 9.0, 4.0, 170.0, 42.0, 84.0, 4.0, -203.0, 141.0, 53.0, 4.0, -355.0, 16.0, 74.0, 14.0, 616.0, 97.0, -251.0, 24.0, -57.0, 1.0, -41.0, 19.0, 7.0, -10.0, -26.0, 4.0, -499.0, -249.0, 314.0, 4.0, -104.0, 167.0, -38.0, 11.0, -689.0, 691.0, -46.0, 10.0, -128.0, 481.0, 664.0, 4.0, -632.0, 438.0, -609.0, 6.0, 51.0, 391.0, -36.0, 23.0, 101.0, 52.0, -39.0, 26.0, 0.0, 0.0, 0.0, 27.0, 0.0, 0.0, 0.0, 1.0, 0.0, 8.0, 10.0, 28.0, 0.0, 0.0, 0.0, 4.0, -155.0, 171.0, 37.0, 4.0, -265.0, 120.0, -358.0, 30.0, -168.0, -60.0, 320.0, 4.0, -83.0, -96.0, -113.0, 10.0, 593.0, 26.0, 478.0, 4.0, 81.0, 120.0, 129.0, 1.0, -1.0, 15.0, 1.0, 10.0, 498.0, -36.0, 568.0, 4.0, -303.0, -62.0, 105.0, 4.0, -223.0, 110.0, 37.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.0, -115.0, 118.0, 426.0, 6.0, -270.0, 13.0, 62.0, 6.0, -79.0, -129.0, 145.0, 10.0, -384.0, 664.0, -48.0, 10.0, 374.0, 150.0, 588.0, 6.0, -83.0, 37.0, 124.0, 6.0, 260.0, 12.0, -147.0, 6.0, -7.0, 215.0, 225.0, 4.0, -104.0, 167.0, -38.0, 4.0, -333.0, -222.0, 114.0, 10.0, 682.0, -203.0, 480.0, 50.0, 283.0, 682.0, 231.0, 11.0, 217.0, 823.0, 299.0, 11.0, 198.0, 881.0, 317.0, 11.0, 210.0, 814.0, 289.0, 41.0, -24.0, -15.0, 5.0, 4.0, -794.0, 119.0, -298.0, 4.0, 647.0, 1777.0, -1124.0, 6.0, -130.0, 29.0, 364.0, 6.0, 174.0, 359.0, 365.0, 6.0, -74.0, -130.0, 42.0, 6.0, -186.0, -93.0, 310.0, 4.0, -425.0, -169.0, 81.0, 6.0, -106.0, -129.0, 165.0, 6.0, -148.0, 51.0, -291.0, 4.0, -499.0, -249.0, 314.0, 4.0, -289.0, -124.0, 60.0, 6.0, -88.0, 4.0, 101.0, 10.0, 589.0, 76.0, 480.0, 4.0, -189.0, -242.0, -91.0, 6.0, -73.0, -247.0, 227.0, 6.0, -123.0, -206.0, 219.0, 28.0, 0.0, 0.0, 0.0, 51.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -199.87, 74.79, 246.62, 3.0, -31.4, 144.3, 81.2};
    private static final String[] j;
    private static final double[] k;
    private static final String[] l;
    public static final short INDEX_NONE = 0;
    public static final short INDEX_NAD27 = 62;
    public static final short INDEX_NAD83 = 74;
    public static final short INDEX_WGS84 = 104;
    public static final short INDEX_NTF_PARIS = 1002;
    public static final short INDEX_CUSTOM_3PARAM = 999;
    public static final short INDEX_CUSTOM_7PARAM = 9999;
    public static final HorizontalDatum none;
    public static final HorizontalDatum NAD27;
    public static final HorizontalDatum NAD83;
    public static final HorizontalDatum WGS84;
    private static Hashtable m;

    public HorizontalDatum(String string, Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        super(string);
        this.a(ellipsoid, d2, d3, d4, d5, d6, d7, d8);
    }

    public HorizontalDatum(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.a(ellipsoid, d2, d3, d4, d5, d6, d7, d8, null, null);
    }

    public HorizontalDatum(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6, double d7, double d8, String string, String string2) {
        this.a(ellipsoid, d2, d3, d4, d5, d6, d7, d8, string, string2);
    }

    public HorizontalDatum(Ellipsoid ellipsoid, double d2, double d3, double d4) {
        this.a(ellipsoid, d2, d3, d4, 0.0, 0.0, 0.0, 0.0);
    }

    public HorizontalDatum(Ellipsoid ellipsoid, double[] dArray) {
        if (dArray.length < 7) {
            this.a(ellipsoid, dArray[0], dArray[1], dArray[2], 0.0, 0.0, 0.0, 0.0);
        } else {
            this.a(ellipsoid, dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6]);
        }
    }

    public HorizontalDatum(String string, String string2) {
        this.a(string, string2);
    }

    private void a(String string, String string2) {
        String string3 = string2.toLowerCase() + ":" + string.toLowerCase();
        Integer n = (Integer)m.get(string3);
        if (n == null) {
            throw new IllegalArgumentException("Invalid code/codeSpace: " + string + "/" + string2);
        }
        int n2 = n;
        if (n2 >= j.length / 2) {
            n2 -= j.length / 2;
            this.a(n2 += 1000, string, string2);
        } else {
            this.a(n2, string, string2);
        }
    }

    public HorizontalDatum(String string, int n) {
        super(string);
        this.a(n);
    }

    public HorizontalDatum(int n) {
        this.a(n);
    }

    private void a(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.a(ellipsoid, d2, d3, d4, d5, d6, d7, d8, "", "");
    }

    private void a(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6, double d7, double d8, String string, String string2) {
        this.a = ellipsoid;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.e = d5;
        this.f = d6;
        this.g = d7;
        this.h = d8;
        this.c(string);
        this.b(string2);
    }

    private void a(int n) {
        if (n < 1000) {
            int n2 = n * 2;
            this.a(n, j[n2 + 1], j[n2]);
        } else {
            int n3 = (n - 1000) * 2;
            this.a(n, l[n3 + 1], l[n3]);
        }
    }

    private void a(int n, String string, String string2) {
        if (!HorizontalDatum.isValidIndex(n)) {
            throw new IllegalArgumentException("index not supported: " + n);
        }
        if (n < 1000) {
            this.a(new Ellipsoid((int)i[n *= 4]), i[n + 1], i[n + 2], i[n + 3], 0.0, 0.0, 0.0, 0.0, string, string2);
        } else {
            n = (n - 1000) * 8;
            this.a(new Ellipsoid((int)k[n]), k[n + 1], k[n + 2], k[n + 3], k[n + 4], k[n + 5], k[n + 6], k[n + 7], string, string2);
        }
    }

    public int getIndex() {
        int n;
        int n2 = this.a.getIndex();
        if (this.e == 0.0 && this.f == 0.0 && this.g == 0.0 && this.h == 0.0) {
            n = 0;
            while (n < i.length) {
                if (i[n] == (double)n2 && i[n + 1] == this.b && i[n + 2] == this.c && i[n + 3] == this.d) {
                    return n / 4;
                }
                n += 4;
            }
        }
        n = 0;
        while (n < k.length) {
            if (k[n] == (double)n2 && k[n + 1] == this.b && k[n + 2] == this.c && k[n + 3] == this.d && k[n + 4] == this.e && k[n + 5] == this.f && k[n + 6] == this.g && k[n + 7] == this.h) {
                return 1000 + n / 8;
            }
            n += 8;
        }
        return 9999;
    }

    public static boolean isValidIndex(int n) {
        return n >= 0 && n * 4 < i.length || n >= 1000 && (n - 1000) * 8 < k.length;
    }

    public boolean isNAD27() {
        return (this.a.equivalent(Ellipsoid.clarke66) || this.a.equivalent(Ellipsoid.modClarke66)) && this.b >= -20.0 && this.b <= 20.0 && this.c >= 100.0 && this.c <= 170.0 && this.d >= 160.0 && this.d <= 210.0;
    }

    public boolean isNAD83() {
        return this.a.equivalent(Ellipsoid.GRS80) && this.b == 0.0 && this.b == 0.0 && this.c == 0.0 && this.c == 0.0 && this.d == 0.0 && this.d == 0.0;
    }

    public Ellipsoid getEllipsoid() {
        return this.a;
    }

    public double getShiftX() {
        return this.b;
    }

    public double getShiftY() {
        return this.c;
    }

    public double getShiftZ() {
        return this.d;
    }

    public double getRotateX() {
        return this.e;
    }

    public double getRotateY() {
        return this.f;
    }

    public double getRotateZ() {
        return this.g;
    }

    public double getScaleAdjust() {
        return this.h;
    }

    public String getWellKnownText() {
        return "DATUM[\"" + ((SpatialReferenceInfo)this).e + "\"," + this.a.getWellKnownText() + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof HorizontalDatum) {
            return this.equals((HorizontalDatum)object);
        }
        return false;
    }

    public boolean equals(HorizontalDatum horizontalDatum) {
        if (this == horizontalDatum) {
            return true;
        }
        return this.equivalent(horizontalDatum) && ((SpatialReferenceInfo)this).e.equals(horizontalDatum.getName()) && ((SpatialReferenceInfo)this).j.equals(horizontalDatum.getCode()) && ((SpatialReferenceInfo)this).i.equals(horizontalDatum.getCodeSpace());
    }

    public boolean equivalent(HorizontalDatum horizontalDatum) {
        return this.a.equivalent(horizontalDatum.a) && this.b == horizontalDatum.b && this.c == horizontalDatum.c && this.d == horizontalDatum.d && this.e == horizontalDatum.e && this.f == horizontalDatum.f && this.g == horizontalDatum.g && this.h == horizontalDatum.h;
    }

    public static final boolean isNtf(GeographicCoordinateSystem geographicCoordinateSystem) {
        HorizontalDatum horizontalDatum = geographicCoordinateSystem.getHorizontalDatum();
        return horizontalDatum.getEllipsoid().getIndex() == 30 && horizontalDatum.getShiftX() == -168.0 && horizontalDatum.getShiftY() == -60.0 && horizontalDatum.getShiftZ() == 320.0 && horizontalDatum.getRotateX() == 0.0 && horizontalDatum.getRotateY() == 0.0 && horizontalDatum.getRotateZ() == 0.0;
    }

    public static final boolean isRgf93(GeographicCoordinateSystem geographicCoordinateSystem) {
        return HorizontalDatum.isNad83(geographicCoordinateSystem) || HorizontalDatum.isWgs84(geographicCoordinateSystem);
    }

    public static boolean isWgs84(GeographicCoordinateSystem geographicCoordinateSystem) {
        HorizontalDatum horizontalDatum = geographicCoordinateSystem.getHorizontalDatum();
        return horizontalDatum.getEllipsoid().getIndex() == 28 && horizontalDatum.getShiftX() == 0.0 && horizontalDatum.getShiftY() == 0.0 && horizontalDatum.getShiftZ() == 0.0 && horizontalDatum.getRotateX() == 0.0 && horizontalDatum.getRotateY() == 0.0 && horizontalDatum.getRotateZ() == 0.0 && horizontalDatum.getScaleAdjust() == 0.0;
    }

    public static boolean isNad83(GeographicCoordinateSystem geographicCoordinateSystem) {
        HorizontalDatum horizontalDatum = geographicCoordinateSystem.getHorizontalDatum();
        return horizontalDatum.getEllipsoid().getIndex() == 0 && horizontalDatum.getShiftX() == 0.0 && horizontalDatum.getShiftY() == 0.0 && horizontalDatum.getShiftZ() == 0.0 && horizontalDatum.getRotateX() == 0.0 && horizontalDatum.getRotateY() == 0.0 && horizontalDatum.getRotateZ() == 0.0 && horizontalDatum.getScaleAdjust() == 0.0;
    }

    public static boolean isJGD2000(GeographicCoordinateSystem geographicCoordinateSystem) {
        HorizontalDatum horizontalDatum = geographicCoordinateSystem.getHorizontalDatum();
        return (horizontalDatum.getEllipsoid().getIndex() == 0 || horizontalDatum.getEllipsoid().getIndex() == 28) && horizontalDatum.getShiftX() == 0.0 && horizontalDatum.getShiftY() == 0.0 && horizontalDatum.getShiftZ() == 0.0 && horizontalDatum.getRotateX() == 0.0 && horizontalDatum.getRotateY() == 0.0 && horizontalDatum.getRotateZ() == 0.0 && horizontalDatum.getScaleAdjust() == 0.0;
    }

    public static boolean isOldTokyo(GeographicCoordinateSystem geographicCoordinateSystem) {
        HorizontalDatum horizontalDatum = geographicCoordinateSystem.getHorizontalDatum();
        return horizontalDatum.getEllipsoid().getIndex() == 10 && horizontalDatum.getShiftX() == -128.0 && horizontalDatum.getShiftY() == 481.0 && horizontalDatum.getShiftZ() == 664.0 && horizontalDatum.getRotateX() == 0.0 && horizontalDatum.getRotateY() == 0.0 && horizontalDatum.getRotateZ() == 0.0 && horizontalDatum.getScaleAdjust() == 0.0;
    }

    static {
        String[] stringArray = new String[310];
        stringArray[0] = "mapinfo";
        stringArray[1] = "horizontaldatum0";
        stringArray[2] = "mapinfo";
        stringArray[3] = "horizontaldatum1";
        stringArray[4] = "epsg";
        stringArray[5] = "1107";
        stringArray[6] = "mapinfo";
        stringArray[7] = "horizontaldatum3";
        stringArray[8] = "mapinfo";
        stringArray[9] = "horizontaldatum4";
        stringArray[10] = "epsg";
        stringArray[11] = "1113";
        stringArray[12] = "mapinfo";
        stringArray[13] = "horizontaldatum6";
        stringArray[14] = "mapinfo";
        stringArray[15] = "horizontaldatum7";
        stringArray[16] = "mapinfo";
        stringArray[17] = "horizontaldatum8";
        stringArray[18] = "mapinfo";
        stringArray[19] = "horizontaldatum9";
        stringArray[20] = "mapinfo";
        stringArray[21] = "horizontaldatum10";
        stringArray[22] = "mapinfo";
        stringArray[23] = "horizontaldatum11";
        stringArray[24] = "epsg";
        stringArray[25] = "1108";
        stringArray[26] = "epsg";
        stringArray[27] = "1109";
        stringArray[28] = "mapinfo";
        stringArray[29] = "horizontaldatum14";
        stringArray[30] = "epsg";
        stringArray[31] = "1124";
        stringArray[32] = "epsg";
        stringArray[33] = "1125";
        stringArray[34] = "epsg";
        stringArray[35] = "1127";
        stringArray[36] = "mapinfo";
        stringArray[37] = "horizontaldatum18";
        stringArray[38] = "epsg";
        stringArray[39] = "1128";
        stringArray[40] = "mapinfo";
        stringArray[41] = "horizontaldatum20";
        stringArray[42] = "epsg";
        stringArray[43] = "1130";
        stringArray[44] = "mapinfo";
        stringArray[45] = "horizontaldatum22";
        stringArray[46] = "epsg";
        stringArray[47] = "1131";
        stringArray[48] = "epsg";
        stringArray[49] = "1132";
        stringArray[50] = "mapinfo";
        stringArray[51] = "horizontaldatum25";
        stringArray[52] = "mapinfo";
        stringArray[53] = "horizontaldatum26";
        stringArray[54] = "mapinfo";
        stringArray[55] = "horizontaldatum27";
        stringArray[56] = "epsg";
        stringArray[57] = "1133";
        stringArray[58] = "mapinfo";
        stringArray[59] = "horizontaldatum29";
        stringArray[60] = "mapinfo";
        stringArray[61] = "horizontaldatum30";
        stringArray[62] = "mapinfo";
        stringArray[63] = "horizontaldatum31";
        stringArray[64] = "mapinfo";
        stringArray[65] = "horizontaldatum32";
        stringArray[66] = "mapinfo";
        stringArray[67] = "horizontaldatum33";
        stringArray[68] = "mapinfo";
        stringArray[69] = "horizontaldatum34";
        stringArray[70] = "mapinfo";
        stringArray[71] = "horizontaldatum35";
        stringArray[72] = "mapinfo";
        stringArray[73] = "horizontaldatum36";
        stringArray[74] = "mapinfo";
        stringArray[75] = "horizontaldatum37";
        stringArray[76] = "mapinfo";
        stringArray[77] = "horizontaldatum38";
        stringArray[78] = "epsg";
        stringArray[79] = "1152";
        stringArray[80] = "mapinfo";
        stringArray[81] = "horizontaldatum40";
        stringArray[82] = "mapinfo";
        stringArray[83] = "horizontaldatum41";
        stringArray[84] = "mapinfo";
        stringArray[85] = "horizontaldatum42";
        stringArray[86] = "mapinfo";
        stringArray[87] = "horizontaldatum43";
        stringArray[88] = "mapinfo";
        stringArray[89] = "horizontaldatum44";
        stringArray[90] = "epsg";
        stringArray[91] = "1157";
        stringArray[92] = "mapinfo";
        stringArray[93] = "horizontaldatum46";
        stringArray[94] = "epsg";
        stringArray[95] = "1158";
        stringArray[96] = "mapinfo";
        stringArray[97] = "horizontaldatum48";
        stringArray[98] = "epsg";
        stringArray[99] = "1160";
        stringArray[100] = "epsg";
        stringArray[101] = "1161";
        stringArray[102] = "epsg";
        stringArray[103] = "1162";
        stringArray[104] = "epsg";
        stringArray[105] = "1164";
        stringArray[106] = "mapinfo";
        stringArray[107] = "horizontaldatum53";
        stringArray[108] = "mapinfo";
        stringArray[109] = "horizontaldatum54";
        stringArray[110] = "epsg";
        stringArray[111] = "1166";
        stringArray[112] = "mapinfo";
        stringArray[113] = "horizontaldatum56";
        stringArray[114] = "epsg";
        stringArray[115] = "1168";
        stringArray[116] = "epsg";
        stringArray[117] = "1189";
        stringArray[118] = "epsg";
        stringArray[119] = "1191";
        stringArray[120] = "mapinfo";
        stringArray[121] = "horizontaldatum60";
        stringArray[122] = "epsg";
        stringArray[123] = "1556";
        stringArray[124] = "epsg";
        stringArray[125] = "1173";
        stringArray[126] = "epsg";
        stringArray[127] = "1176";
        stringArray[128] = "epsg";
        stringArray[129] = "1177";
        stringArray[130] = "epsg";
        stringArray[131] = "1178";
        stringArray[132] = "epsg";
        stringArray[133] = "1172";
        stringArray[134] = "epsg";
        stringArray[135] = "1184";
        stringArray[136] = "mapinfo";
        stringArray[137] = "horizontaldatum68";
        stringArray[138] = "epsg";
        stringArray[139] = "1171";
        stringArray[140] = "epsg";
        stringArray[141] = "1185";
        stringArray[142] = "epsg";
        stringArray[143] = "1186";
        stringArray[144] = "epsg";
        stringArray[145] = "1187";
        stringArray[146] = "mapinfo";
        stringArray[147] = "horizontaldatum73";
        stringArray[148] = "epsg";
        stringArray[149] = "1188";
        stringArray[150] = "mapinfo";
        stringArray[151] = "horizontaldatum75";
        stringArray[152] = "mapinfo";
        stringArray[153] = "horizontaldatum76";
        stringArray[154] = "mapinfo";
        stringArray[155] = "horizontaldatum77";
        stringArray[156] = "mapinfo";
        stringArray[157] = "horizontaldatum78";
        stringArray[158] = "epsg";
        stringArray[159] = "1195";
        stringArray[160] = "mapinfo";
        stringArray[161] = "horizontaldatum80";
        stringArray[162] = "mapinfo";
        stringArray[163] = "horizontaldatum81";
        stringArray[164] = "mapinfo";
        stringArray[165] = "horizontaldatum82";
        stringArray[166] = "mapinfo";
        stringArray[167] = "horizontaldatum83";
        stringArray[168] = "epsg";
        stringArray[169] = "1561";
        stringArray[170] = "epsg";
        stringArray[171] = "1211";
        stringArray[172] = "mapinfo";
        stringArray[173] = "horizontaldatum86";
        stringArray[174] = "mapinfo";
        stringArray[175] = "horizontaldatum87";
        stringArray[176] = "mapinfo";
        stringArray[177] = "horizontaldatum88";
        stringArray[178] = "mapinfo";
        stringArray[179] = "horizontaldatum89";
        stringArray[180] = "mapinfo";
        stringArray[181] = "horizontaldatum90";
        stringArray[182] = "epsg";
        stringArray[183] = "1226";
        stringArray[184] = "epsg";
        stringArray[185] = "1212";
        stringArray[186] = "mapinfo";
        stringArray[187] = "horizontaldatum93";
        stringArray[188] = "mapinfo";
        stringArray[189] = "horizontaldatum94";
        stringArray[190] = "mapinfo";
        stringArray[191] = "horizontaldatum95";
        stringArray[192] = "mapinfo";
        stringArray[193] = "horizontaldatum96";
        stringArray[194] = "mapinfo";
        stringArray[195] = "horizontaldatum97";
        stringArray[196] = "mapinfo";
        stringArray[197] = "horizontaldatum98";
        stringArray[198] = "mapinfo";
        stringArray[199] = "horizontaldatum99";
        stringArray[200] = "mapinfo";
        stringArray[201] = "horizontaldatum100";
        stringArray[202] = "mapinfo";
        stringArray[203] = "horizontaldatum101";
        stringArray[204] = "mapinfo";
        stringArray[205] = "horizontaldatum102";
        stringArray[206] = "mapinfo";
        stringArray[207] = "horizontaldatum103";
        stringArray[208] = "mapinfo";
        stringArray[209] = "horizontaldatum104";
        stringArray[210] = "epsg";
        stringArray[211] = "1234";
        stringArray[212] = "epsg";
        stringArray[213] = "1235";
        stringArray[214] = "epsg";
        stringArray[215] = "1193";
        stringArray[216] = "mapinfo";
        stringArray[217] = "horizontaldatum108";
        stringArray[218] = "mapinfo";
        stringArray[219] = "horizontaldatum109";
        stringArray[220] = "mapinfo";
        stringArray[221] = "horizontaldatum110";
        stringArray[222] = "mapinfo";
        stringArray[223] = "horizontaldatum111";
        stringArray[224] = "mapinfo";
        stringArray[225] = "horizontaldatum112";
        stringArray[226] = "mapinfo";
        stringArray[227] = "horizontaldatum113";
        stringArray[228] = "mapinfo";
        stringArray[229] = "horizontaldatum114";
        stringArray[230] = "mapinfo";
        stringArray[231] = "horizontaldatum115";
        stringArray[232] = "epsg";
        stringArray[233] = "1150";
        stringArray[234] = "mapinfo";
        stringArray[235] = "horizontaldatum117";
        stringArray[236] = "epsg";
        stringArray[237] = "1577";
        stringArray[238] = "mapinfo";
        stringArray[239] = "horizontaldatum119";
        stringArray[240] = "mapinfo";
        stringArray[241] = "horizontaldatum120";
        stringArray[242] = "epsg";
        stringArray[243] = "1126";
        stringArray[244] = "mapinfo";
        stringArray[245] = "horizontaldatum122";
        stringArray[246] = "epsg";
        stringArray[247] = "1518";
        stringArray[248] = "mapinfo";
        stringArray[249] = "horizontaldatum124";
        stringArray[250] = "mapinfo";
        stringArray[251] = "horizontaldatum125";
        stringArray[252] = "mapinfo";
        stringArray[253] = "horizontaldatum126";
        stringArray[254] = "epsg";
        stringArray[255] = "1246";
        stringArray[256] = "mapinfo";
        stringArray[257] = "horizontaldatum128";
        stringArray[258] = "mapinfo";
        stringArray[259] = "horizontaldatum129";
        stringArray[260] = "epsg";
        stringArray[261] = "1153";
        stringArray[262] = "epsg";
        stringArray[263] = "1542";
        stringArray[264] = "epsg";
        stringArray[265] = "1304";
        stringArray[266] = "mapinfo";
        stringArray[267] = "horizontaldatum133";
        stringArray[268] = "mapinfo";
        stringArray[269] = "horizontaldatum134";
        stringArray[270] = "mapinfo";
        stringArray[271] = "horizontaldatum135";
        stringArray[272] = "mapinfo";
        stringArray[273] = "horizontaldatum136";
        stringArray[274] = "mapinfo";
        stringArray[275] = "horizontaldatum137";
        stringArray[276] = "epsg";
        stringArray[277] = "1163";
        stringArray[278] = "epsg";
        stringArray[279] = "1253";
        stringArray[280] = "mapinfo";
        stringArray[281] = "horizontaldatum140";
        stringArray[282] = "mapinfo";
        stringArray[283] = "horizontaldatum141";
        stringArray[284] = "epsg";
        stringArray[285] = "1200";
        stringArray[286] = "mapinfo";
        stringArray[287] = "horizontaldatum143";
        stringArray[288] = "mapinfo";
        stringArray[289] = "horizontaldatum144";
        stringArray[290] = "epsg";
        stringArray[291] = "1614";
        stringArray[292] = "mapinfo";
        stringArray[293] = "horizontaldatum146";
        stringArray[294] = "epsg";
        stringArray[295] = "1227";
        stringArray[296] = "epsg";
        stringArray[297] = "1294";
        stringArray[298] = "mapinfo";
        stringArray[299] = "horizontaldatum149";
        stringArray[300] = "epsg";
        stringArray[301] = "1505";
        stringArray[302] = "mapinfo";
        stringArray[303] = "horizontaldatum151";
        stringArray[304] = "mapinfo";
        stringArray[305] = "horizontaldatum152";
        stringArray[306] = "mapinfo";
        stringArray[307] = "horizontaldatum153";
        stringArray[308] = "mapinfo";
        stringArray[309] = "horizontaldatum154";
        j = stringArray;
        k = new double[]{10.0, 582.0, 105.0, 414.0, -1.04, -0.35, 3.08, 8.3, 3.0, 24.0, -123.0, -94.0, -0.02, 0.25, 0.13, 1.1, 30.0, -168.0, -60.0, 320.0, 0.0, 0.0, 0.0, 0.0, 10.0, 660.077, 13.551, 369.344, 0.804816, 0.577692, 0.952236, 5.66, 21.0, -56.0, 75.77, 15.31, -0.37, -0.2, -0.21, -1.01, 28.0, -134.73, -110.92, -292.66, 0.0, 0.0, 0.0, 1.0, 2.0, -117.763, -51.51, 139.061, -0.292, -0.443, -0.277, -0.191, 2.0, -129.193, -41.212, 130.73, -0.246, -0.374, -0.329, -2.955, 2.0, -120.271, -64.543, 161.632, -0.2175, 0.0672, 0.1291, 2.4985, 2.0, -119.353, -48.301, 139.484, -0.415, -0.26, -0.437, -0.613, 4.0, 59.47, -5.04, 187.44, -0.47, 0.1, -1.024, -4.5993, 10.0, 419.3836, 99.3335, 591.3451, -0.850389, -1.817277, 7.862238, -0.99496, 52.0, -1.08, -0.27, -0.9, 0.0, 0.0, -0.16, -0.12, 52.0, 23.92, -141.27, -80.9, 0.0, -0.35, -0.82, -0.12, 52.0, 24.82, -131.21, -82.66, 0.0, 0.0, -0.16, -0.12, 10.0, -146.414, 507.337, 680.507, 0.0, 0.0, 0.0, 0.0, 4.0, -96.062, -82.428, -121.754, -4.801, -0.345, 1.376, 1.496, 53.0, 24.0, -123.0, -94.0, -0.02, -0.25, 0.13, 1.1, 3.0, -40.59527, -18.54979, -69.33956, -2.508, -1.8319, 2.6114, -4.2991, 4.0, -99.059, 53.322, -112.486, -0.419, 0.83, -1.885, 0.999999};
        String[] stringArray2 = new String[40];
        stringArray2[0] = "epsg";
        stringArray2[1] = "1309";
        stringArray2[2] = "epsg";
        stringArray2[3] = "1310";
        stringArray2[4] = "mapinfo";
        stringArray2[5] = "horizontaldatum1002";
        stringArray2[6] = "mapinfo";
        stringArray2[7] = "horizontaldatum1003";
        stringArray2[8] = "epsg";
        stringArray2[9] = "1273";
        stringArray2[10] = "mapinfo";
        stringArray2[11] = "horizontaldatum1005";
        stringArray2[12] = "epsg";
        stringArray2[13] = "1280";
        stringArray2[14] = "epsg";
        stringArray2[15] = "1458";
        stringArray2[16] = "epsg";
        stringArray2[17] = "1594";
        stringArray2[18] = "epsg";
        stringArray2[19] = "1460";
        stringArray2[20] = "epsg";
        stringArray2[21] = "1567";
        stringArray2[22] = "epsg";
        stringArray2[23] = "1437";
        stringArray2[24] = "mapinfo";
        stringArray2[25] = "horizontaldatum1012";
        stringArray2[26] = "mapinfo";
        stringArray2[27] = "horizontaldatum1013";
        stringArray2[28] = "mapinfo";
        stringArray2[29] = "horizontaldatum1014";
        stringArray2[30] = "mapinfo";
        stringArray2[31] = "horizontaldatum1015";
        stringArray2[32] = "epsg";
        stringArray2[33] = "1536";
        stringArray2[34] = "mapinfo";
        stringArray2[35] = "horizontaldatum1017";
        stringArray2[36] = "mapinfo";
        stringArray2[37] = "horizontaldatum1018";
        stringArray2[38] = "mapinfo";
        stringArray2[39] = "horizontaldatum1019";
        l = stringArray2;
        INDEX_NONE = 0;
        INDEX_NAD27 = (short)62;
        INDEX_NAD83 = (short)74;
        INDEX_WGS84 = (short)104;
        INDEX_NTF_PARIS = (short)1002;
        INDEX_CUSTOM_3PARAM = (short)999;
        INDEX_CUSTOM_7PARAM = (short)9999;
        none = new HorizontalDatum("none", 0);
        NAD27 = new HorizontalDatum("NAD27", 62);
        NAD83 = new HorizontalDatum("NAD83", 74);
        WGS84 = new HorizontalDatum("WGS84", 104);
        m = new Hashtable(162);
        int n = j.length / 2;
        int n2 = 0;
        while (n2 < n) {
            String string = j[n2 * 2].toLowerCase() + ":" + j[n2 * 2 + 1].toLowerCase();
            m.put(string, new Integer(n2));
            ++n2;
        }
        int n3 = l.length / 2;
        int n4 = 0;
        while (n4 < n3) {
            m.put(l[n4 * 2].toLowerCase() + ":" + l[n4 * 2 + 1].toLowerCase(), new Integer(n4 + n));
            ++n4;
        }
    }
}

