/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys;

import com.mapinfo.coordsys.SpatialReferenceInfo;
import com.mapinfo.unit.AngularUnit;

public class PrimeMeridian
extends SpatialReferenceInfo {
    protected double a;
    protected AngularUnit b;
    public static final PrimeMeridian greenwich = new PrimeMeridian("Greenwich", 0.0, AngularUnit.degree, "8901", "EPSG");
    public static final PrimeMeridian paris = new PrimeMeridian("Paris", 2.337229166667, AngularUnit.degree, "8903", "EPSG");

    public PrimeMeridian(String string, double d2, AngularUnit angularUnit) {
        this.a(string, d2, angularUnit, "", "");
    }

    public PrimeMeridian(double d2, AngularUnit angularUnit) {
        this("", d2, angularUnit);
    }

    public PrimeMeridian(double d2) {
        this("", d2, AngularUnit.degree);
    }

    public PrimeMeridian(PrimeMeridian primeMeridian) {
        this(primeMeridian.e, primeMeridian.a, primeMeridian.b);
    }

    public PrimeMeridian() {
        this(greenwich);
    }

    public PrimeMeridian(String string, String string2) {
        if (string2.equalsIgnoreCase("epsg")) {
            int n = Integer.parseInt(string);
            switch (n) {
                case 8901: {
                    this.a("Greenwich", 0.0, AngularUnit.degree, "8901", "EPSG");
                    break;
                }
                case 8903: {
                    this.a("Paris", 2.337229166667, AngularUnit.degree, "8903", "EPSG");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid code[" + string + "] in codeSpace[EPSG]");
                }
            }
        } else {
            throw new IllegalArgumentException("codeSpace not supported: " + string2);
        }
    }

    private PrimeMeridian(String string, double d2, AngularUnit angularUnit, String string2, String string3) {
        this.a(string, d2, angularUnit, string2, string3);
    }

    public PrimeMeridian(int n) {
        this(n == 1002 ? paris : greenwich);
    }

    void a(String string, double d2, AngularUnit angularUnit, String string2, String string3) {
        this.a(string);
        this.a = d2;
        this.b = angularUnit;
        this.c(string2);
        this.b(string3);
    }

    public boolean matchesDatumIndex(int n) {
        return this.equivalent(n == 1002 ? paris : greenwich);
    }

    public double getLongitude() {
        return this.a;
    }

    public AngularUnit getAngularUnit() {
        return this.b;
    }

    public String getWellKnownText() {
        return "PRIMEM[\"" + this.e + "\"," + AngularUnit.degree.convert(this.a, this.b) + "]";
    }

    public boolean equals(Object object) {
        return object instanceof PrimeMeridian && this.a == ((PrimeMeridian)object).a && this.b.equals(((PrimeMeridian)object).b) && this.e.equals(((PrimeMeridian)object).e) && this.j.equals(((PrimeMeridian)object).j) && this.i.equals(((PrimeMeridian)object).i);
    }

    public boolean equivalent(PrimeMeridian primeMeridian) {
        return this.a == primeMeridian.a && this.b.equivalent(primeMeridian.b);
    }

    public int hashcode() {
        long l = Double.doubleToLongBits(this.a);
        int n = (int)(l ^ l >>> 32);
        n += this.b.hashCode();
        n += this.e.hashCode();
        n += this.j.hashCode();
        return n += this.i.hashCode();
    }
}

