/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.Distance;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.MathUtil;

public class AlbersEqualAreaConic
extends MIProProjection {
    private double a;
    private double b;
    private double c;
    private double d;
    private DoublePoint e;
    private Angle f;
    private Angle g;
    private Angle h;
    private Angle i;
    private Distance j;
    private Distance k;
    private double l;
    private double m;
    private double n;
    private double o;
    private double p;
    private double q;
    private double r;
    private double s;
    private double t;
    private double u;
    private double v;
    private double w;
    private double x;
    private boolean y;
    private boolean z;

    public AlbersEqualAreaConic() {
        super("Albers Equal-Area Conic");
    }

    public AlbersEqualAreaConic(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, DoublePoint doublePoint, double d2, double d3, double d4, double d5) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.e = new DoublePoint(doublePoint);
        this.a = d2;
        this.b = d3;
        this.d = d5;
        this.c = d4;
        this.f = new Angle(doublePoint.x, angularUnit);
        this.g = new Angle(doublePoint.y, angularUnit);
        this.h = new Angle(d2, angularUnit);
        this.i = new Angle(d3, angularUnit);
        this.j = new Distance(d4, linearUnit);
        this.k = new Distance(d5, linearUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        DoublePoint doublePoint;
        this.init(angularUnit, linearUnit, ellipsoid);
        this.e = doublePoint = new DoublePoint(measuredQuantityArray[0].getScalarValue(angularUnit), measuredQuantityArray[1].getScalarValue(angularUnit));
        this.a = measuredQuantityArray[2].getScalarValue(angularUnit);
        this.b = measuredQuantityArray[3].getScalarValue(angularUnit);
        this.c = measuredQuantityArray[4].getScalarValue(linearUnit);
        this.d = measuredQuantityArray[5].getScalarValue(linearUnit);
        this.f = new Angle(doublePoint.x, angularUnit);
        this.g = new Angle(doublePoint.y, angularUnit);
        this.h = new Angle(this.a, angularUnit);
        this.i = new Angle(this.b, angularUnit);
        this.j = new Distance(this.c, linearUnit);
        this.k = new Distance(this.d, linearUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Central_Meridian\"," + this.e.x + "]," + "PARAMETER[\"Latitude_of_Origin\"," + this.e.y + "]," + "PARAMETER[\"Standard_Parallel_1\"," + this.a + "]," + "PARAMETER[\"Standard_Parallel_2\"," + this.b + "]," + "PARAMETER[\"False_Easting\"," + this.c + "]," + "PARAMETER[\"False_Northing\"," + this.d + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof AlbersEqualAreaConic) {
            AlbersEqualAreaConic albersEqualAreaConic = (AlbersEqualAreaConic)projection;
            return super.equals(albersEqualAreaConic) && this.e.equals(albersEqualAreaConic.e) && this.a == albersEqualAreaConic.a && this.b == albersEqualAreaConic.b && this.c == albersEqualAreaConic.c && this.d == albersEqualAreaConic.d;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof AlbersEqualAreaConic) {
            AlbersEqualAreaConic albersEqualAreaConic = (AlbersEqualAreaConic)projection;
            boolean bl = super.equivalent(projection) && this.f.equivalent(albersEqualAreaConic.f) && this.g.equivalent(albersEqualAreaConic.g) && this.h.equivalent(albersEqualAreaConic.h) && this.i.equivalent(albersEqualAreaConic.i) && this.j.equivalent(albersEqualAreaConic.j) && this.k.equivalent(albersEqualAreaConic.k);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 9;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.e.x, this.m_AngularUnit), angularUnit.convert(this.e.y, this.m_AngularUnit), angularUnit.convert(this.a, this.m_AngularUnit), angularUnit.convert(this.b, this.m_AngularUnit), linearUnit.convert(this.c, this.m_LinearUnit), linearUnit.convert(this.d, this.m_LinearUnit)};
    }

    private void a() {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        this.l = this.m_Ellipsoid.e();
        this.m = 1.0 - this.m_Ellipsoid.e2();
        boolean bl = this.y = this.l == 0.0;
        if (!this.y) {
            this.n = 1.0 / (2.0 * this.l);
        }
        this.o = AngularUnit.radian.convertClipX(this.e.x, this.m_AngularUnit);
        dArray[0] = AngularUnit.radian.convertClipY(this.e.y, this.m_AngularUnit);
        dArray[1] = AngularUnit.radian.convertClipY(this.a, this.m_AngularUnit);
        dArray[2] = AngularUnit.radian.convertClipY(this.b, this.m_AngularUnit);
        int n = 0;
        while (n < 3) {
            dArray2[n] = Math.sin(dArray[n]);
            dArray3[n] = this.l * dArray2[n];
            dArray4[n] = dArray3[n] * dArray3[n];
            ++n;
        }
        n = 1;
        while (n < 3) {
            dArray5[n] = Math.cos(dArray[n]) / Math.sqrt(1.0 - dArray4[n]);
            ++n;
        }
        n = 0;
        while (n < 3) {
            dArray6[n] = this.y ? 2.0 * dArray2[n] : this.m * (dArray2[n] / (1.0 - dArray4[n]) - this.n * Math.log((1.0 - dArray3[n]) / (1.0 + dArray3[n])));
            ++n;
        }
        double d2 = dArray6[2] - dArray6[1];
        this.p = d2 != 0.0 ? (dArray5[1] * dArray5[1] - dArray5[2] * dArray5[2]) / d2 : dArray2[1];
        if (this.p == 0.0) {
            this.p = 1.0;
        }
        this.q = this.m_Ellipsoid.a() / this.p;
        this.r = this.p * this.p / (this.m_Ellipsoid.a() * this.m_Ellipsoid.a());
        this.z = this.p < 0.0;
        this.s = dArray5[1] * dArray5[1] + this.p * dArray6[1];
        d2 = this.s - this.p * dArray6[0];
        this.t = d2 > 0.0 ? this.q * Math.sqrt(d2) : 0.0;
        this.u = this.y ? 1.0 : 1.0 - this.m * this.n * Math.log((1.0 - this.l) / (1.0 + this.l));
        double d3 = this.m_Ellipsoid.e2() * this.m_Ellipsoid.e2();
        double d4 = this.m_Ellipsoid.e2() * d3;
        double d5 = this.m_Ellipsoid.e2() / 3.0 + 31.0 * d3 / 180.0 + 517.0 * d4 / 5040.0;
        double d6 = 23.0 * d3 / 360.0 + 251.0 * d4 / 3780.0;
        double d7 = 761.0 * d4 / 45360.0;
        this.v = d5 - d7;
        this.w = 2.0 * d6;
        this.x = 4.0 * d7;
    }

    public double getScaleFactor(double d2, double d3) {
        double d4 = AngularUnit.radian.convertClip(d3, this.m_AngularUnit, -89.9999, 89.9999);
        double d5 = Math.sin(d4);
        double d6 = this.l * d5;
        double d7 = d6 * d6;
        double d8 = Math.cos(d4) / Math.sqrt(1.0 - d7);
        double d9 = this.y ? 2.0 * d5 : this.m * (d5 / (1.0 - d7) - this.n * Math.log((1.0 - d6) / (1.0 + d6)));
        double d10 = this.s - this.p * d9;
        double d11 = d10 > 0.0 ? Math.sqrt(d10) / d8 : 0.0;
        return d11;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = AngularUnit.radian.convertClipX(dArray[n++], this.m_AngularUnit);
            double d3 = AngularUnit.radian.convertClipY(dArray[n++], this.m_AngularUnit);
            double d4 = d2;
            double d5 = d3;
            double d6 = Math.sin(d5);
            double d7 = this.l * d6;
            double d8 = d7 * d7;
            double d9 = this.y ? 2.0 * d6 : this.m * (d6 / (1.0 - d8) - this.n * Math.log((1.0 - d7) / (1.0 + d7)));
            double d10 = this.s - this.p * d9;
            double d11 = d10 > 0.0 ? this.q * Math.sqrt(d10) : 0.0;
            double d12 = this.p * (d4 - this.o);
            d2 = d11 * Math.sin(d12);
            d3 = this.t - d11 * Math.cos(d12);
            dArray2[n2++] = this.m_LinearUnit.convert(d2, this.m_EllipsoidUnit) + this.c;
            dArray2[n2++] = this.m_LinearUnit.convert(d3, this.m_EllipsoidUnit) + this.d;
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = this.m_EllipsoidUnit.convert(dArray[n++] - this.c, this.m_LinearUnit);
            double d3 = this.m_EllipsoidUnit.convert(dArray[n++] - this.d, this.m_LinearUnit);
            double d4 = this.t - d3;
            double d5 = Math.sqrt(d2 * d2 + d4 * d4);
            if (this.z) {
                d2 = -d2;
                d4 = -d4;
            }
            double d6 = d2 != 0.0 || d4 != 0.0 ? Math.atan2(d2, d4) : 0.0;
            double d7 = (this.s - d5 * d5 * this.r) / this.p;
            double d8 = d7 / this.u;
            double d9 = Math.asin(MathUtil.clip((double)d8, (double)-1.0, (double)1.0));
            d2 = this.o + d6 / this.p;
            double d10 = 2.0 * d9;
            double d11 = Math.cos(d10);
            d3 = d9 + Math.sin(d10) * (this.v + d11 * (this.w + d11 * this.x));
            dArray2[n2++] = this.m_AngularUnit.convert(d2, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d3, AngularUnit.radian);
        }
    }
}

