/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.Distance;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.MathUtil;

public class CassiniSoldner
extends MIProProjection {
    private DoublePoint a;
    private double b;
    private double c;
    private Angle d;
    private Angle e;
    private Distance f;
    private Distance g;
    private double h;
    private double i;
    private double j;
    private double k;
    private double l;
    private double m;
    private double n;
    private double o;
    private double p;
    private double q;

    public CassiniSoldner() {
        super("Cassini-Soldner");
    }

    public CassiniSoldner(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, DoublePoint doublePoint, double d2, double d3) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = new DoublePoint(doublePoint);
        this.b = d2;
        this.c = d3;
        this.d = new Angle(doublePoint.x, angularUnit);
        this.e = new Angle(doublePoint.y, angularUnit);
        this.f = new Distance(this.b, linearUnit);
        this.g = new Distance(this.c, linearUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        DoublePoint doublePoint;
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = doublePoint = new DoublePoint(measuredQuantityArray[0].getScalarValue(angularUnit), measuredQuantityArray[1].getScalarValue(angularUnit));
        this.b = measuredQuantityArray[2].getScalarValue(linearUnit);
        this.c = measuredQuantityArray[3].getScalarValue(linearUnit);
        this.d = new Angle(doublePoint.x, angularUnit);
        this.e = new Angle(doublePoint.y, angularUnit);
        this.f = new Distance(this.b, linearUnit);
        this.g = new Distance(this.c, linearUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Longitude_of_Center\"," + this.a.x + "]," + "PARAMETER[\"Latitude_of_Center\"," + this.a.y + "]," + "PARAMETER[\"False_Easting\"," + this.b + "]," + "PARAMETER[\"False_Northing\"," + this.c + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof CassiniSoldner) {
            CassiniSoldner cassiniSoldner = (CassiniSoldner)projection;
            return super.equals(cassiniSoldner) && this.a.equals(cassiniSoldner.a) && this.b == cassiniSoldner.b && this.c == cassiniSoldner.c;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof CassiniSoldner) {
            CassiniSoldner cassiniSoldner = (CassiniSoldner)projection;
            boolean bl = super.equivalent(cassiniSoldner) && this.d.equivalent(cassiniSoldner.d) && this.e.equivalent(cassiniSoldner.e) && this.f.equivalent(cassiniSoldner.f) && this.g.equivalent(cassiniSoldner.g);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 30;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a.x, this.m_AngularUnit), angularUnit.convert(this.a.y, this.m_AngularUnit), linearUnit.convert(this.b, this.m_LinearUnit), linearUnit.convert(this.c, this.m_LinearUnit)};
    }

    private void a() {
        this.h = AngularUnit.radian.convertClip(this.d.getScalarValue(), this.d.getAngularUnit(), -360.0, 360.0);
        double d2 = (1.0 - Math.sqrt(1.0 - this.m_Ellipsoid.e2())) / (1.0 + Math.sqrt(1.0 - this.m_Ellipsoid.e2()));
        double d3 = d2 * d2;
        double d4 = d2 * d3;
        double d5 = d3 * d3;
        double d6 = AngularUnit.radian.convertClip(this.e.getScalarValue(), this.e.getAngularUnit(), -90.0, 90.0);
        double d7 = this.m_Ellipsoid.e2() * this.m_Ellipsoid.e2();
        double d8 = this.m_Ellipsoid.e2() * d7;
        double d9 = this.m_Ellipsoid.getSemiMajorAxis() * -(3.0 * this.m_Ellipsoid.e2() / 8.0 + 3.0 * d7 / 32.0 + 45.0 * d8 / 1024.0);
        double d10 = this.m_Ellipsoid.getSemiMajorAxis() * (15.0 * d7 / 256.0 + 45.0 * d8 / 1024.0);
        double d11 = this.m_Ellipsoid.getSemiMajorAxis() * -35.0 * d8 / 3072.0;
        this.i = this.m_Ellipsoid.getSemiMajorAxis() * (1.0 - this.m_Ellipsoid.e2() / 4.0 - 3.0 * d7 / 64.0 - 5.0 * d8 / 256.0);
        this.j = d9 - d11;
        this.k = 2.0 * d10;
        this.l = 4.0 * d11;
        d9 = 3.0 * d2 / 2.0 - 27.0 * d4 / 32.0;
        d10 = 21.0 * d3 / 16.0 - 55.0 * d5 / 32.0;
        d11 = 151.0 * d4 / 96.0;
        double d12 = 1097.0 * d5 / 512.0;
        this.m = d9 - d11;
        this.n = 2.0 * d10 - 4.0 * d12;
        this.o = 4.0 * d11;
        this.p = 8.0 * d12;
        double d13 = d6 * 2.0;
        double d14 = Math.cos(d13);
        this.q = this.i * d6 + Math.sin(d13) * (this.j + d14 * (this.k + d14 * this.l));
    }

    public double getScaleFactor(double d2, double d3) {
        return 1.0;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3;
            double d4 = dArray[n++] - this.d.getScalarValue(AngularUnit.degree);
            double d5 = dArray[n++];
            d4 = AngularUnit.radian.convertClip(d4, AngularUnit.degree, -360.0, 360.0);
            double d6 = Math.cos(d5 = AngularUnit.radian.convertClip(d5, AngularUnit.degree, -180.0, 180.0));
            if (0.0 == d6 || 1.5707963267948966 == d5 || -1.5707963267948966 == d5) {
                d3 = 0.0;
                d2 = this.i * d5 - this.q;
            } else {
                double d7 = Math.sin(d5);
                double d8 = Math.tan(d5);
                double d9 = d5 * 2.0;
                double d10 = Math.cos(d9);
                double d11 = this.i * d5 + Math.sin(d9) * (this.j + d10 * (this.k + d10 * this.l));
                double d12 = this.m_Ellipsoid.e2() * d6 * d6 / (1.0 - this.m_Ellipsoid.e2());
                double d13 = d4 * d6;
                double d14 = d13 * d13;
                double d15 = d14 * d13;
                double d16 = d15 * d13;
                double d17 = d16 * d13;
                double d18 = d8 * d8;
                double d19 = this.m_Ellipsoid.getSemiMajorAxis() / Math.sqrt(1.0 - this.m_Ellipsoid.e2() * d7 * d7);
                d3 = d19 * (d13 - d18 * d15 / 6.0 - (8.0 - d18 + 8.0 * d12) * d18 * d17 / 120.0);
                d2 = d11 - this.q + d19 * d8 * (d14 / 2.0 + (5.0 - d18 + 6.0 * d12) * d16 / 24.0);
            }
            d3 = this.m_LinearUnit.convert(d3, this.m_Ellipsoid.getAxisUnit());
            d2 = this.m_LinearUnit.convert(d2, this.m_Ellipsoid.getAxisUnit());
            dArray2[n2++] = d3 += this.f.getScalarValue(this.m_LinearUnit);
            dArray2[n2++] = d2 += this.g.getScalarValue(this.m_LinearUnit);
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = this.m_EllipsoidUnit.convert(dArray[n++] - this.b, this.m_LinearUnit);
            double d3 = this.m_EllipsoidUnit.convert(dArray[n++] - this.c, this.m_LinearUnit);
            double d4 = this.q + d3;
            double d5 = d4 / this.i;
            double d6 = 2.0 * d5;
            double d7 = Math.cos(d6);
            double d8 = d5 + Math.sin(d6) * (this.m + d7 * (this.n + d7 * (this.o + this.p * d7)));
            if (1.5707963267948966 == (d8 = MathUtil.clip((double)d8, (double)-1.5707963267948966, (double)1.5707963267948966)) || -1.5707963267948966 == d8) {
                d2 = this.h;
                d3 = d8;
            } else {
                double d9 = Math.tan(d8);
                double d10 = Math.sin(d8);
                double d11 = Math.cos(d8);
                double d12 = d9 * d9;
                double d13 = 1.0 - this.m_Ellipsoid.e2() * d10 * d10;
                double d14 = this.m_Ellipsoid.getSemiMajorAxis() / Math.sqrt(d13);
                double d15 = this.m_Ellipsoid.getSemiMajorAxis() * (1.0 - this.m_Ellipsoid.e2()) / (d13 * Math.sqrt(d13));
                double d16 = d2 / d14;
                double d17 = d16 * d16;
                double d18 = d17 * d16;
                double d19 = d18 * d16;
                double d20 = d19 * d16;
                d2 = this.h + (d16 - d12 * d18 / 3.0 + (1.0 + 3.0 * d12) * d12 * d20 / 15.0) / d11;
                d3 = d8 - d14 * d9 / d15 * (d17 / 2.0 - (1.0 + 3.0 * d12) * d19 / 24.0);
            }
            dArray2[n2++] = this.m_AngularUnit.convertClip(d2, AngularUnit.radian, -360.0, 360.0);
            dArray2[n2++] = this.m_AngularUnit.convertClip(d3, AngularUnit.radian, -90.0, 90.0);
        }
    }
}

