/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.MathUtil;

public class EckertVI
extends MIProProjection {
    private double a;
    private Angle b;
    private double c;
    private double d;
    private double e;
    private double f;

    public EckertVI() {
        super("Eckert VI");
    }

    public EckertVI(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, double d2) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = d2;
        this.b = new Angle(this.a, angularUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = measuredQuantityArray[0].getScalarValue(angularUnit);
        this.b = new Angle(this.a, angularUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Central_Meridian\"," + this.a + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof EckertVI) {
            EckertVI eckertVI = (EckertVI)projection;
            return super.equals(eckertVI) && this.a == eckertVI.a;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof EckertVI) {
            EckertVI eckertVI = (EckertVI)projection;
            boolean bl = super.equivalent(eckertVI) && this.b.equivalent(eckertVI.b);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 15;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a, this.m_AngularUnit)};
    }

    private void a() {
        this.c = this.m_Ellipsoid.a();
        this.e = this.c / Math.sqrt(5.141592653589793);
        this.f = 2.0 * this.e;
        this.d = AngularUnit.radian.convertClipY(this.a, this.m_AngularUnit);
    }

    public double getScaleFactor(double d2, double d3) {
        double d4;
        double d5 = AngularUnit.radian.convertClipY(d3, this.m_AngularUnit);
        double d6 = Math.cos(d5);
        if (d6 == 0.0) {
            d4 = 1.0E9;
        } else {
            double d7;
            double d8 = 2.5707963267948966 * Math.sin(d5);
            double d9 = d5;
            while (true) {
                d7 = Math.cos(d9);
                double d10 = (d9 + Math.sin(d9) - d8) / (1.0 + d7);
                if (d10 > -1.0E-7 && d10 < 1.0E-7) break;
                d9 -= d10;
            }
            d4 = this.e * (1.0 + d7) / (this.c * d6);
        }
        return d4;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3 = AngularUnit.radian.convertClipX(dArray[n++], this.m_AngularUnit);
            double d4 = AngularUnit.radian.convertClipY(dArray[n++], this.m_AngularUnit);
            double d5 = d3;
            double d6 = d4;
            double d7 = 2.5707963267948966 * Math.sin(d6);
            double d8 = d6;
            while (true) {
                d2 = Math.cos(d8);
                double d9 = (d8 + Math.sin(d8) - d7) / (1.0 + d2);
                if (d9 > -1.0E-7 && d9 < 1.0E-7) break;
                d8 -= d9;
            }
            d3 = this.e * (d5 - this.d) * (1.0 + d2);
            d4 = this.f * d8;
            dArray2[n2++] = this.m_LinearUnit.convert(d3, this.m_EllipsoidUnit);
            dArray2[n2++] = this.m_LinearUnit.convert(d4, this.m_EllipsoidUnit);
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d3 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d4 = d3 / this.f;
            double d5 = MathUtil.clip((double)d4, (double)-1.5707963267948966, (double)1.5707963267948966);
            d4 = (d5 + Math.sin(d5)) / 2.5707963267948966;
            d3 = Math.asin(MathUtil.clip((double)d4, (double)-1.0, (double)1.0));
            d2 = this.d + d2 / (this.e * (1.0 + Math.cos(d5)));
            dArray2[n2++] = this.m_AngularUnit.convert(d2, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d3, AngularUnit.radian);
        }
    }
}

