/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.Distance;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.MathUtil;

public class EquidistantConic
extends MIProProjection {
    private DoublePoint a;
    private double b;
    private double c;
    private double d;
    private double e;
    private Angle f;
    private Angle g;
    private Angle h;
    private Angle i;
    private Distance j;
    private Distance k;
    private double l;
    private double m;
    private double n;
    private double o;
    private double p;
    private double q;
    private double r;
    private double s;
    private double t;
    private double u;
    private double v;
    private double w;
    private double x;
    private boolean y;

    public EquidistantConic() {
        super("Equidistant Conic");
    }

    public EquidistantConic(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, DoublePoint doublePoint, double d2, double d3, double d4, double d5) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = new DoublePoint(doublePoint);
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.e = d5;
        this.f = new Angle(doublePoint.x, angularUnit);
        this.g = new Angle(doublePoint.y, angularUnit);
        this.h = new Angle(d2, angularUnit);
        this.i = new Angle(d3, angularUnit);
        this.j = new Distance(d4, linearUnit);
        this.k = new Distance(d5, linearUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        DoublePoint doublePoint;
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = doublePoint = new DoublePoint(measuredQuantityArray[0].getScalarValue(angularUnit), measuredQuantityArray[1].getScalarValue(angularUnit));
        this.b = measuredQuantityArray[2].getScalarValue(angularUnit);
        this.c = measuredQuantityArray[3].getScalarValue(angularUnit);
        this.d = measuredQuantityArray[4].getScalarValue(linearUnit);
        this.e = measuredQuantityArray[5].getScalarValue(linearUnit);
        this.f = new Angle(doublePoint.x, angularUnit);
        this.g = new Angle(doublePoint.y, angularUnit);
        this.h = new Angle(this.b, angularUnit);
        this.i = new Angle(this.c, angularUnit);
        this.j = new Distance(this.d, linearUnit);
        this.k = new Distance(this.e, linearUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Central_Meridian\"," + this.a.x + "]," + "PARAMETER[\"Latitude_of_Origin\"," + this.a.y + "]," + "PARAMETER[\"Standard_Parallel_1\"," + this.b + "]," + "PARAMETER[\"Standard_Parallel_2\"," + this.c + "]," + "PARAMETER[\"False_Easting\"," + this.d + "]," + "PARAMETER[\"False_Northing\"," + this.e + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof EquidistantConic) {
            EquidistantConic equidistantConic = (EquidistantConic)projection;
            return super.equals(equidistantConic) && this.a.equals(equidistantConic.a) && this.b == equidistantConic.b && this.c == equidistantConic.c && this.d == equidistantConic.d && this.e == equidistantConic.e;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof EquidistantConic) {
            EquidistantConic equidistantConic = (EquidistantConic)projection;
            boolean bl = super.equivalent(projection) && this.f.equivalent(equidistantConic.f) && this.g.equivalent(equidistantConic.g) && this.h.equivalent(equidistantConic.h) && this.i.equivalent(equidistantConic.i) && this.j.equivalent(equidistantConic.j) && this.k.equivalent(equidistantConic.k);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 6;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a.x, this.m_AngularUnit), angularUnit.convert(this.a.y, this.m_AngularUnit), angularUnit.convert(this.b, this.m_AngularUnit), angularUnit.convert(this.c, this.m_AngularUnit), linearUnit.convert(this.d, this.m_LinearUnit), linearUnit.convert(this.e, this.m_LinearUnit)};
    }

    private void a() {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        this.m = AngularUnit.radian.convertClipX(this.a.x, this.m_AngularUnit);
        this.l = this.m_Ellipsoid.e();
        dArray[0] = AngularUnit.radian.convertClipY(this.a.y, this.m_AngularUnit);
        dArray[1] = AngularUnit.radian.convertClipY(this.b, this.m_AngularUnit);
        dArray[2] = AngularUnit.radian.convertClipY(this.c, this.m_AngularUnit);
        double d2 = this.m_Ellipsoid.e2() * this.m_Ellipsoid.e2();
        double d3 = this.m_Ellipsoid.e2() * d2;
        this.q = this.m_Ellipsoid.a() * (1.0 - this.m_Ellipsoid.e2() / 4.0 - 3.0 * d2 / 64.0 - 5.0 * d3 / 256.0);
        double d4 = this.m_Ellipsoid.a() * -(3.0 * this.m_Ellipsoid.e2() / 8.0 + 3.0 * d2 / 32.0 + 45.0 * d3 / 1024.0);
        double d5 = this.m_Ellipsoid.a() * (15.0 * d2 / 256.0 + 45.0 * d3 / 1024.0);
        double d6 = this.m_Ellipsoid.a() * -35.0 * d3 / 3072.0;
        this.r = d4 - d6;
        this.s = 2.0 * d5;
        this.t = 4.0 * d6;
        int n = 0;
        while (n < 3) {
            double d7 = dArray[n] * 2.0;
            double d8 = Math.cos(d7);
            dArray3[n] = this.q * dArray[n] + Math.sin(d7) * (this.r + d8 * (this.s + d8 * this.t));
            ++n;
        }
        n = 1;
        while (n < 3) {
            double d9 = Math.sin(dArray[n]);
            dArray2[n] = Math.cos(dArray[n]) / Math.sqrt(1.0 - this.m_Ellipsoid.e2() * d9 * d9);
            ++n;
        }
        double d10 = dArray3[2] - dArray3[1];
        this.n = d10 != 0.0 ? this.m_Ellipsoid.a() * (dArray2[1] - dArray2[2]) / d10 : Math.sin(dArray[1]);
        if (this.n == 0.0) {
            this.n = 1.0;
        }
        this.y = this.n < 0.0;
        double d11 = dArray2[1] / this.n + dArray3[1] / this.m_Ellipsoid.a();
        this.o = this.m_Ellipsoid.a() * d11;
        this.p = this.o - dArray3[0];
        d10 = Math.sqrt(1.0 - this.m_Ellipsoid.e2());
        double d12 = (1.0 - d10) / (1.0 + d10);
        double d13 = d12 * d12;
        double d14 = d13 * d12;
        double d15 = d13 * d13;
        d4 = 3.0 * d12 / 2.0 - 27.0 * d14 / 32.0;
        d5 = 21.0 * d13 / 16.0 - 55.0 * d15 / 32.0;
        d6 = 151.0 * d14 / 96.0;
        double d16 = 1097.0 * d15 / 512.0;
        this.u = d4 - d6;
        this.v = 2.0 * d5 - 4.0 * d16;
        this.w = 4.0 * d6;
        this.x = 8.0 * d16;
    }

    public double getScaleFactor(double d2, double d3) {
        double d4 = AngularUnit.radian.convertClip(d3, this.m_AngularUnit, -89.9999, 89.9999);
        double d5 = this.l * Math.sin(d4);
        double d6 = Math.cos(d4) / Math.sqrt(1.0 - d5 * d5);
        double d7 = d4 * 2.0;
        double d8 = Math.cos(d7);
        double d9 = this.q * d4 + Math.sin(d7) * (this.r + d8 * (this.s + d8 * this.t));
        double d10 = this.o - d9;
        double d11 = d10 * this.n / (this.m_Ellipsoid.a() * d6);
        return d11;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3 = AngularUnit.radian.convertClipX(dArray[n++], this.m_AngularUnit);
            double d4 = d2 = AngularUnit.radian.convertClipY(dArray[n++], this.m_AngularUnit);
            double d5 = this.n * (d3 - this.m);
            double d6 = d4 * 2.0;
            double d7 = Math.cos(d6);
            double d8 = this.q * d4 + Math.sin(d6) * (this.r + d7 * (this.s + d7 * this.t));
            double d9 = this.o - d8;
            d3 = d9 * Math.sin(d5);
            d2 = this.p - d9 * Math.cos(d5);
            dArray2[n2++] = this.m_LinearUnit.convert(d3, this.m_EllipsoidUnit) + this.d;
            dArray2[n2++] = this.m_LinearUnit.convert(d2, this.m_EllipsoidUnit) + this.e;
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = this.m_EllipsoidUnit.convert(dArray[n++] - this.d, this.m_LinearUnit);
            double d3 = this.m_EllipsoidUnit.convert(dArray[n++] - this.e, this.m_LinearUnit);
            d2 = MathUtil.clip((double)d2, (double)-1.0E9, (double)1.0E9);
            d3 = MathUtil.clip((double)d3, (double)-1.0E9, (double)1.0E9);
            double d4 = this.p - d3;
            double d5 = Math.sqrt(d2 * d2 + d4 * d4);
            if (this.y) {
                d5 = -d5;
                d2 = -d2;
                d4 = -d4;
            }
            double d6 = d2 != 0.0 || d4 != 0.0 ? Math.atan2(d2, d4) : 0.0;
            double d7 = this.o - d5;
            double d8 = d7 / this.q;
            d2 = this.m + d6 / this.n;
            double d9 = 2.0 * d8;
            double d10 = Math.cos(d9);
            d3 = d8 + Math.sin(d9) * (this.u + d10 * (this.v + d10 * (this.w + d10 * this.x)));
            dArray2[n2++] = this.m_AngularUnit.convert(d2, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d3, AngularUnit.radian);
        }
    }
}

