/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;

public class Gall
extends MIProProjection {
    private double a;
    private Angle b;
    private double c;
    private double d;
    private double e;
    private double f;

    public Gall() {
        super("Gall");
    }

    public Gall(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, double d2) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = d2;
        this.b = new Angle(this.a, angularUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = measuredQuantityArray[0].getScalarValue(angularUnit);
        this.b = new Angle(this.a, angularUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Central_Meridian\"," + this.a + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof Gall) {
            Gall gall = (Gall)projection;
            return super.equals(gall) && this.a == gall.a;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof Gall) {
            Gall gall = (Gall)projection;
            boolean bl = super.equivalent(gall) && this.b.equivalent(gall.b);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 17;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a, this.m_AngularUnit)};
    }

    private void a() {
        double d2 = this.m_Ellipsoid.a();
        this.d = Math.sqrt(2.0);
        this.e = d2 / this.d;
        this.f = d2 * (1.0 + this.d / 2.0);
        this.c = AngularUnit.radian.convertClipX(this.a, this.m_AngularUnit);
    }

    public double getScaleFactor(double d2, double d3) {
        double d4 = Math.cos(AngularUnit.radian.convertClipY(d3, this.m_AngularUnit));
        double d5 = d4 == 0.0 ? 1.0E9 : 1.0 / (this.d * d4);
        return d5;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = AngularUnit.radian.convertClipX(dArray[n++], this.m_AngularUnit);
            double d3 = AngularUnit.radian.convertClipY(dArray[n++], this.m_AngularUnit);
            d2 = (d2 - this.c) * this.e;
            d3 = Math.tan(d3 / 2.0) * this.f;
            dArray2[n2++] = this.m_LinearUnit.convert(d2, this.m_EllipsoidUnit);
            dArray2[n2++] = this.m_LinearUnit.convert(d3, this.m_EllipsoidUnit);
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d3 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            d2 = this.c + d2 / this.e;
            d3 = Math.atan(d3 / this.f) * 2.0;
            dArray2[n2++] = this.m_AngularUnit.convert(d2, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d3, AngularUnit.radian);
        }
    }
}

