/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.MathUtil;

public class LambertAzimuthalEqualArea
extends MIProProjection {
    private DoublePoint a;
    private double b;
    private Angle c;
    private Angle d;
    private Angle e;
    private double f;
    private double g;
    private double h;
    private double i;
    private double j;
    private boolean k;
    private double l;
    private double m;
    private double n;
    private double o;
    private double p;
    private double q;
    private double r;
    private double s;
    private double t;
    private double u;
    private int v;

    public LambertAzimuthalEqualArea() {
        super("Lambert Azimuthal Equal Area");
    }

    public LambertAzimuthalEqualArea(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, DoublePoint doublePoint, double d2) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = new DoublePoint(doublePoint);
        this.b = d2;
        this.c = new Angle(doublePoint.x, angularUnit);
        this.d = new Angle(doublePoint.y, angularUnit);
        this.e = new Angle(this.b, angularUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        DoublePoint doublePoint;
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = doublePoint = new DoublePoint(measuredQuantityArray[0].getScalarValue(angularUnit), measuredQuantityArray[1].getScalarValue(angularUnit));
        this.b = measuredQuantityArray[2].getScalarValue(angularUnit);
        this.c = new Angle(doublePoint.x, angularUnit);
        this.d = new Angle(doublePoint.y, angularUnit);
        this.e = new Angle(this.b, angularUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Longitude_of_Center\"," + this.a.x + "]," + "PARAMETER[\"Latitude_of_Center\"," + this.a.y + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof LambertAzimuthalEqualArea) {
            LambertAzimuthalEqualArea lambertAzimuthalEqualArea = (LambertAzimuthalEqualArea)projection;
            return super.equals(lambertAzimuthalEqualArea) && this.a.equals(lambertAzimuthalEqualArea.a) && this.b == lambertAzimuthalEqualArea.b;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof LambertAzimuthalEqualArea) {
            LambertAzimuthalEqualArea lambertAzimuthalEqualArea = (LambertAzimuthalEqualArea)projection;
            boolean bl = super.equivalent(lambertAzimuthalEqualArea) && this.c.equivalent(lambertAzimuthalEqualArea.c) && this.d.equivalent(lambertAzimuthalEqualArea.d) && this.e.equivalent(lambertAzimuthalEqualArea.e);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 4;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a.x, this.m_AngularUnit), angularUnit.convert(this.a.y, this.m_AngularUnit), angularUnit.convert(this.b, this.m_AngularUnit)};
    }

    private void a() {
        this.g = AngularUnit.radian.convertClipX(this.a.x, this.m_AngularUnit);
        this.h = AngularUnit.degree.convertClipY(this.a.y, this.m_AngularUnit);
        this.v = this.h == 90.0 ? 1 : (this.h == -90.0 ? -1 : 0);
        this.h = AngularUnit.radian.convert(this.h, AngularUnit.degree);
        this.i = Math.sin(this.h);
        this.j = Math.cos(this.h);
        this.f = this.m_Ellipsoid.a() * 2.0;
        this.k = this.m_Ellipsoid.e2() == 0.0;
        double d2 = LambertAzimuthalEqualArea.b(this.h, this.m_Ellipsoid);
        double d3 = LambertAzimuthalEqualArea.a(this.h, this.m_Ellipsoid);
        this.l = LambertAzimuthalEqualArea.a(1.5707963267948966, this.m_Ellipsoid);
        this.m = Math.asin(MathUtil.clip((double)(d3 / this.l), (double)-1.0, (double)1.0));
        this.n = this.m_Ellipsoid.getSemiMajorAxis() * Math.sqrt(this.l / 2.0);
        this.o = this.k ? 1.0 : this.m_Ellipsoid.getSemiMajorAxis() * d2 / (this.n * Math.cos(this.m));
        double d4 = AngularUnit.radian.convertClip(this.e.getScalarValue(), this.e.getAngularUnit(), 1.0, 180.0);
        this.s = this.f * Math.sin(d4 / 2.0);
        this.t = MathUtil.clip((double)(this.h - d4), (double)-1.5707963267948966, (double)1.5707963267948966);
        this.u = MathUtil.clip((double)(this.h + d4), (double)-1.5707963267948966, (double)1.5707963267948966);
        double d5 = this.m_Ellipsoid.e2() * this.m_Ellipsoid.e2();
        double d6 = this.m_Ellipsoid.e2() * d5;
        double d7 = this.m_Ellipsoid.e2() / 3.0 + 31.0 * d5 / 180.0 + 517.0 * d6 / 5040.0;
        double d8 = 23.0 * d5 / 360.0 + 251.0 * d6 / 3780.0;
        double d9 = 761.0 * d6 / 45360.0;
        this.p = d7 - d9;
        this.q = 2.0 * d8;
        this.r = 4.0 * d9;
    }

    public double getScaleFactor(double d2, double d3) {
        return 4.0 * Math.sin(0.7853981633974483) / Math.PI;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3 = AngularUnit.radian.convertClipX(dArray[n++], this.m_AngularUnit);
            double d4 = AngularUnit.radian.convertClipY(dArray[n++], this.m_AngularUnit);
            double d5 = d3 - this.g;
            double d6 = LambertAzimuthalEqualArea.a(d4, this.m_Ellipsoid);
            if (1 == this.v) {
                d2 = this.l - d6;
                if (d2 < 0.0) {
                    d2 = 0.0;
                }
                d2 = this.m_Ellipsoid.getSemiMajorAxis() * Math.sqrt(d2);
                d3 = d2 * Math.sin(d5);
                d4 = -d2 * Math.cos(d5);
            } else if (-1 == this.v) {
                d2 = d6 + this.l;
                if (d2 < 0.0) {
                    d2 = 0.0;
                }
                d2 = this.m_Ellipsoid.getSemiMajorAxis() * Math.sqrt(d2);
                d3 = d2 * Math.sin(d5);
                d4 = d2 * Math.cos(d5);
            } else {
                double d7 = Math.asin(MathUtil.clip((double)(d6 / this.l), (double)-1.0, (double)1.0));
                double d8 = Math.sin(d7);
                double d9 = Math.cos(d7);
                double d10 = Math.cos(d5);
                double d11 = this.n * Math.sqrt(2.0 / (1.0 + Math.sin(this.m) * d8 + Math.cos(this.m) * d9 * d10));
                d3 = d11 * this.o * d9 * Math.sin(d5);
                d4 = d11 / this.o * (Math.cos(this.m) * d8 - Math.sin(this.m) * d9 * d10);
            }
            d2 = Math.sqrt(d3 * d3 + d4 * d4);
            if (d2 > this.s) {
                d2 = this.s / d2;
                d3 *= d2;
                d4 *= d2;
            }
            dArray2[n2++] = this.m_LinearUnit.convert(d3, this.m_EllipsoidUnit);
            dArray2[n2++] = this.m_LinearUnit.convert(d4, this.m_EllipsoidUnit);
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3;
            double d4 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d5 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            if (this.k) {
                d3 = Math.sqrt(d4 * d4 + d5 * d5);
                if (0.0 != d3) {
                    d2 = d3 / this.f;
                    double d6 = 2.0 * Math.asin(MathUtil.clip((double)d2, (double)-1.0, (double)1.0));
                    double d7 = Math.cos(d6);
                    if (0 != this.v) {
                        d4 = this.g + Math.atan2(d4, (double)(-this.v) * d5);
                        d5 = Math.asin(MathUtil.clip((double)(d7 * this.i), (double)-1.0, (double)1.0));
                    } else {
                        double d8 = Math.sin(d6);
                        d4 = this.g + Math.atan2(d4 * d8, d3 * this.j * d7 - d5 * this.i * d8);
                        d5 = Math.asin(MathUtil.clip((double)(d7 * this.i + d5 * d8 * this.j / d3), (double)-1.0, (double)1.0));
                    }
                    d5 = MathUtil.clip((double)d5, (double)this.t, (double)this.u);
                } else {
                    d4 = this.g;
                    d5 = this.h;
                }
            } else {
                double d9;
                d3 = Math.sqrt(d4 / this.o * (d4 / this.o) + this.o * d5 * (this.o * d5));
                double d10 = 2.0 * Math.asin(MathUtil.clip((double)(d3 / (2.0 * this.n)), (double)-1.0, (double)1.0));
                if (0.0 != d3) {
                    if (1 == this.v) {
                        d3 = Math.sqrt(d4 * d4 + d5 * d5);
                        d2 = 1.0 - (1.0 - this.m_Ellipsoid.e2()) / (2.0 * this.m_Ellipsoid.getEccentricity()) * Math.log((1.0 - this.m_Ellipsoid.getEccentricity()) / (1.0 + this.m_Ellipsoid.getEccentricity()));
                        d2 = 1.0 - d3 * d3 / (this.m_Ellipsoid.getSemiMajorAxis() * this.m_Ellipsoid.getSemiMajorAxis() * d2);
                        d9 = Math.asin(MathUtil.clip((double)d2, (double)-1.0, (double)1.0));
                        d4 = this.g + Math.atan2(d4, -d5);
                    } else if (-1 == this.v) {
                        d3 = Math.sqrt(d4 * d4 + d5 * d5);
                        d2 = 1.0 - (1.0 - this.m_Ellipsoid.e2()) / (2.0 * this.m_Ellipsoid.getEccentricity()) * Math.log((1.0 - this.m_Ellipsoid.getEccentricity()) / (1.0 + this.m_Ellipsoid.getEccentricity()));
                        d2 = 1.0 - d3 * d3 / (this.m_Ellipsoid.getSemiMajorAxis() * this.m_Ellipsoid.getSemiMajorAxis() * d2);
                        d9 = -Math.asin(MathUtil.clip((double)d2, (double)-1.0, (double)1.0));
                        d4 = this.g + Math.atan2(d4, d5);
                    } else {
                        d2 = Math.cos(d10) * Math.sin(this.m) + this.o * d5 * Math.sin(d10) * Math.cos(this.m) / d3;
                        d9 = Math.asin(MathUtil.clip((double)d2, (double)-1.0, (double)1.0));
                        d2 = this.o * d3 * Math.cos(this.m) * Math.cos(d10) - this.o * this.o * d5 * Math.sin(this.m) * Math.sin(d10);
                        d4 = this.g + Math.atan2(d4 * Math.sin(d10), d2);
                    }
                } else {
                    d4 = this.g;
                    d9 = this.m;
                }
                double d11 = 2.0 * d9;
                double d12 = Math.cos(d11);
                d5 = d9 + Math.sin(d11) * (this.p + d12 * (this.q + d12 * this.r));
                d5 = MathUtil.clip((double)d5, (double)this.t, (double)this.u);
            }
            if (d4 > Math.PI) {
                d4 -= Math.PI * 2;
            }
            if (d4 < -Math.PI) {
                d4 += Math.PI * 2;
            }
            dArray2[n2++] = this.m_AngularUnit.convert(d4, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d5, AngularUnit.radian);
        }
    }

    private static double a(double d2, Ellipsoid ellipsoid) {
        double d3 = Math.sin(d2);
        double d4 = d3 * d3;
        double d5 = ellipsoid.getEccentricity();
        if (0.0 == ellipsoid.e2()) {
            return 2.0 * d3;
        }
        return (1.0 - ellipsoid.e2()) * (d3 / (1.0 - ellipsoid.e2() * d4) - 1.0 / (2.0 * d5) * Math.log((1.0 - d5 * d3) / (1.0 + d5 * d3)));
    }

    private static double b(double d2, Ellipsoid ellipsoid) {
        double d3 = Math.sin(d2) * Math.sin(d2);
        return Math.cos(d2) / Math.sqrt(1.0 - ellipsoid.e2() * d3);
    }
}

