/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;

public class Miller
extends MIProProjection {
    double a;
    private Angle b;
    double c;
    double d;
    double e;

    public Miller() {
        super("Miller");
    }

    public Miller(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, double d2) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = d2;
        this.b = new Angle(this.a, angularUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = measuredQuantityArray[0].getScalarValue(angularUnit);
        this.b = new Angle(this.a, angularUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Central_Meridian\"," + this.a + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof Miller) {
            Miller miller = (Miller)projection;
            return super.equals(miller) && this.a == miller.a;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof Miller) {
            Miller miller = (Miller)projection;
            boolean bl = super.equivalent(miller) && this.b.equivalent(miller.b);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 11;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a, this.m_AngularUnit)};
    }

    private void a() {
        this.c = this.m_Ellipsoid.a();
        this.e = this.c / 0.8;
        this.d = AngularUnit.radian.convertClipX(this.a, this.m_AngularUnit);
    }

    public double getScaleFactor(double d2, double d3) {
        double d4 = Math.cos(AngularUnit.radian.convertClipY(d3, this.m_AngularUnit));
        double d5 = d4 != 0.0 ? 1.0 / d4 : 1.0E9;
        return d5;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = AngularUnit.radian.convert(dArray[n++], this.m_AngularUnit);
            double d3 = AngularUnit.radian.convert(dArray[n++], this.m_AngularUnit);
            d2 = this.c * (d2 - this.d);
            d3 = this.e * Math.log(Math.tan(0.7853981633974483 + 0.4 * d3));
            dArray2[n2++] = this.m_LinearUnit.convert(d2, this.m_EllipsoidUnit);
            dArray2[n2++] = this.m_LinearUnit.convert(d3, this.m_EllipsoidUnit);
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d3 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            d2 = this.d + d2 / this.c;
            double d4 = d3 / this.e;
            d3 = d4 < -100.0 ? -1.5707963267948966 : (d4 > 100.0 ? 1.5707963267948966 : 2.5 * Math.atan(Math.exp(d4)) - 1.9634954084936207);
            dArray2[n2++] = this.m_AngularUnit.convert(d2, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d3, AngularUnit.radian);
        }
    }
}

