/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.Distance;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.MathUtil;

public class Stereographic
extends MIProProjection {
    private DoublePoint a;
    private double b;
    private double c;
    private double d;
    private Angle e;
    private Angle f;
    private Distance g;
    private Distance h;
    private double i;
    private double j;
    private double k;
    private double l;
    private double m;
    private double n;
    private double o;
    private double p;
    private double q;
    private double r;
    private double s;
    private boolean t;
    private boolean u;

    public Stereographic() {
        super("Stereographic");
    }

    public Stereographic(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, DoublePoint doublePoint, double d2, double d3, double d4) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = new DoublePoint(doublePoint);
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.e = new Angle(doublePoint.x, angularUnit);
        this.f = new Angle(doublePoint.y, angularUnit);
        this.g = new Distance(d3, linearUnit);
        this.h = new Distance(d4, linearUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        DoublePoint doublePoint;
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = doublePoint = new DoublePoint(measuredQuantityArray[0].getScalarValue(angularUnit), measuredQuantityArray[1].getScalarValue(angularUnit));
        this.b = measuredQuantityArray[2].getScalarValue();
        this.c = measuredQuantityArray[3].getScalarValue(linearUnit);
        this.d = measuredQuantityArray[4].getScalarValue(linearUnit);
        this.e = new Angle(doublePoint.x, angularUnit);
        this.f = new Angle(doublePoint.y, angularUnit);
        this.g = new Distance(this.c, linearUnit);
        this.h = new Distance(this.d, linearUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Longitude_of_Center\"," + this.a.x + "]," + "PARAMETER[\"Latitude_of_Center\"," + this.a.y + "]," + "PARAMETER[\"Scale_Factor\"," + this.b + "]," + "PARAMETER[\"False_Easting\"," + this.c + "]," + "PARAMETER[\"False_Northing\"," + this.d + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof Stereographic) {
            Stereographic stereographic = (Stereographic)projection;
            return super.equals(stereographic) && this.a.equals(stereographic.a) && this.b == stereographic.b && this.c == stereographic.c && this.d == stereographic.d;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof Stereographic) {
            Stereographic stereographic = (Stereographic)projection;
            boolean bl = super.equivalent(stereographic) && this.e.equivalent(stereographic.e) && this.f.equivalent(stereographic.f) && this.b == stereographic.b && this.g.equivalent(stereographic.g) && this.h.equivalent(stereographic.h);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 20;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a.x, this.m_AngularUnit), angularUnit.convert(this.a.y, this.m_AngularUnit), this.b, linearUnit.convert(this.c, this.m_LinearUnit), linearUnit.convert(this.d, this.m_LinearUnit)};
    }

    private void a() {
        this.j = AngularUnit.radian.convertClipX(this.a.x, this.m_AngularUnit);
        this.i = this.m_Ellipsoid.e();
        double d2 = AngularUnit.radian.convertClipY(this.a.y, this.m_AngularUnit);
        double d3 = Math.cos(d2);
        this.u = false;
        this.t = false;
        if (d3 == 0.0 || Math.abs(this.a.y) == 90.0) {
            d3 = 0.0;
            this.t = true;
            if (this.a.y < 0.0) {
                this.u = true;
                this.j = -this.j;
                d2 = -d2;
            }
        }
        double d4 = this.i * Math.sin(d2);
        double d5 = this.b;
        if (d5 == 0.0) {
            d5 = 1.0;
        }
        double d6 = d3 / Math.sqrt(1.0 - d4 * d4);
        this.k = 2.0 * this.m_Ellipsoid.a() * d5 * d6;
        double d7 = Math.tan(0.7853981633974483 + d2 / 2.0) * Math.pow((1.0 - d4) / (1.0 + d4), this.i / 2.0);
        this.l = 2.0 * Math.atan(d7) - 1.5707963267948966;
        this.m = Math.sin(this.l);
        this.n = Math.cos(this.l);
        d7 = Math.sqrt(Math.pow(1.0 + this.i, 1.0 + this.i) * Math.pow(1.0 - this.i, 1.0 - this.i));
        this.o = 2.0 * this.m_Ellipsoid.a() * d5 / d7;
        double d8 = this.m_Ellipsoid.e2() * this.m_Ellipsoid.e2();
        double d9 = this.m_Ellipsoid.e2() * d8;
        double d10 = d8 * d8;
        double d11 = this.m_Ellipsoid.e2() / 2.0 + 5.0 * d8 / 24.0 + d9 / 12.0 + 13.0 * d10 / 360.0;
        double d12 = 7.0 * d8 / 48.0 + 29.0 * d9 / 240.0 + 811.0 * d10 / 11520.0;
        double d13 = 7.0 * d9 / 120.0 + 81.0 * d10 / 1120.0;
        double d14 = 4279.0 * d10 / 161280.0;
        this.p = d11 - d13;
        this.q = 2.0 * d12 - 4.0 * d14;
        this.r = 4.0 * d13;
        this.s = 8.0 * d14;
    }

    public double getScaleFactor(double d2, double d3) {
        double d4;
        double d5 = AngularUnit.radian.convertClip(d3, this.m_AngularUnit, -89.9999, 89.9999);
        if (this.u) {
            d5 = -d5;
        }
        double d6 = Math.sin(d5);
        double d7 = this.i * d6;
        double d8 = Math.cos(d5) / Math.sqrt(1.0 - d7 * d7);
        if (this.t) {
            double d9 = Math.pow((1.0 - d7) / (1.0 + d7), this.i / 2.0);
            double d10 = Math.tan(0.7853981633974483 - d5 / 2.0) / d9;
            double d11 = this.o * d10;
            d4 = d11 / (this.m_Ellipsoid.a() * d8);
        } else {
            double d12;
            double d13;
            double d14 = Math.tan(0.7853981633974483 + d5 / 2.0) * Math.pow((1.0 - d7) / (1.0 + d7), this.i / 2.0);
            double d15 = 2.0 * Math.atan(d14) - 1.5707963267948966;
            double d16 = Math.sin(d15);
            double d17 = (d14 = this.n * (1.0 + this.m * d16 + this.n * (d13 = Math.cos(d15)) * Math.cos((d12 = AngularUnit.radian.convertClipX(d2, this.m_AngularUnit)) - this.j))) != 0.0 ? this.k / d14 : 1.0E9;
            d4 = d17 * d13 / (this.m_Ellipsoid.a() * d8);
        }
        return d4;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3 = AngularUnit.radian.convertClipX(dArray[n++], this.m_AngularUnit);
            double d4 = AngularUnit.radian.convertClipY(dArray[n++], this.m_AngularUnit);
            double d5 = d3;
            double d6 = d4;
            if (this.u) {
                d5 = -d5;
                d6 = -d6;
            }
            double d7 = Math.sin(d6);
            double d8 = this.i * d7;
            double d9 = d5 - this.j;
            double d10 = Math.sin(d9);
            double d11 = Math.cos(d9);
            if (this.t) {
                d2 = Math.pow((1.0 - d8) / (1.0 + d8), this.i / 2.0);
                double d12 = Math.tan(0.7853981633974483 - d6 / 2.0) / d2;
                double d13 = this.o * d12;
                d3 = d13 * d10;
                d4 = -d13 * d11;
                if (this.u) {
                    d3 = -d3;
                    d4 = -d4;
                }
            } else {
                double d14;
                d2 = Math.tan(0.7853981633974483 + d6 / 2.0) * Math.pow((1.0 - d8) / (1.0 + d8), this.i / 2.0);
                double d15 = 2.0 * Math.atan(d2) - 1.5707963267948966;
                double d16 = Math.sin(d15);
                double d17 = (d2 = this.n * (1.0 + this.m * d16 + this.n * (d14 = Math.cos(d15)) * d11)) != 0.0 ? this.k / d2 : 1.0E9;
                d3 = d17 * d14 * d10;
                d4 = d17 * (this.n * d16 - this.m * d14 * d11);
            }
            dArray2[n2++] = this.m_LinearUnit.convert(d3, this.m_EllipsoidUnit) + this.c;
            dArray2[n2++] = this.m_LinearUnit.convert(d4, this.m_EllipsoidUnit) + this.d;
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3;
            double d4 = this.m_EllipsoidUnit.convert(dArray[n++] - this.c, this.m_LinearUnit);
            double d5 = this.m_EllipsoidUnit.convert(dArray[n++] - this.d, this.m_LinearUnit);
            if (this.u) {
                d4 = -d4;
                d5 = -d5;
            }
            if ((d3 = Math.sqrt(d4 * d4 + d5 * d5)) == 0.0) {
                d2 = this.l;
                d4 = this.j;
            } else if (this.t) {
                double d6 = d3 / this.o;
                d2 = 1.5707963267948966 - 2.0 * Math.atan(d6);
                d4 = this.j + Math.atan2(d4, -d5);
            } else {
                double d7 = 2.0 * Math.atan2(d3 * this.n, this.k);
                double d8 = Math.sin(d7);
                double d9 = Math.cos(d7);
                double d10 = d9 * this.m + d5 * d8 * this.n / d3;
                d2 = Math.asin(MathUtil.clip((double)d10, (double)-1.0, (double)1.0));
                d10 = d4 * d8;
                double d11 = d3 * this.n * d9 - d5 * this.m * d8;
                d4 = d10 == 0.0 && d11 == 0.0 ? this.j : this.j + Math.atan2(d10, d11);
            }
            double d12 = 2.0 * d2;
            double d13 = Math.cos(d12);
            d5 = d2 + Math.sin(d12) * (this.p + d13 * (this.q + d13 * (this.r + d13 * this.s)));
            if (this.u) {
                d4 = -d4;
                d5 = -d5;
            }
            dArray2[n2++] = this.m_AngularUnit.convert(d4, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d5, AngularUnit.radian);
        }
    }
}

