/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.Distance;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.MathUtil;

public class SwissObliqueMercator
extends MIProProjection {
    private DoublePoint a;
    private double b;
    private double c;
    private Angle d;
    private Angle e;
    private Distance f;
    private Distance g;
    private double h;
    private double i;
    private double j;
    private double k;
    private double l;
    private double m;
    private double n;
    private double o;
    private double p;
    private double q;
    private double r;
    private double s;
    private double t;

    public SwissObliqueMercator() {
        super("SwissObliqueMercator");
    }

    public SwissObliqueMercator(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, DoublePoint doublePoint, double d2, double d3) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = new DoublePoint(doublePoint);
        this.b = d2;
        this.c = d3;
        this.d = new Angle(doublePoint.x, angularUnit);
        this.e = new Angle(doublePoint.y, angularUnit);
        this.f = new Distance(this.b, linearUnit);
        this.g = new Distance(this.c, linearUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        DoublePoint doublePoint;
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = doublePoint = new DoublePoint(measuredQuantityArray[0].getScalarValue(angularUnit), measuredQuantityArray[1].getScalarValue(angularUnit));
        this.b = measuredQuantityArray[2].getScalarValue(linearUnit);
        this.c = measuredQuantityArray[3].getScalarValue(linearUnit);
        this.d = new Angle(doublePoint.x, angularUnit);
        this.e = new Angle(doublePoint.y, angularUnit);
        this.f = new Distance(this.b, linearUnit);
        this.g = new Distance(this.c, linearUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Longitude_of_Center\"," + this.a.x + "]," + "PARAMETER[\"Latitude_of_Center\"," + this.a.y + "]," + "PARAMETER[\"False_Easting\"," + this.b + "]," + "PARAMETER[\"False_Northing\"," + this.c + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof SwissObliqueMercator) {
            SwissObliqueMercator swissObliqueMercator = (SwissObliqueMercator)projection;
            return super.equals(swissObliqueMercator) && this.a.equals(swissObliqueMercator.a) && this.b == swissObliqueMercator.b && this.c == swissObliqueMercator.c;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof SwissObliqueMercator) {
            SwissObliqueMercator swissObliqueMercator = (SwissObliqueMercator)projection;
            boolean bl = super.equivalent(swissObliqueMercator) && this.d.equivalent(swissObliqueMercator.d) && this.e.equivalent(swissObliqueMercator.e) && this.f.equivalent(swissObliqueMercator.f) && this.g.equivalent(swissObliqueMercator.g);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 25;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a.x, this.m_AngularUnit), angularUnit.convert(this.a.y, this.m_AngularUnit), linearUnit.convert(this.b, this.m_LinearUnit), linearUnit.convert(this.c, this.m_LinearUnit)};
    }

    private void a() {
        this.j = AngularUnit.radian.convertClipX(this.a.x, this.m_AngularUnit);
        this.k = AngularUnit.radian.convertClipY(this.a.y, this.m_AngularUnit);
        this.h = this.m_Ellipsoid.e();
        this.i = this.h / 2.0;
        double d2 = Math.cos(this.k);
        double d3 = Math.sin(this.k);
        double d4 = this.h * d3;
        this.q = this.m_Ellipsoid.a() * Math.sqrt(1.0 - this.m_Ellipsoid.e2()) / (1.0 - d4 * d4);
        this.r = this.q / 2.0;
        this.s = 1.0 / this.q;
        this.l = Math.sqrt(1.0 + this.m_Ellipsoid.e2() / (1.0 - this.m_Ellipsoid.e2()) * Math.pow(d2, 4.0));
        this.m = this.l / 2.0;
        this.n = 1.0 / this.l;
        this.o = d3 / this.l;
        this.o = MathUtil.clip((double)this.o, (double)-1.0, (double)1.0);
        this.p = Math.cos(Math.asin(this.o));
        this.t = d3 == 1.0 || d3 == -1.0 || this.o == 1.0 || this.o == -1.0 ? 0.0 : (Math.log((1.0 + this.o) / (1.0 - this.o)) - this.l * Math.log((1.0 + d3) / (1.0 - d3)) + this.l * this.h * Math.log((1.0 + d4) / (1.0 - d4))) / 2.0;
    }

    public double getScaleFactor(double d2, double d3) {
        double d4;
        double d5 = AngularUnit.radian.convertClipX(d2, this.m_AngularUnit);
        double d6 = AngularUnit.radian.convertClipY(d3, this.m_AngularUnit);
        double d7 = Math.sin(d6);
        double d8 = this.h * d7;
        if (d7 == 1.0 || d7 == -1.0) {
            d4 = d6;
        } else {
            double d9 = this.m * (Math.log((1.0 + d7) / (1.0 - d7)) - this.h * Math.log((1.0 + d8) / (1.0 - d8))) + this.t;
            d4 = 2.0 * (Math.atan(Math.exp(d9)) - 0.7853981633974483);
        }
        double d10 = this.l * (d5 - this.j);
        double d11 = this.p * Math.sin(d4) - this.o * Math.cos(d4) * Math.cos(d10);
        d11 = MathUtil.clip((double)d11, (double)-1.0, (double)1.0);
        double d12 = Math.cos(Math.asin(d11));
        double d13 = d12 == 0.0 ? 1.0E9 : 1.0 / d12;
        return d13;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3;
            double d4 = AngularUnit.radian.convertClipX(dArray[n++], this.m_AngularUnit);
            double d5 = AngularUnit.radian.convertClipY(dArray[n++], this.m_AngularUnit);
            double d6 = Math.sin(d5);
            double d7 = this.h * d6;
            if (d6 == 1.0 || d6 == -1.0) {
                d3 = d5;
            } else {
                d2 = this.m * (Math.log((1.0 + d6) / (1.0 - d6)) - this.h * Math.log((1.0 + d7) / (1.0 - d7))) + this.t;
                d3 = 2.0 * (Math.atan(Math.exp(d2)) - 0.7853981633974483);
            }
            double d8 = this.l * (d4 - this.j);
            double d9 = Math.sin(d3);
            double d10 = Math.cos(d3);
            double d11 = Math.sin(d8);
            double d12 = Math.cos(d8);
            double d13 = this.p * d9 - this.o * d10 * d12;
            d13 = MathUtil.clip((double)d13, (double)-1.0, (double)1.0);
            double d14 = Math.cos(Math.asin(d13));
            d2 = d10 * d11;
            double d15 = this.o * d9 + this.p * d10 * d12;
            double d16 = d2 == 0.0 && d15 == 0.0 ? 0.0 : Math.atan2(d2, d15);
            double d17 = d13 == 1.0 ? 1.0E9 : (d13 == -1.0 ? -1.0E9 : this.r * Math.log((1.0 + d13) / (1.0 - d13)));
            double d18 = this.q * d16;
            dArray2[n2++] = this.m_LinearUnit.convert(d18, this.m_EllipsoidUnit) + this.b;
            dArray2[n2++] = this.m_LinearUnit.convert(d17, this.m_EllipsoidUnit) + this.c;
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3 = this.m_EllipsoidUnit.convert(dArray[n++] - this.b, this.m_LinearUnit);
            double d4 = this.m_EllipsoidUnit.convert(dArray[n++] - this.c, this.m_LinearUnit);
            double d5 = d3 * this.s;
            double d6 = 2.0 * (Math.atan(Math.exp(d4 * this.s)) - 0.7853981633974483);
            double d7 = Math.sin(d5);
            double d8 = Math.cos(d5);
            double d9 = Math.sin(d6);
            double d10 = Math.cos(d6);
            double d11 = this.p * d9 + this.o * d10 * d8;
            d11 = MathUtil.clip((double)d11, (double)-1.0, (double)1.0);
            double d12 = Math.asin(d11);
            double d13 = Math.cos(d12);
            double d14 = d10 * d7;
            double d15 = -this.o * d9 + this.p * d10 * d8;
            double d16 = d14 == 0.0 && d15 == 0.0 ? 0.0 : Math.atan2(d14, d15);
            if (d11 == 1.0 || d11 == -1.0) {
                d2 = d12;
            } else {
                d14 = (0.5 * Math.log((1.0 + d11) / (1.0 - d11)) - this.t) * this.n;
                d2 = this.k;
                boolean bl = true;
                while (bl) {
                    double d17 = d2;
                    double d18 = this.h * Math.sin(d2);
                    d15 = d14 + this.i * Math.log((1.0 + d18) / (1.0 - d18));
                    boolean bl2 = bl = Math.abs((d2 = 2.0 * (Math.atan(Math.exp(d15)) - 0.7853981633974483)) - d17) > 1.0E-9;
                }
            }
            double d19 = this.j + d16 * this.n;
            dArray2[n2++] = this.m_AngularUnit.convert(d19, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d2, AngularUnit.radian);
        }
    }
}

