/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.unit;

import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.Unit;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.DoubleRect;
import com.mapinfo.util.MathUtil;
import java.util.Hashtable;

public class AngularUnit
extends Unit {
    double a;
    double b;
    double c;
    double d;
    double e;
    double f;
    public static final short INDEX_DEGREE = 13;
    public static final AngularUnit radian;
    public static final AngularUnit degree;
    public static final AngularUnit minute;
    public static final AngularUnit second;
    public static final AngularUnit grad;
    public static final AngularUnit gon;
    private static Hashtable g;

    private void a(double d2) {
        this.a = d2;
        this.b = 1.0 / this.a;
        this.c = Math.PI * -2 * this.b;
        this.d = Math.PI * 2 * this.b;
        this.e = -1.5707963267948966 * this.b;
        this.f = 1.5707963267948966 * this.b;
    }

    public AngularUnit(String string, double d2) {
        super(string);
        this.a(d2);
    }

    public AngularUnit(String string, String string2, double d2) {
        this.a(string, string2, d2, "", "");
    }

    private AngularUnit(String string, String string2, double d2, String string3, String string4) {
        this.a(string, string2, d2, string3, string4);
    }

    public AngularUnit(String string, String string2) {
        AngularUnit angularUnit = null;
        String string3 = string2.toLowerCase() + ":" + string.toLowerCase();
        angularUnit = (AngularUnit)g.get(string3);
        if (angularUnit != null) {
            this.a(((Unit)angularUnit).c, ((Unit)angularUnit).d, angularUnit.a, ((Unit)angularUnit).f, ((Unit)angularUnit).e);
            return;
        }
        throw new IllegalArgumentException("code/codeSpace not found: " + string + "/" + string2);
    }

    void a(String string, String string2, double d2, String string3, String string4) {
        this.b(string);
        this.a(d2);
        this.c(string2);
        this.a(string3, string4);
    }

    protected AngularUnit() {
        this(((Unit)AngularUnit.degree).c, AngularUnit.degree.a);
    }

    public double getRadiansPerUnit() {
        return this.a;
    }

    public String getWellKnownText() {
        return "UNIT[\"" + ((Unit)this).c + "\"," + this.a + "]";
    }

    public double convert(double d2, Unit unit) {
        if (unit instanceof LinearUnit) {
            return this.convert(d2, (LinearUnit)unit);
        }
        if (unit instanceof AngularUnit) {
            return this.convert(d2, (AngularUnit)unit);
        }
        throw new UnsupportedOperationException("Conversion not allowed: LinearUnit to " + unit.getName());
    }

    public double convert(double d2, AngularUnit angularUnit) {
        if (angularUnit.a == this.a) {
            return d2;
        }
        return d2 * angularUnit.a * this.b;
    }

    public double convert(double d2, LinearUnit linearUnit) {
        d2 = LinearUnit.meter.convert(d2, linearUnit);
        return this.convert(d2 / 6370997.0, radian);
    }

    public void convert(DoublePoint doublePoint, AngularUnit angularUnit) {
        this.convert(doublePoint, doublePoint, angularUnit);
    }

    public void convert(DoublePoint doublePoint, DoublePoint doublePoint2, AngularUnit angularUnit) {
        doublePoint2.x = this.convert(doublePoint.x, angularUnit);
        doublePoint2.y = this.convert(doublePoint.y, angularUnit);
    }

    public void convert(DoubleRect doubleRect, AngularUnit angularUnit) {
        this.convert(doubleRect, doubleRect, angularUnit);
    }

    public void convert(DoubleRect doubleRect, DoubleRect doubleRect2, AngularUnit angularUnit) {
        doubleRect2.xmin = this.convert(doubleRect.xmin, angularUnit);
        doubleRect2.ymin = this.convert(doubleRect.ymin, angularUnit);
        doubleRect2.xmax = this.convert(doubleRect.xmax, angularUnit);
        doubleRect2.ymax = this.convert(doubleRect.ymax, angularUnit);
    }

    public void convert(double[] dArray, int n, int n2, AngularUnit angularUnit) {
        this.convert(dArray, n, dArray, n, n2, angularUnit);
    }

    public void convert(double[] dArray, int n, double[] dArray2, int n2, int n3, AngularUnit angularUnit) {
        while (n3-- > 0) {
            dArray2[n2++] = this.convert(dArray[n++], angularUnit);
            dArray2[n2++] = this.convert(dArray[n++], angularUnit);
        }
    }

    public double convertClip(double d2, AngularUnit angularUnit, double d3, double d4) {
        return this.clip(this.convert(d2, angularUnit), d3, d4);
    }

    public double convertClipX(double d2, AngularUnit angularUnit) {
        return this.clipX(this.convert(d2, angularUnit));
    }

    public double convertClipY(double d2, AngularUnit angularUnit) {
        return this.clipY(this.convert(d2, angularUnit));
    }

    public double clip(double d2, double d3, double d4) {
        double d5 = this.convert(d3, degree);
        double d6 = this.convert(d4, degree);
        return MathUtil.clip((double)d2, (double)d5, (double)d6);
    }

    public double clipX(double d2) {
        return MathUtil.clip((double)d2, (double)this.c, (double)this.d);
    }

    public double clipY(double d2) {
        return MathUtil.clip((double)d2, (double)this.e, (double)this.f);
    }

    public boolean equals(Object object) {
        AngularUnit angularUnit = null;
        if (!(object instanceof AngularUnit)) {
            return false;
        }
        angularUnit = (AngularUnit)object;
        return this == angularUnit || this.a == angularUnit.a && ((Unit)this).d.equals(((Unit)angularUnit).d) && ((Unit)this).e.equals(((Unit)angularUnit).e) && ((Unit)this).f.equals(((Unit)angularUnit).f);
    }

    public boolean equivalent(AngularUnit angularUnit) {
        return this == angularUnit || this.a == angularUnit.a;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.a);
        int n = (int)(l ^ l >>> 32);
        return ((Unit)this).c.hashCode() + ((Unit)this).d.hashCode() + ((Unit)this).e.hashCode() + ((Unit)this).f.hashCode() + n;
    }

    static {
        INDEX_DEGREE = (short)13;
        radian = new AngularUnit("radian", "rad", 1.0, "9101", "EPSG");
        degree = new AngularUnit("degree", "deg", Math.PI / 180, "9102", "EPSG");
        minute = new AngularUnit("minute", "min", 2.908882086657216E-4, "9103", "EPSG");
        second = new AngularUnit("second", "sec", 4.84813681109536E-6, "9104", "EPSG");
        grad = new AngularUnit("grad", "gr", 0.015707963267948967, "9105", "EPSG");
        gon = new AngularUnit("gon", "g", 0.015707963267948967, "9106", "EPSG");
        g = new Hashtable(6);
        g.put(radian.getSrsName().toLowerCase(), radian);
        g.put(degree.getSrsName().toLowerCase(), degree);
        g.put(minute.getSrsName().toLowerCase(), minute);
        g.put(second.getSrsName().toLowerCase(), second);
        g.put(grad.getSrsName().toLowerCase(), grad);
        g.put(gon.getSrsName().toLowerCase(), gon);
    }
}

