/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.unit;

import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.ObjectUtils;

public class Distance
extends MeasuredQuantity {
    public Distance(double d2, LinearUnit linearUnit) {
        super(d2, linearUnit);
    }

    public Distance(Distance distance) {
        super(distance.getScalarValue(), new LinearUnit(distance.getLinearUnit().getName(), distance.getLinearUnit().getMetersPerUnit()));
    }

    public double getScalarValue(LinearUnit linearUnit) {
        return linearUnit.convert(this.a, this.b);
    }

    public LinearUnit getLinearUnit() {
        return (LinearUnit)this.b;
    }

    public String toString() {
        return "[Distance: " + this.a + " " + this.b.getName() + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Distance)) {
            return false;
        }
        Distance distance = (Distance)object;
        if (Double.doubleToLongBits(this.a) != Double.doubleToLongBits(distance.a)) {
            return false;
        }
        return this.b.equals(distance.b);
    }

    public boolean equivalent(MeasuredQuantity measuredQuantity) {
        return this.equivalent(measuredQuantity, 0.0);
    }

    public boolean equivalent(MeasuredQuantity measuredQuantity, double d2) {
        if (measuredQuantity.getUnit() instanceof LinearUnit) {
            double d3;
            double d4 = ((LinearUnit)measuredQuantity.getUnit()).getMetersPerUnit() * measuredQuantity.getScalarValue();
            return Math.abs(d4 - (d3 = ((LinearUnit)this.b).getMetersPerUnit() * this.a)) <= d2;
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = n * 37 + ObjectUtils.hashCode((double)this.a);
        n = n * 37 + ObjectUtils.hashCode((double)this.b.hashCode());
        return n;
    }
}

