/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.unit;

import com.mapinfo.unit.Unit;

public class TimeUnit
extends Unit {
    public static final TimeUnit SECOND = new TimeUnit("second", "s", 1.0);
    public static final TimeUnit MINUTE = new TimeUnit("minute", "min", 60.0);
    public static final TimeUnit HOUR = new TimeUnit("hour", "hr", 3600.0);
    private double a;

    public TimeUnit(String string, double d2) {
        super(string);
        this.a = d2;
    }

    public TimeUnit(String string, String string2, double d2) {
        this(string, d2);
        this.c(string2);
    }

    public double getSecondsPerUnit() {
        return this.a;
    }

    public double convert(double d2, Unit unit) {
        if (unit instanceof TimeUnit) {
            return this.convert(d2, (TimeUnit)unit);
        }
        throw new IllegalArgumentException("Can't convert from " + unit.getName() + " to " + this.getName());
    }

    public double convert(double d2, TimeUnit timeUnit) {
        double d3 = d2;
        if (timeUnit.a != this.a) {
            d3 = d2 * timeUnit.getSecondsPerUnit() / this.a;
        }
        return d3;
    }

    public boolean equivalent(TimeUnit timeUnit) {
        return this == timeUnit || this.a == timeUnit.a;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TimeUnit) {
            TimeUnit timeUnit = (TimeUnit)object;
            if (this.a == timeUnit.a) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        long l = Double.doubleToLongBits(this.getSecondsPerUnit());
        int n2 = (int)(l ^ l >>> 32);
        n = 37 * n + n2;
        return n;
    }
}

