/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.unit;

import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.unit.VelocityUnit;

public class Velocity
extends MeasuredQuantity {
    public Velocity(double d2, VelocityUnit velocityUnit) {
        super(d2, velocityUnit);
    }

    public VelocityUnit getVelocityUnit() {
        return (VelocityUnit)this.getUnit();
    }

    public String toString() {
        return "[Velocity: " + this.a + " " + this.getVelocityUnit().getLinearUnit().getName() + "/" + this.getVelocityUnit().getTimeUnit().getName() + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Velocity)) {
            return false;
        }
        Velocity velocity = (Velocity)object;
        if (Double.doubleToLongBits(this.a) != Double.doubleToLongBits(velocity.a)) {
            return false;
        }
        return this.b.equals(velocity.b);
    }

    public boolean equivalent(MeasuredQuantity measuredQuantity) {
        return this.equivalent(measuredQuantity, 0.0);
    }

    public boolean equivalent(MeasuredQuantity measuredQuantity, double d2) {
        if (measuredQuantity.getUnit() instanceof VelocityUnit) {
            double d3;
            VelocityUnit velocityUnit = (VelocityUnit)measuredQuantity.getUnit();
            double d4 = velocityUnit.getLinearUnit().getMetersPerUnit() / velocityUnit.getTimeUnit().getSecondsPerUnit() * measuredQuantity.getScalarValue();
            return Math.abs(d4 - (d3 = ((VelocityUnit)this.b).getLinearUnit().getMetersPerUnit() / ((VelocityUnit)this.b).getTimeUnit().getSecondsPerUnit() * this.a)) <= d2;
        }
        return false;
    }
}

