/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.xmlprot.csys;

import com.mapinfo.coordsys.AffineTransform;
import com.mapinfo.coordsys.CoordSys;
import com.mapinfo.coordsys.CoordSysFactory;
import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.HorizontalDatum;
import com.mapinfo.coordsys.PrimeMeridian;
import com.mapinfo.coordsys.ProjectedCoordinateSystem;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.coordsys.SpatialReferenceSystem;
import com.mapinfo.coordsys.proj.AlbersEqualAreaConic;
import com.mapinfo.coordsys.proj.AzimuthalEquidistant;
import com.mapinfo.coordsys.proj.CassiniSoldner;
import com.mapinfo.coordsys.proj.CylindricalEqualArea;
import com.mapinfo.coordsys.proj.DoubleStereographic;
import com.mapinfo.coordsys.proj.EckertIV;
import com.mapinfo.coordsys.proj.EckertVI;
import com.mapinfo.coordsys.proj.EquidistantConic;
import com.mapinfo.coordsys.proj.Gall;
import com.mapinfo.coordsys.proj.HotineObliqueMercator;
import com.mapinfo.coordsys.proj.LambertAzimuthalEqualArea;
import com.mapinfo.coordsys.proj.LambertConformalConic;
import com.mapinfo.coordsys.proj.Mercator;
import com.mapinfo.coordsys.proj.Miller;
import com.mapinfo.coordsys.proj.Mollweide;
import com.mapinfo.coordsys.proj.NewZealandMapGrid;
import com.mapinfo.coordsys.proj.Polyconic;
import com.mapinfo.coordsys.proj.Robinson;
import com.mapinfo.coordsys.proj.Sinusoidal;
import com.mapinfo.coordsys.proj.Stereographic;
import com.mapinfo.coordsys.proj.SwissObliqueMercator;
import com.mapinfo.coordsys.proj.TransverseMercator;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.Distance;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.unit.UnitFactory;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.xmlprot.csys.UnitXmlCreator;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public final class CoordSysXMLCreator {
    private static final String[] a;
    public static final String COORDINATEREFERENCESYSTEM = "CoordinateReferenceSystem";
    private static final String b = "ProjectedCRS";
    private static final String c = "CoordinateTransformationDefinition";
    private static final String d = "ParameterizedTransformation";
    private static final String e = "ConcatenatedTransformation";
    private static final String f = "AffineGeneralParametricTransformation";
    private static final String g = "TransformationMethod";
    private static final String h = "PositionVector7Parameter";
    private static final String i = "NameSet";
    private static final String j = "Parameter";
    private static final String k = "Geographic2dCRS";
    private static final String l = "GeodeticDatum";
    private static final String m = "Ellipsoid";
    private static final String n = "semiMajorAxis";
    private static final String o = "inverseFlattening";
    private static final String p = "LinearUnit";
    private static final String q = "metersPerUnit";
    private static final String r = "metresPerUnit";
    private static final String s = "unitsPerMeter";
    private static final String t = "Identifier";
    private static final String u = "code";
    private static final String v = "CartesianCoordinateSystem";
    private static final String w = "central_meridian";
    private static final String x = "standard_parallel_1";
    private static final String y = "standard_parallel_2";
    private static final String z = "false_easting";
    private static final String aa = "false_northing";
    private static final String ab = "latitude_of_origin";
    private static final String ac = "scale_factor";
    private static final String ad = "codeSpace";
    private static final String ae = "dimensions";
    private static final String af = "PrimeMeridian";
    private static final String ag = "semiMinorAxis";
    private static final String ah = "longitude_of_center";
    private static final String ai = "codeName";
    private static final String aj = "latitude_of_center";
    private static final String ak = "range";
    private static final String al = "greenwichLongitude";
    private static final String am = "AngularUnit";
    private static final String an = "radiansPerUnit";
    private static final String ao = "unitsPerRadian";
    private static final String ap = "sourceDimensions";
    private static final String aq = "targetDimensions";
    private static final String ar = "EllipsoidalCoordinateSystem";
    private static final String as = "azimuth";
    private static final String at = "CoordinateAxis";
    private static final String au = "value";
    private static final String av = "description";
    private static final String aw = "MapInfo";
    private static final String ax = "mapinfo";
    private static final String ay = "flatteningDefinitive";
    private static final String az = "true";
    private static final String a0 = "Unsupported Projection";
    private static final String a1 = "Unsupported Units";
    private static final String a2 = "name";
    private static final String a3 = "abbreviation";
    private static final String a4 = "alias";
    private static final String a5 = "remarks";
    private static final String a6 = "2";
    private static final String a7 = "CompoundCRS";
    private static final String a8 = "LocalCRS";
    private static final String a9 = "EPSG";
    private static final String ba = "epsg:";
    private static final String bb = "mapinfo:mapbasic:";
    private static final String bc = ":";
    private static final String bd = "PararmeterizedTransformation";
    private static final String be = "<map_basic>";
    private static final String bf = "</map_basic>";
    private static final String bg = "<quadrant>";
    private static final String bh = "</quadrant>";
    private static final String bi = "<precision>";
    private static final String bj = "</precision>";
    private static final String bk = "<affine_transform>";
    private static final String bl = "</affine_transform>";
    private static Hashtable bm;
    static /* synthetic */ Class bn;

    private CoordSysXMLCreator() {
    }

    public static final CoordSys createCoordSys(Element element) {
        String string = null;
        Object var2_2 = null;
        Element element2 = element.getChild(t);
        if (element2 != null) {
            string = "Identifier Error";
            String string2 = element2.getChildText(ad);
            if (string2 != null) {
                string = string2;
                String string3 = element2.getChildText(u);
                if (string3 != null) {
                    string = string + bc + string3;
                    if (string2.equalsIgnoreCase(aw) && string3.indexOf(",") != -1) {
                        try {
                            return CoordSys.createFromPRJ(string3);
                        }
                        catch (Exception exception) {
                        }
                    } else {
                        String string4 = CoordSysXMLCreator.getMapBasic(string2 + bc + string3);
                        if (string4 != null) {
                            try {
                                return CoordSys.createFromPRJ("\"\\p" + string2 + bc + string3 + "\"," + string4);
                            }
                            catch (Exception exception) {
                            }
                        } else {
                            return CoordSysFactory.createCoordSys(string2 + bc + string3);
                        }
                    }
                }
            }
            throw new IllegalArgumentException("Unsupported Projection:" + string);
        }
        throw new IllegalArgumentException("Identifier missing");
    }

    public static final CoordSys createCoordSys(Element element, HorizontalDatum horizontalDatum, AffineTransform affineTransform) {
        CoordSys coordSys = null;
        String[] stringArray = UnitXmlCreator.a(element.getChild(t));
        Element element2 = element.getChild(b);
        if (element2 != null) {
            coordSys = CoordSysXMLCreator.b(element, horizontalDatum, affineTransform, stringArray);
        } else {
            element2 = element.getChild(k);
            if (element2 != null) {
                coordSys = CoordSysXMLCreator.a(element2, horizontalDatum, affineTransform, stringArray);
            } else {
                element2 = element.getChild(t);
                if (element2 != null) {
                    return CoordSysXMLCreator.createCoordSys(element);
                }
                throw new UnsupportedOperationException("CoordSys definition not projected or geographic2dCRS");
            }
        }
        return coordSys;
    }

    public static final Element createXML(CoordSys coordSys) {
        return CoordSysXMLCreator.writeCoordSys(coordSys);
    }

    public static final Element writeCoordSys(CoordSys coordSys) {
        Element element = new Element(COORDINATEREFERENCESYSTEM);
        Element element2 = UnitXmlCreator.a(CoordSysXMLCreator.constructSrsName(coordSys));
        if (element2 != null) {
            element.addContent(element2);
        }
        return element;
    }

    public static final Object[] createHorizontalDatum(Element element) {
        List list;
        String string;
        Object object;
        Object[] objectArray = new Object[2];
        HorizontalDatum horizontalDatum = null;
        AffineTransform affineTransform = AffineTransform.identity;
        Element element2 = element.getChild(c);
        Element element3 = element2.getChild(t);
        if (element3 != null) {
            object = element3.getChildText(u);
            string = element3.getChildText(ad);
            try {
                horizontalDatum = new HorizontalDatum((String)object, string);
                if (horizontalDatum != null) {
                    objectArray[0] = horizontalDatum;
                    objectArray[1] = affineTransform;
                    return objectArray;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        object = element.getChildren(COORDINATEREFERENCESYSTEM).iterator();
        string = (Element)object.next();
        Ellipsoid ellipsoid = CoordSysXMLCreator.b((Element)string);
        String[] stringArray = UnitXmlCreator.a(element2.getChild(t));
        Element element4 = element2.getChild(e);
        Element element5 = null;
        Element element6 = null;
        if (element4 != null) {
            list = element4.getChildren(c);
            if (list.size() != 2) {
                throw new IllegalArgumentException("Only two elements allowed in a ConcatenatedTransformation");
            }
            Element element7 = (Element)list.get(0);
            element6 = element7.getChild(d).getChild(f);
            if (element6 != null) {
                affineTransform = CoordSysXMLCreator.createAffineTransform(element6);
                element5 = ((Element)list.get(1)).getChild(d);
            } else {
                element6 = ((Element)list.get(1)).getChild(d).getChild(f);
                affineTransform = CoordSysXMLCreator.createAffineTransform(element6);
                element5 = element7.getChild(d);
            }
        } else {
            element5 = element2.getChild(d);
        }
        list = element5.getChild(h);
        double d2 = CoordSysXMLCreator.a(list.getChild("XaxisTranslation"));
        double d3 = CoordSysXMLCreator.a(list.getChild("YaxisTranslation"));
        double d4 = CoordSysXMLCreator.a(list.getChild("ZaxisTranslation"));
        double d5 = CoordSysXMLCreator.a(list.getChild("XaxisRotation"));
        double d6 = CoordSysXMLCreator.a(list.getChild("YaxisRotation"));
        double d7 = CoordSysXMLCreator.a(list.getChild("ZaxisRotation"));
        double d8 = CoordSysXMLCreator.a(list.getChild("ScaleDifference"));
        horizontalDatum = new HorizontalDatum(ellipsoid, d2, d3, d4, d5, d6, d7, d8, stringArray[0], stringArray[1]);
        objectArray[0] = horizontalDatum;
        objectArray[1] = affineTransform;
        return objectArray;
    }

    public static final AffineTransform createAffineTransform(Element element) {
        return new AffineTransform(Double.parseDouble(element.getChildText("A0")), Double.parseDouble(element.getChildText("A1")), Double.parseDouble(element.getChildText("A2")), Double.parseDouble(element.getChildText("B0")), Double.parseDouble(element.getChildText("B1")), Double.parseDouble(element.getChildText("B2")));
    }

    public static final AffineTransform createRasterTransform(Element element) {
        return CoordSysXMLCreator.createAffineTransform(element.getChild(f));
    }

    public static final Element writeAffineTransform(AffineTransform affineTransform) {
        Element element = new Element(f);
        element.addContent(new Element(av));
        double[] dArray = new double[6];
        affineTransform.getCoefficients(dArray);
        element.addContent(new Element("A0").addContent(Double.toString(dArray[0])));
        element.addContent(new Element("A1").addContent(Double.toString(dArray[1])));
        element.addContent(new Element("A2").addContent(Double.toString(dArray[2])));
        element.addContent(new Element("B0").addContent(Double.toString(dArray[3])));
        element.addContent(new Element("B1").addContent(Double.toString(dArray[4])));
        element.addContent(new Element("B2").addContent(Double.toString(dArray[5])));
        return element;
    }

    private static final double a(Element element) {
        Element element2;
        String string = element.getChildText(au);
        double d2 = 0.0;
        if (string != null && !string.equals("")) {
            d2 = Double.parseDouble(string);
        }
        if ((element2 = element.getChild(p)) != null) {
            LinearUnit linearUnit = UnitXmlCreator.createLinearUnit(element2);
            d2 = LinearUnit.meter.convert(d2, linearUnit);
        }
        return d2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Ellipsoid b(Element element) {
        Ellipsoid ellipsoid = null;
        Element element2 = null;
        element2 = element.getChild(k);
        if (element2 != null) {
            Element element3 = element2.getChild(l);
            if (element3 != null) {
                return CoordSysXMLCreator.createEllipsoid(element3.getChild(m));
            }
            element3 = element2.getChild(COORDINATEREFERENCESYSTEM).getChild(t);
            if (element3 == null) throw new IllegalArgumentException("Can't get ellipsoid from Geographic2DCRS");
            String[] stringArray = UnitXmlCreator.a(element3);
            CoordSys coordSys = CoordSysFactory.createCoordSys(stringArray[0], stringArray[1]);
            return coordSys.getGeographicCoordinateSystem().getHorizontalDatum().getEllipsoid();
        }
        element2 = element.getChild(b);
        if (element2 != null) {
            Element element4 = element2.getChild(COORDINATEREFERENCESYSTEM).getChild(k);
            if (element4 != null) {
                return CoordSysXMLCreator.createEllipsoid(element4.getChild(l).getChild(m));
            }
            element4 = element2.getChild(COORDINATEREFERENCESYSTEM).getChild(t);
            if (element4 == null) throw new IllegalArgumentException("Can't get ellipsoid from ProjectedCRS");
            String[] stringArray = UnitXmlCreator.a(element4);
            CoordSys coordSys = CoordSysFactory.createCoordSys(stringArray[0], stringArray[1]);
            return coordSys.getGeographicCoordinateSystem().getHorizontalDatum().getEllipsoid();
        }
        element2 = element.getChild(t);
        if (element2 == null) throw new IllegalArgumentException("CRS must be defined by Geographic2dCRS or ProjectedCRS");
        String[] stringArray = UnitXmlCreator.a(element2);
        CoordSys coordSys = CoordSysFactory.createCoordSys(stringArray[0], stringArray[1]);
        return coordSys.getGeographicCoordinateSystem().getHorizontalDatum().getEllipsoid();
    }

    public static final Element writeEllipsoid(Ellipsoid ellipsoid) {
        Element element = new Element(m);
        element.setAttribute(ay, az);
        if (ellipsoid.getSrsName().equals("")) {
            element.addContent(UnitXmlCreator.writeLinearUnit(ellipsoid.getAxisUnit()));
            element.addContent(new Element(n).addContent(Double.toString(ellipsoid.getSemiMajorAxis())));
            element.addContent(new Element(ag).addContent(Double.toString(ellipsoid.getSemiMinorAxis())));
            element.addContent(new Element(o).addContent(Double.toString(ellipsoid.getInverseFlattening())));
        } else {
            element.addContent(UnitXmlCreator.a(ellipsoid.getCode(), ellipsoid.getCodeSpace()));
        }
        return element;
    }

    public static final Ellipsoid createEllipsoid(Element element) {
        String[] stringArray = CoordSysXMLCreator.getEllipsoidParams(element);
        if (stringArray[5] == null || stringArray[6] == null) {
            return new Ellipsoid("", Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[4]), UnitFactory.createLinearUnit(stringArray[0], stringArray[1]));
        }
        return CoordSysFactory.createEllipsoid(stringArray[5], stringArray[6]);
    }

    public static final String[] getEllipsoidParams(Element element) {
        String[] stringArray;
        String[] stringArray2 = new String[7];
        Element element2 = element.getChild(p);
        if (element2 != null) {
            stringArray = UnitXmlCreator.getLinearUnitParams(element2);
            System.arraycopy(stringArray, 3, stringArray2, 0, 2);
        }
        stringArray2[2] = element.getChildText(n);
        stringArray2[3] = element.getChildText(ag);
        stringArray2[4] = element.getChildText(o);
        stringArray = UnitXmlCreator.a(element.getChild(t));
        System.arraycopy(stringArray, 0, stringArray2, 5, 2);
        return stringArray2;
    }

    public static final Element writePrimeMeridian(PrimeMeridian primeMeridian) {
        if (primeMeridian.getLongitude() == 0.0) {
            return null;
        }
        Element element = new Element(af);
        if (primeMeridian.getSrsName().equals("")) {
            element.addContent(CoordSysXMLCreator.b(primeMeridian.getName()));
            element.addContent(new Element(al).addContent(Double.toString(primeMeridian.getLongitude())));
            element.addContent(UnitXmlCreator.writeAngularUnit(primeMeridian.getAngularUnit()));
        } else {
            element.addContent(UnitXmlCreator.a(primeMeridian.getCode(), primeMeridian.getCodeSpace()));
        }
        return element;
    }

    public static final PrimeMeridian createPrimeMeridian(Element element) {
        if (element == null) {
            return PrimeMeridian.greenwich;
        }
        String[] stringArray = CoordSysXMLCreator.getPrimeMeridianParams(element);
        if (stringArray[4].length() == 0 || stringArray[5].length() == 0) {
            return new PrimeMeridian(stringArray[0], Double.parseDouble(stringArray[1]), UnitFactory.createAngularUnit(stringArray[2], stringArray[3]));
        }
        return CoordSysFactory.createPrimeMeridian(stringArray[4], stringArray[5]);
    }

    public static String[] getPrimeMeridianParams(Element element) {
        Element element2;
        Element element3;
        String[] stringArray = new String[6];
        Element element4 = element.getChild(i);
        if (element4 != null) {
            element3 = CoordSysXMLCreator.createNameSet(element4);
            System.arraycopy(element3, 0, stringArray, 0, 1);
        }
        stringArray[1] = element.getChildText(al);
        element3 = element.getChild(am);
        if (element3 != null) {
            element2 = UnitXmlCreator.getAngularUnitParams(element3);
            System.arraycopy(element2, 3, stringArray, 2, 2);
        }
        if ((element2 = element.getChild(t)) != null) {
            String[] stringArray2 = UnitXmlCreator.a(element2);
            System.arraycopy(stringArray2, 0, stringArray, 4, 2);
        }
        return stringArray;
    }

    private static final CoordSys a(Element element, HorizontalDatum horizontalDatum, AffineTransform affineTransform, String[] stringArray) {
        String[] stringArray2;
        CoordSys coordSys = null;
        Element element2 = element.getChild(l);
        if (element2 == null) {
            Element element3 = element.getChild(t);
            if (element3 != null) {
                String[] stringArray3 = UnitXmlCreator.a(element3);
                return CoordSysFactory.createCoordSys(stringArray3[0], stringArray3[1]);
            }
            throw new IllegalArgumentException("Improperly formed Geographic2dCRS");
        }
        PrimeMeridian primeMeridian = CoordSysXMLCreator.createPrimeMeridian(element2.getChild(af));
        Element element4 = element.getChild(ar);
        if (!(element4 == null || (stringArray2 = UnitXmlCreator.a(element4.getChild(t)))[0].equalsIgnoreCase("6402") && stringArray2[1].equalsIgnoreCase(a9))) {
            throw new IllegalArgumentException("Unsupported EllipsoidalCoordinateSystem: " + stringArray2[1] + bc + stringArray2[0]);
        }
        try {
            if (stringArray == null) {
                stringArray = new String[2];
                stringArray[1] = "";
                stringArray[0] = "";
            }
            coordSys = new CoordSys(CoordSys.createReferenceSystem(1, null, horizontalDatum, primeMeridian, null), affineTransform, stringArray[0], stringArray[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return coordSys;
    }

    public static String[] getProjectionParams(Element element) {
        String[] stringArray = new String[3];
        String[] stringArray2 = UnitXmlCreator.a(element.getChild(t));
        System.arraycopy(stringArray2, 0, stringArray, 0, 2);
        stringArray[2] = element.getChildText("className");
        return stringArray;
    }

    public static final AngularUnit createAngularUnit(Element element) {
        return UnitXmlCreator.createAngularUnit(element);
    }

    public static final Element angularUnit(AngularUnit angularUnit) {
        return UnitXmlCreator.writeAngularUnit(angularUnit);
    }

    public static final LinearUnit createLinearUnit(Element element) {
        return UnitXmlCreator.createLinearUnit(element);
    }

    public static String[] createIdentifier(Element element) {
        return UnitXmlCreator.a(element);
    }

    public static final Element linearUnit(LinearUnit linearUnit) {
        return UnitXmlCreator.writeLinearUnit(linearUnit);
    }

    public static final String[] createNameSet(Element element) {
        String[] stringArray = new String[]{element.getChildText(a2), element.getChildText(a3), element.getChildText(a4), element.getChildText(a5)};
        return stringArray;
    }

    private static final Element a(String string, String string2, String string3, String string4) {
        Element element = new Element(i);
        element.addContent(new Element(a2).addContent(string));
        if (string2 != null) {
            element.addContent(new Element(a3).addContent(string2));
        }
        if (string3 != null) {
            element.addContent(new Element(a4).addContent(string3));
        }
        if (string4 != null) {
            element.addContent(new Element(a5).addContent(string4));
        }
        return element;
    }

    private static final Element a(String string) {
        return CoordSysXMLCreator.a(string, null, null, null);
    }

    private static final Element a(String string, String string2) {
        return CoordSysXMLCreator.a(string, string2, null, null);
    }

    private static final Element a(String string, String string2, String string3) {
        return CoordSysXMLCreator.a(string, string2, string3, null);
    }

    private static final Element b(String string) {
        return CoordSysXMLCreator.a(string, null, null, null);
    }

    private static final double a(Iterator iterator) {
        Element element = (Element)iterator.next();
        return LinearUnit.meter.convert(Double.parseDouble(element.getChildText(au)), UnitXmlCreator.createLinearUnit(element.getChild(p)));
    }

    private static final double b(Iterator iterator) {
        Element element = (Element)iterator.next();
        return Double.parseDouble(element.getChildText(au));
    }

    private static final Distance c(Iterator iterator) {
        Element element = (Element)iterator.next();
        return new Distance(Double.parseDouble(element.getChildText(au)), UnitXmlCreator.createLinearUnit(element.getChild(p)));
    }

    private static final double d(Iterator iterator) {
        Element element = (Element)iterator.next();
        return AngularUnit.degree.convert(Double.parseDouble(element.getChildText(au)), UnitXmlCreator.createAngularUnit(element.getChild(am)));
    }

    private static final MeasuredQuantity e(Iterator iterator) {
        Element element = (Element)iterator.next();
        double d2 = Double.parseDouble(element.getChildText(au));
        Element element2 = element.getChild(am);
        if (element2 != null) {
            String[] stringArray = UnitXmlCreator.getAngularUnitParams(element2);
            return new Angle(d2, UnitFactory.createAngularUnit(stringArray[3], stringArray[4]));
        }
        element2 = element.getChild(p);
        if (element2 != null) {
            String[] stringArray = UnitXmlCreator.getLinearUnitParams(element2);
            return new Distance(d2, UnitFactory.createLinearUnit(stringArray[3], stringArray[4]));
        }
        return new MeasuredQuantity(d2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final CoordSys b(Element element, HorizontalDatum horizontalDatum, AffineTransform affineTransform, String[] stringArray) {
        Element element2;
        Object object;
        CoordSys coordSys = null;
        Element element3 = element.getChild(b);
        Element element4 = element3.getChild(COORDINATEREFERENCESYSTEM).getChild(k);
        CoordSys coordSys2 = null;
        if (element4 == null) {
            object = element3.getChild(COORDINATEREFERENCESYSTEM).getChild(t);
            if (object == null) throw new IllegalArgumentException("ProjectedCRS defined improperly");
            element2 = UnitXmlCreator.a((Element)object);
            coordSys2 = CoordSysFactory.createCoordSys((String)element2[0], (String)element2[1]);
        } else {
            coordSys2 = CoordSysXMLCreator.a(element4, horizontalDatum, affineTransform, null);
        }
        object = null;
        element2 = element3.getChild(c);
        Element element5 = element2.getChild(d);
        if (element5 != null) {
            Element element6 = null;
            element6 = element5.getChild(g);
            if (element6 != null) {
                List list = element5.getChildren(j);
                Iterator iterator = list.iterator();
                String[] stringArray2 = UnitXmlCreator.a(element6.getChild(t));
                if (stringArray2[1].equalsIgnoreCase(ax)) {
                    if (stringArray2[0].equalsIgnoreCase("projection2")) {
                        object = new CylindricalEqualArea(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                    } else if (stringArray2[0].equalsIgnoreCase("projection3")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        double d2 = CoordSysXMLCreator.d(iterator);
                        double d3 = CoordSysXMLCreator.d(iterator);
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance2 = CoordSysXMLCreator.c(iterator);
                        object = new LambertConformalConic(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, d2, d3, distance.getScalarValue(), distance2.getScalarValue(), 3);
                    } else if (stringArray2[0].equalsIgnoreCase("projection4")) {
                        object = new LambertAzimuthalEqualArea(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator)), CoordSysXMLCreator.d(iterator));
                    } else if (stringArray2[0].equalsIgnoreCase("projection5")) {
                        object = new AzimuthalEquidistant(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator)), CoordSysXMLCreator.d(iterator));
                    } else if (stringArray2[0].equalsIgnoreCase("projection6")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        double d4 = CoordSysXMLCreator.d(iterator);
                        double d5 = CoordSysXMLCreator.d(iterator);
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance3 = CoordSysXMLCreator.c(iterator);
                        object = new EquidistantConic(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, d4, d5, distance.getScalarValue(), distance3.getScalarValue());
                    } else if (stringArray2[0].equalsIgnoreCase("projection7")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        double d6 = CoordSysXMLCreator.d(iterator);
                        double d7 = CoordSysXMLCreator.b(iterator);
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance4 = CoordSysXMLCreator.c(iterator);
                        object = new HotineObliqueMercator(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, d6, d7, distance.getScalarValue(), distance4.getScalarValue());
                    } else if (stringArray2[0].equalsIgnoreCase("projection8")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        double d8 = CoordSysXMLCreator.b(iterator);
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance5 = CoordSysXMLCreator.c(iterator);
                        object = new TransverseMercator(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, d8, distance.getScalarValue(), distance5.getScalarValue(), 8);
                    } else if (stringArray2[0].equalsIgnoreCase("projection9")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        double d9 = CoordSysXMLCreator.d(iterator);
                        double d10 = CoordSysXMLCreator.d(iterator);
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance6 = CoordSysXMLCreator.c(iterator);
                        object = new AlbersEqualAreaConic(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, d9, d10, distance.getScalarValue(), distance6.getScalarValue());
                    } else if (stringArray2[0].equalsIgnoreCase("projection10")) {
                        object = new Mercator(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), CoordSysXMLCreator.d(iterator));
                    } else if (stringArray2[0].equalsIgnoreCase("projection11")) {
                        object = new Miller(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), CoordSysXMLCreator.d(iterator));
                    } else if (stringArray2[0].equalsIgnoreCase("projection12")) {
                        object = new Robinson(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), CoordSysXMLCreator.d(iterator));
                    } else if (stringArray2[0].equalsIgnoreCase("projection13")) {
                        object = new Mollweide(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), CoordSysXMLCreator.d(iterator));
                    } else if (stringArray2[0].equalsIgnoreCase("projection14")) {
                        object = new EckertIV(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), CoordSysXMLCreator.d(iterator));
                    } else if (stringArray2[0].equalsIgnoreCase("projection15")) {
                        object = new EckertVI(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), CoordSysXMLCreator.d(iterator));
                    } else if (stringArray2[0].equalsIgnoreCase("projection16")) {
                        object = new Sinusoidal(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), CoordSysXMLCreator.d(iterator));
                    } else if (stringArray2[0].equalsIgnoreCase("projection17")) {
                        object = new Gall(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), CoordSysXMLCreator.d(iterator));
                    } else if (stringArray2[0].equalsIgnoreCase("projection18")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance7 = CoordSysXMLCreator.c(iterator);
                        object = new NewZealandMapGrid(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, distance.getScalarValue(), distance7.getScalarValue());
                    } else if (stringArray2[0].equalsIgnoreCase("projection19")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        double d11 = CoordSysXMLCreator.d(iterator);
                        double d12 = CoordSysXMLCreator.d(iterator);
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance8 = CoordSysXMLCreator.c(iterator);
                        object = new LambertConformalConic(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, d11, d12, distance.getScalarValue(), distance8.getScalarValue(), 19);
                    } else if (stringArray2[0].equalsIgnoreCase("projection20")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        double d13 = CoordSysXMLCreator.b(iterator);
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance9 = CoordSysXMLCreator.c(iterator);
                        object = new Stereographic(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, d13, distance.getScalarValue(), distance9.getScalarValue());
                    } else if (stringArray2[0].equalsIgnoreCase("projection21")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        double d14 = CoordSysXMLCreator.b(iterator);
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance10 = CoordSysXMLCreator.c(iterator);
                        object = new TransverseMercator(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, d14, distance.getScalarValue(), distance10.getScalarValue(), 21);
                    } else if (stringArray2[0].equalsIgnoreCase("projection22")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        double d15 = CoordSysXMLCreator.b(iterator);
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance11 = CoordSysXMLCreator.c(iterator);
                        object = new TransverseMercator(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, d15, distance.getScalarValue(), distance11.getScalarValue(), 22);
                    } else if (stringArray2[0].equalsIgnoreCase("projection23")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        double d16 = CoordSysXMLCreator.b(iterator);
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance12 = CoordSysXMLCreator.c(iterator);
                        object = new TransverseMercator(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, d16, distance.getScalarValue(), distance12.getScalarValue(), 23);
                    } else if (stringArray2[0].equalsIgnoreCase("projection24")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        double d17 = CoordSysXMLCreator.b(iterator);
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance13 = CoordSysXMLCreator.c(iterator);
                        object = new TransverseMercator(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, d17, distance.getScalarValue(), distance13.getScalarValue(), 24);
                    } else if (stringArray2[0].equalsIgnoreCase("projection25")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance14 = CoordSysXMLCreator.c(iterator);
                        object = new SwissObliqueMercator(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, distance.getScalarValue(), distance14.getScalarValue());
                    } else if (stringArray2[0].equalsIgnoreCase("projection26")) {
                        object = new Mercator(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                    } else if (stringArray2[0].equalsIgnoreCase("projection27")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance15 = CoordSysXMLCreator.c(iterator);
                        object = new Polyconic(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, distance.getScalarValue(), distance15.getScalarValue());
                    } else if (stringArray2[0].equalsIgnoreCase("projection28")) {
                        object = new AzimuthalEquidistant(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator)), CoordSysXMLCreator.d(iterator));
                    } else if (stringArray2[0].equalsIgnoreCase("projection29")) {
                        object = new LambertAzimuthalEqualArea(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator)), CoordSysXMLCreator.d(iterator));
                    } else if (stringArray2[0].equalsIgnoreCase("projection30")) {
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance16 = CoordSysXMLCreator.c(iterator);
                        object = new CassiniSoldner(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, distance.getScalarValue(), distance16.getScalarValue());
                    } else {
                        if (!stringArray2[0].equalsIgnoreCase("projection31")) throw new UnsupportedOperationException("Custom mapinfo codes not implemented yet");
                        DoublePoint doublePoint = new DoublePoint(CoordSysXMLCreator.d(iterator), CoordSysXMLCreator.d(iterator));
                        double d18 = CoordSysXMLCreator.b(iterator);
                        Distance distance = CoordSysXMLCreator.c(iterator);
                        Distance distance17 = CoordSysXMLCreator.c(iterator);
                        object = new DoubleStereographic(AngularUnit.degree, distance.getLinearUnit(), horizontalDatum.getEllipsoid(), doublePoint, d18, distance.getScalarValue(), distance17.getScalarValue());
                    }
                } else {
                    object = CoordSysFactory.createProjection(stringArray2[0], stringArray2[1]);
                    MeasuredQuantity[] measuredQuantityArray = new MeasuredQuantity[list.size()];
                    int n = 0;
                    while (n < measuredQuantityArray.length) {
                        measuredQuantityArray[n] = CoordSysXMLCreator.e(iterator);
                        ++n;
                    }
                    ((Projection)object).init(AngularUnit.degree, LinearUnit.meter, horizontalDatum.getEllipsoid(), measuredQuantityArray);
                }
            }
        }
        try {
            return new CoordSys((SpatialReferenceSystem)new ProjectedCoordinateSystem(coordSys2.getGeographicCoordinateSystem(), ((Projection)object).getLinearUnit(), (Projection)object), affineTransform, stringArray[0], stringArray[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return coordSys;
    }

    private static final void a() {
        try {
            InputStream inputStream = (bn == null ? (bn = CoordSysXMLCreator.class$("com.mapinfo.xmlprot.csys.CoordSysXMLCreator")) : bn).getResourceAsStream("/micsys.txt");
            if (inputStream == null) {
                System.out.println("micsys.txt not found, epsg values cannot be used");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (string != null) {
                int n = string.indexOf("\\p");
                if (n != -1) {
                    int n2 = string.lastIndexOf("\"");
                    String string2 = string.substring(n + 2, n2);
                    String string3 = string.substring(n2 + 2);
                    bm.put(ba + string2.toLowerCase(), string3);
                    bm.put(string3.trim(), ba + string2.toLowerCase());
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final String getMapBasic(String string) {
        return (String)bm.get(string.toLowerCase());
    }

    public static final String getSrsName(String string) {
        String string2 = (String)bm.get(string);
        if (string2 == null) {
            return null;
        }
        return string2;
    }

    public static final String getSrsName(CoordSys coordSys) {
        String string = coordSys.getSrsName();
        if (string != null && !string.equals("")) {
            return string;
        }
        String string2 = coordSys.computeMapInfoString(false, true);
        return CoordSysXMLCreator.getSrsName(string2);
    }

    public static final String getMapInfoString(CoordSys coordSys) {
        return coordSys.computeMapInfoString(false);
    }

    public static final CoordSys createFromMapInfoString(String string) {
        try {
            return CoordSys.createFromPRJ(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final String constructSrsName(CoordSys coordSys) {
        String string = CoordSysXMLCreator.getSrsName(coordSys);
        if (string == null) {
            string = "mapinfo:" + coordSys.computeMapInfoString(false);
        }
        return string;
    }

    public static final CoordSys createCoordSys(String string) {
        try {
            String string2 = string.toLowerCase();
            if ((string2.startsWith(bb) || string2.startsWith(ax)) && string2.indexOf(",") != -1) {
                String string3 = string2.substring(string2.lastIndexOf(bc) + 1);
                return CoordSys.createFromPRJ(string3);
            }
            String string4 = CoordSysXMLCreator.getMapBasic(string2);
            if (string4 != null) {
                return CoordSys.createFromPRJ("\"\\p" + string2 + "\"," + string4);
            }
            throw new Exception();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unsupported Projection:" + string);
        }
    }

    public static CoordSys createCSFrom30XML(String string) {
        try {
            String string2 = string.substring(string.indexOf(be) + be.length(), string.indexOf(bf));
            int n = string2.indexOf("&quot;");
            while (n != -1) {
                string2 = string2.substring(0, n) + "\"" + string2.substring(n + 6);
                n = string2.indexOf("&quot;");
            }
            String string3 = string.substring(string.indexOf(bk) + bk.length(), string.indexOf(bl));
            double[] dArray = new double[6];
            int n2 = 0;
            while (n2 < 6) {
                int n3 = string3.indexOf(",");
                dArray[n2] = n3 == -1 ? Double.parseDouble(string3) : Double.parseDouble(string3.substring(0, n3));
                string3 = string3.substring(n3 + 1);
                ++n2;
            }
            String string4 = string.substring(string.indexOf(bg) + bg.length(), string.indexOf(bh));
            String string5 = string.substring(string.indexOf(bi) + bi.length(), string.indexOf(bj));
            return new CoordSys(CoordSys.createFromMapBasic(string2), new AffineTransform(dArray), Integer.parseInt(string4), Double.parseDouble(string5));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static CoordSys applyAffineTransform(CoordSys coordSys, AffineTransform affineTransform) {
        try {
            return new CoordSys(coordSys.getReferenceSystem(), affineTransform, coordSys.getCode(), coordSys.getCodeSpace());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean needsAffineTransform(CoordSys coordSys) {
        return !coordSys.getAffineTransform().equivalent(AffineTransform.identity);
    }

    public static Element addRasterTransform(CoordSys coordSys) {
        Element element = new Element("RasterTransform");
        element.addContent(CoordSysXMLCreator.writeAffineTransform(coordSys.getAffineTransform()));
        return element;
    }

    private static void c(Element element) {
        try {
            new XMLOutputter(" ", true).output(element, (OutputStream)System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String[] stringArray = new String[1024];
        stringArray[0] = "mapinfo:coordsys1";
        stringArray[1] = "1, 0";
        stringArray[2] = "mapinfo:coordsys2";
        stringArray[3] = "1, 4";
        stringArray[4] = "mapinfo:coordsys3";
        stringArray[5] = "1, 7";
        stringArray[6] = "mapinfo:coordsys4";
        stringArray[7] = "1, 8";
        stringArray[8] = "mapinfo:coordsys5";
        stringArray[9] = "1, 9";
        stringArray[10] = "mapinfo:coordsys6";
        stringArray[11] = "1, 10";
        stringArray[12] = "mapinfo:coordsys7";
        stringArray[13] = "1, 11";
        stringArray[14] = "mapinfo:coordsys8";
        stringArray[15] = "1, 110";
        stringArray[16] = "mapinfo:coordsys9";
        stringArray[17] = "1, 14";
        stringArray[18] = "mapinfo:coordsys10";
        stringArray[19] = "1, 18";
        stringArray[20] = "mapinfo:coordsys11";
        stringArray[21] = "1, 20";
        stringArray[22] = "mapinfo:coordsys12";
        stringArray[23] = "1, 22";
        stringArray[24] = "mapinfo:coordsys13";
        stringArray[25] = "1, 26";
        stringArray[26] = "mapinfo:coordsys14";
        stringArray[27] = "1, 27";
        stringArray[28] = "mapinfo:coordsys15";
        stringArray[29] = "1, 29";
        stringArray[30] = "mapinfo:coordsys16";
        stringArray[31] = "1, 34";
        stringArray[32] = "mapinfo:coordsys17";
        stringArray[33] = "1, 35";
        stringArray[34] = "mapinfo:coordsys18";
        stringArray[35] = "1, 38";
        stringArray[36] = "mapinfo:coordsys19";
        stringArray[37] = "1, 41";
        stringArray[38] = "mapinfo:coordsys20";
        stringArray[39] = "1, 40";
        stringArray[40] = "mapinfo:coordsys21";
        stringArray[41] = "1, 43";
        stringArray[42] = "mapinfo:coordsys22";
        stringArray[43] = "1, 44";
        stringArray[44] = "mapinfo:coordsys23";
        stringArray[45] = "1, 46";
        stringArray[46] = "mapinfo:coordsys24";
        stringArray[47] = "1, 48";
        stringArray[48] = "mapinfo:coordsys25";
        stringArray[49] = "1, 51";
        stringArray[50] = "mapinfo:coordsys26";
        stringArray[51] = "1, 53";
        stringArray[52] = "mapinfo:coordsys27";
        stringArray[53] = "1, 56";
        stringArray[54] = "mapinfo:coordsys28";
        stringArray[55] = "1, 58";
        stringArray[56] = "mapinfo:coordsys29";
        stringArray[57] = "1, 60";
        stringArray[58] = "mapinfo:coordsys30";
        stringArray[59] = "1, 59";
        stringArray[60] = "mapinfo:coordsys31";
        stringArray[61] = "1, 63";
        stringArray[62] = "mapinfo:coordsys32";
        stringArray[63] = "1, 64";
        stringArray[64] = "mapinfo:coordsys33";
        stringArray[65] = "1, 66";
        stringArray[66] = "mapinfo:coordsys34";
        stringArray[67] = "1, 67";
        stringArray[68] = "mapinfo:coordsys35";
        stringArray[69] = "1, 68";
        stringArray[70] = "mapinfo:coordsys36";
        stringArray[71] = "1, 69";
        stringArray[72] = "mapinfo:coordsys37";
        stringArray[73] = "1, 70";
        stringArray[74] = "mapinfo:coordsys38";
        stringArray[75] = "1, 71";
        stringArray[76] = "mapinfo:coordsys39";
        stringArray[77] = "1, 69";
        stringArray[78] = "mapinfo:coordsys40";
        stringArray[79] = "1, 65";
        stringArray[80] = "mapinfo:coordsys41";
        stringArray[81] = "1, 111";
        stringArray[82] = "mapinfo:coordsys42";
        stringArray[83] = "1, 75";
        stringArray[84] = "mapinfo:coordsys43";
        stringArray[85] = "1, 77";
        stringArray[86] = "mapinfo:coordsys44";
        stringArray[87] = "1, 78";
        stringArray[88] = "mapinfo:coordsys45";
        stringArray[89] = "1, 80";
        stringArray[90] = "mapinfo:coordsys46";
        stringArray[91] = "1, 81";
        stringArray[92] = "mapinfo:coordsys47";
        stringArray[93] = "1, 83";
        stringArray[94] = "mapinfo:coordsys48";
        stringArray[95] = "1, 86";
        stringArray[96] = "mapinfo:coordsys49";
        stringArray[97] = "1, 87";
        stringArray[98] = "mapinfo:coordsys50";
        stringArray[99] = "1, 112";
        stringArray[100] = "mapinfo:coordsys51";
        stringArray[101] = "1, 1011";
        stringArray[102] = "mapinfo:coordsys52";
        stringArray[103] = "1, 88";
        stringArray[104] = "mapinfo:coordsys53";
        stringArray[105] = "1, 89";
        stringArray[106] = "mapinfo:coordsys54";
        stringArray[107] = "1, 93";
        stringArray[108] = "mapinfo:coordsys55";
        stringArray[109] = "1, 94";
        stringArray[110] = "mapinfo:coordsys56";
        stringArray[111] = "1, 95";
        stringArray[112] = "mapinfo:coordsys57";
        stringArray[113] = "1, 98";
        stringArray[114] = "mapinfo:coordsys58";
        stringArray[115] = "1, 99";
        stringArray[116] = "mapinfo:coordsys59";
        stringArray[117] = "1, 100";
        stringArray[118] = "mapinfo:coordsys60";
        stringArray[119] = "1, 101";
        stringArray[120] = "mapinfo:coordsys61";
        stringArray[121] = "1, 102";
        stringArray[122] = "mapinfo:coordsys62";
        stringArray[123] = "1, 1004";
        stringArray[124] = "mapinfo:coordsys63";
        stringArray[125] = "1, 150";
        stringArray[126] = "mapinfo:coordsys64";
        stringArray[127] = "1, 1006";
        stringArray[128] = "mapinfo:coordsys65";
        stringArray[129] = "1, 1007";
        stringArray[130] = "mapinfo:coordsys66";
        stringArray[131] = "1, 1008";
        stringArray[132] = "mapinfo:coordsys67";
        stringArray[133] = "1, 1009";
        stringArray[134] = "mapinfo:coordsys68";
        stringArray[135] = "1, 1010";
        stringArray[136] = "mapinfo:coordsys69";
        stringArray[137] = "1, 115";
        stringArray[138] = "mapinfo:coordsys70";
        stringArray[139] = "1, 116";
        stringArray[140] = "mapinfo:coordsys71";
        stringArray[141] = "1, 117";
        stringArray[142] = "mapinfo:coordsys72";
        stringArray[143] = "1, 118";
        stringArray[144] = "mapinfo:coordsys73";
        stringArray[145] = "1, 119";
        stringArray[146] = "mapinfo:coordsys74";
        stringArray[147] = "1, 120";
        stringArray[148] = "mapinfo:coordsys75";
        stringArray[149] = "1, 121";
        stringArray[150] = "mapinfo:coordsys76";
        stringArray[151] = "1, 122";
        stringArray[152] = "mapinfo:coordsys77";
        stringArray[153] = "1, 123";
        stringArray[154] = "mapinfo:coordsys78";
        stringArray[155] = "1, 124";
        stringArray[156] = "mapinfo:coordsys79";
        stringArray[157] = "1, 125";
        stringArray[158] = "mapinfo:coordsys80";
        stringArray[159] = "1, 126";
        stringArray[160] = "mapinfo:coordsys81";
        stringArray[161] = "1, 127";
        stringArray[162] = "mapinfo:coordsys82";
        stringArray[163] = "1, 128";
        stringArray[164] = "mapinfo:coordsys83";
        stringArray[165] = "1, 129";
        stringArray[166] = "mapinfo:coordsys84";
        stringArray[167] = "1, 130";
        stringArray[168] = "mapinfo:coordsys85";
        stringArray[169] = "1, 131";
        stringArray[170] = "mapinfo:coordsys86";
        stringArray[171] = "1, 132";
        stringArray[172] = "mapinfo:coordsys87";
        stringArray[173] = "1, 133";
        stringArray[174] = "mapinfo:coordsys88";
        stringArray[175] = "1, 134";
        stringArray[176] = "mapinfo:coordsys89";
        stringArray[177] = "1, 135";
        stringArray[178] = "mapinfo:coordsys90";
        stringArray[179] = "1, 136";
        stringArray[180] = "mapinfo:coordsys91";
        stringArray[181] = "1, 137";
        stringArray[182] = "mapinfo:coordsys92";
        stringArray[183] = "1, 138";
        stringArray[184] = "mapinfo:coordsys93";
        stringArray[185] = "1, 139";
        stringArray[186] = "mapinfo:coordsys94";
        stringArray[187] = "1, 140";
        stringArray[188] = "mapinfo:coordsys95";
        stringArray[189] = "1, 141";
        stringArray[190] = "mapinfo:coordsys96";
        stringArray[191] = "1, 142";
        stringArray[192] = "mapinfo:coordsys97";
        stringArray[193] = "1, 143";
        stringArray[194] = "mapinfo:coordsys98";
        stringArray[195] = "1, 144";
        stringArray[196] = "mapinfo:coordsys99";
        stringArray[197] = "1, 145";
        stringArray[198] = "mapinfo:coordsys100";
        stringArray[199] = "1, 146";
        stringArray[200] = "mapinfo:coordsys101";
        stringArray[201] = "1, 147";
        stringArray[202] = "mapinfo:coordsys102";
        stringArray[203] = "1, 148";
        stringArray[204] = "mapinfo:coordsys103";
        stringArray[205] = "1, 149";
        stringArray[206] = "mapinfo:coordsys104";
        stringArray[207] = "1, 148";
        stringArray[208] = "mapinfo:coordsys105";
        stringArray[209] = "1, 999, 50, 283, 682, 231";
        stringArray[210] = "mapinfo:coordsys106";
        stringArray[211] = "1, 999, 51, 0, 0, 0";
        stringArray[212] = "mapinfo:coordsys107";
        stringArray[213] = "0, 2";
        stringArray[214] = "mapinfo:coordsys108";
        stringArray[215] = "0, 3";
        stringArray[216] = "mapinfo:coordsys109";
        stringArray[217] = "0, 4";
        stringArray[218] = "mapinfo:coordsys110";
        stringArray[219] = "0, 0";
        stringArray[220] = "mapinfo:coordsys111";
        stringArray[221] = "0, 5";
        stringArray[222] = "mapinfo:coordsys112";
        stringArray[223] = "0, 6";
        stringArray[224] = "mapinfo:coordsys113";
        stringArray[225] = "0, 7";
        stringArray[226] = "mapinfo:coordsys114";
        stringArray[227] = "0, 1";
        stringArray[228] = "mapinfo:coordsys115";
        stringArray[229] = "2, 62, 7, 0, 30";
        stringArray[230] = "mapinfo:coordsys116";
        stringArray[231] = "14, 62, 7, 0";
        stringArray[232] = "mapinfo:coordsys117";
        stringArray[233] = "15, 62, 7, 0";
        stringArray[234] = "mapinfo:coordsys118";
        stringArray[235] = "17, 62, 7, 0";
        stringArray[236] = "mapinfo:coordsys119";
        stringArray[237] = "10, 62, 7, 0";
        stringArray[238] = "mapinfo:coordsys120";
        stringArray[239] = "11, 62, 7, 0";
        stringArray[240] = "mapinfo:coordsys121";
        stringArray[241] = "13, 62, 7, 0";
        stringArray[242] = "mapinfo:coordsys122";
        stringArray[243] = "12, 62, 7, 0";
        stringArray[244] = "mapinfo:coordsys123";
        stringArray[245] = "16, 62, 7, 0";
        stringArray[246] = "mapinfo:coordsys124";
        stringArray[247] = "5, 62, 7, 0, 90, 90";
        stringArray[248] = "mapinfo:coordsys125";
        stringArray[249] = "5, 62, 7, 0, -90, 90";
        stringArray[250] = "mapinfo:coordsys126";
        stringArray[251] = "4, 62, 7, 0, 90, 90";
        stringArray[252] = "mapinfo:coordsys127";
        stringArray[253] = "4, 62, 7, 0, -90, 90";
        stringArray[254] = "mapinfo:coordsys128";
        stringArray[255] = "20, 74, 7, 0, 0, 1, 0, 0";
        stringArray[256] = "mapinfo:coordsys129";
        stringArray[257] = "10, 0, 0, 20";
        stringArray[258] = "mapinfo:coordsys130";
        stringArray[259] = "3, 0, 0, 95, 40, 20, 60, 0, 0";
        stringArray[260] = "mapinfo:coordsys131";
        stringArray[261] = "3, 0, 0, 132.5, -10, -21.5, -33.5, 0, 0";
        stringArray[262] = "mapinfo:coordsys132";
        stringArray[263] = "10, 0, 0, -85.5";
        stringArray[264] = "mapinfo:coordsys133";
        stringArray[265] = "3, 0, 0, 110, 10, 25, 40, 0, 0";
        stringArray[266] = "mapinfo:coordsys134";
        stringArray[267] = "3, 0, 0, 25, 35, 40, 65, 0, 0";
        stringArray[268] = "mapinfo:coordsys135";
        stringArray[269] = "3, 28, 7, 17, 29.77930555, 42, 56, 2679984.29, -484330";
        stringArray[270] = "mapinfo:coordsys136";
        stringArray[271] = "8, 0, 0, 78, 0, 1.0, 0, 0";
        stringArray[272] = "mapinfo:coordsys137";
        stringArray[273] = "3, 0, 0, 47.5, 25, 15, 35, 0, 0";
        stringArray[274] = "mapinfo:coordsys138";
        stringArray[275] = "3, 62, 7, -96, 23, 20, 60, 0, 0";
        stringArray[276] = "mapinfo:coordsys139";
        stringArray[277] = "10, 0, 0, -60";
        stringArray[278] = "mapinfo:coordsys140";
        stringArray[279] = "3, 62, 7, -96, 23, 33, 45, 0, 0";
        stringArray[280] = "mapinfo:coordsys141";
        stringArray[281] = "3, 62, 7, -96, 39, 33, 45, 0, 0";
        stringArray[282] = "mapinfo:coordsys142";
        stringArray[283] = "3, 66, 7, -68.5, 44, 46, 60, 0, 0";
        stringArray[284] = "mapinfo:coordsys143";
        stringArray[285] = "2, 0, 0, 20, 0";
        stringArray[286] = "mapinfo:coordsys144";
        stringArray[287] = "9, 0, 0, 95, 40, 20, 60, 0, 0";
        stringArray[288] = "mapinfo:coordsys145";
        stringArray[289] = "9, 0, 0, 132.5, -10, -21.5, -33.5, 0, 0";
        stringArray[290] = "mapinfo:coordsys146";
        stringArray[291] = "2, 0, 0, -85.5, 13";
        stringArray[292] = "mapinfo:coordsys147";
        stringArray[293] = "9, 0, 0, 110, 10, 25, 40, 0, 0";
        stringArray[294] = "mapinfo:coordsys148";
        stringArray[295] = "9, 0, 0, 25, 35, 40, 65, 0, 0";
        stringArray[296] = "mapinfo:coordsys149";
        stringArray[297] = "9, 0, 0, 78, 23, 22, 33, 0, 0";
        stringArray[298] = "mapinfo:coordsys150";
        stringArray[299] = "9, 0, 0, 47.5, 25, 15, 35, 0, 0";
        stringArray[300] = "mapinfo:coordsys151";
        stringArray[301] = "9, 62, 7, -96, 23, 20, 60, 0, 0";
        stringArray[302] = "mapinfo:coordsys152";
        stringArray[303] = "14, 0, 0, -60";
        stringArray[304] = "mapinfo:coordsys153";
        stringArray[305] = "9, 62, 7, -96, 23, 29.5, 45.5, 0, 0";
        stringArray[306] = "mapinfo:coordsys154";
        stringArray[307] = "8, 12, 7, 99, 0, 0.9996, 500000, 10000000";
        stringArray[308] = "mapinfo:coordsys155";
        stringArray[309] = "8, 13, 7, 99, 0, 0.9996, 500000, 10000000";
        stringArray[310] = "mapinfo:coordsys156";
        stringArray[311] = "8, 33, 7, 99, 0, 0.9996, 500000, 10000000";
        stringArray[312] = "mapinfo:coordsys157";
        stringArray[313] = "8, 12, 7, 149.0092948333, 0, 1.000086, 200000, 4510193.4939";
        stringArray[314] = "mapinfo:coordsys158";
        stringArray[315] = "8, 12, 7, 141, 0, 0.99994, 300000, 5000000";
        stringArray[316] = "mapinfo:coordsys159";
        stringArray[317] = "8, 12, 7, 143, 0, 0.99994, 300000, 5000000";
        stringArray[318] = "mapinfo:coordsys160";
        stringArray[319] = "8, 12, 7, 145, 0, 0.99994, 300000, 5000000";
        stringArray[320] = "mapinfo:coordsys161";
        stringArray[321] = "8, 12, 7, 147, 0, 0.99994, 300000, 5000000";
        stringArray[322] = "mapinfo:coordsys162";
        stringArray[323] = "8, 12, 7, 149, 0, 0.99994, 300000, 5000000";
        stringArray[324] = "mapinfo:coordsys163";
        stringArray[325] = "8, 12, 7, 151, 0, 0.99994, 300000, 5000000";
        stringArray[326] = "mapinfo:coordsys164";
        stringArray[327] = "8, 12, 7, 153, 0, 0.99994, 300000, 5000000";
        stringArray[328] = "mapinfo:coordsys165";
        stringArray[329] = "8, 12, 7, 155, 0, 0.99994, 300000, 5000000";
        stringArray[330] = "mapinfo:coordsys166";
        stringArray[331] = "6, 13, 7, 134, -90, -18, -36, 0, 0";
        stringArray[332] = "mapinfo:coordsys167";
        stringArray[333] = "6, 13, 1, 147, -32.5, -29.5, -35.5, 0, 0";
        stringArray[334] = "mapinfo:coordsys168";
        stringArray[335] = "3, 12, 7, 145, -37, -36, -38, 2500000, 4500000";
        stringArray[336] = "mapinfo:coordsys169";
        stringArray[337] = "9, 12, 7, 132, 0, -36, -18, 0, 0";
        stringArray[338] = "mapinfo:coordsys170";
        stringArray[339] = "9, 13, 7, 132, 0, -36, -18, 0, 0";
        stringArray[340] = "mapinfo:coordsys171";
        stringArray[341] = "3, 12, 7, 147, 0, -32.666, -35.333, 1000000, 10000000";
        stringArray[342] = "mapinfo:coordsys172";
        stringArray[343] = "6, 13, 1, 134, -90, -18, -36, 0, 0";
        stringArray[344] = "mapinfo:coordsys173";
        stringArray[345] = "3, 12, 7, 135, -24, -18, -36, 0, 0";
        stringArray[346] = "mapinfo:coordsys174";
        stringArray[347] = "1, 116";
        stringArray[348] = "mapinfo:coordsys175";
        stringArray[349] = "8, 33, 7, -2, 49, 0.9996012717, 400000, -100000";
        stringArray[350] = "mapinfo:coordsys176";
        stringArray[351] = "8, 115, 7, 9.5, 0, 0.99995, 200000, 0";
        stringArray[352] = "mapinfo:coordsys177";
        stringArray[353] = "8, 115, 7, 12.0, 0, 0.99995, 500000, 0";
        stringArray[354] = "mapinfo:coordsys178";
        stringArray[355] = "8, 115, 7, 15.0, 0, 1.00000, 900000, 0";
        stringArray[356] = "mapinfo:coordsys179";
        stringArray[357] = "8, 115, 7, 9.0, 0, 0.9996 , 500000, 0";
        stringArray[358] = "mapinfo:coordsys180";
        stringArray[359] = "8, 115, 7, 15.0, 0, 0.9996 , 500000, 0";
        stringArray[360] = "mapinfo:coordsys185";
        stringArray[361] = "3, 1002, 7, 0, 42.165, 41.560387840948, 42.76766346965, 234.358, 4185861.369";
        stringArray[362] = "mapinfo:coordsys186";
        stringArray[363] = "3, 1002, 7, 0, 42.165, 41.560387840948, 42.76766346965, 234.358, 185861.369";
        stringArray[364] = "mapinfo:coordsys187";
        stringArray[365] = "8, 1001, 7, 3, 0, 1, 1500000, 0";
        stringArray[366] = "mapinfo:coordsys188";
        stringArray[367] = "8, 1001, 7, 9, 0, 1, 2500000, 0";
        stringArray[368] = "mapinfo:coordsys189";
        stringArray[369] = "8, 1001, 7, 15, 0, 1, 3500000, 0";
        stringArray[370] = "mapinfo:coordsys190";
        stringArray[371] = "8, 38, 7, 114.178555, 22.3121333, 1, 836694.05, 819069.8";
        stringArray[372] = "mapinfo:coordsys191";
        stringArray[373] = "1, 38";
        stringArray[374] = "mapinfo:coordsys192";
        stringArray[375] = "8, 38, 7, 114.178555, 22.3121333, 0.99995, 836694.05, 819069.8";
        stringArray[376] = "mapinfo:coordsys533";
        stringArray[377] = "8, 33, 1, 35.2120805, 31.7340969, 1.0, 170.251555, 126.867909";
        stringArray[378] = "mapinfo:coordsys534";
        stringArray[379] = "8, 33, 1, 35.2045169, 31.7343936, 1.0000067, 219.529584, 626.907390";
        stringArray[380] = "mapinfo:coordsys535";
        stringArray[381] = "8, 33, 7, 35.2120805, 31.7340969, 1.0, 170251.555, 126867.909";
        stringArray[382] = "mapinfo:coordsys193";
        stringArray[383] = "8, 97, 7, 129.5, 33, 0.9999, 0, 0";
        stringArray[384] = "mapinfo:coordsys194";
        stringArray[385] = "8, 97, 7, 131, 33, 0.9999, 0, 0";
        stringArray[386] = "mapinfo:coordsys195";
        stringArray[387] = "8, 97, 7, 132.166666, 36, 0.9999, 0, 0";
        stringArray[388] = "mapinfo:coordsys196";
        stringArray[389] = "8, 97, 7, 133.5, 33, 0.9999, 0, 0";
        stringArray[390] = "mapinfo:coordsys197";
        stringArray[391] = "8, 97, 7, 134.333333, 36, 0.9999, 0, 0";
        stringArray[392] = "mapinfo:coordsys198";
        stringArray[393] = "8, 97, 7, 136, 36, 0.9999, 0, 0";
        stringArray[394] = "mapinfo:coordsys199";
        stringArray[395] = "8, 97, 7, 137.166666, 36, 0.9999, 0, 0";
        stringArray[396] = "mapinfo:coordsys200";
        stringArray[397] = "8, 97, 7, 138.5, 36, 0.9999, 0, 0";
        stringArray[398] = "mapinfo:coordsys201";
        stringArray[399] = "8, 97, 7, 139.833333, 36, 0.9999, 0, 0";
        stringArray[400] = "mapinfo:coordsys202";
        stringArray[401] = "8, 97, 7, 140.833333, 40, 0.9999, 0, 0";
        stringArray[402] = "mapinfo:coordsys203";
        stringArray[403] = "8, 97, 7, 140.25, 44, 0.9999, 0, 0";
        stringArray[404] = "mapinfo:coordsys204";
        stringArray[405] = "8, 97, 7, 142.25, 44, 0.9999, 0, 0";
        stringArray[406] = "mapinfo:coordsys205";
        stringArray[407] = "8, 97, 7, 144.25, 44, 0.9999, 0, 0";
        stringArray[408] = "mapinfo:coordsys206";
        stringArray[409] = "8, 97, 7, 142, 26, 0.9999, 0, 0";
        stringArray[410] = "mapinfo:coordsys207";
        stringArray[411] = "8, 97, 7, 127.5, 26, 0.9999, 0, 0";
        stringArray[412] = "mapinfo:coordsys208";
        stringArray[413] = "8, 97, 7, 124, 26, 0.9999, 0, 0";
        stringArray[414] = "mapinfo:coordsys209";
        stringArray[415] = "8, 97, 7, 131, 26, 0.9999, 0, 0";
        stringArray[416] = "mapinfo:coordsys210";
        stringArray[417] = "8, 97, 7, 136, 20, 0.9999, 0, 0";
        stringArray[418] = "mapinfo:coordsys211";
        stringArray[419] = "8, 97, 7, 154, 26, 0.9999, 0, 0";
        stringArray[420] = "mapinfo:coordsys212";
        stringArray[421] = "8, 9999, 4, -185.836, 13.479, -14.527, 0.441203, 3.027399, -2.607685, 0, 0, 7, 6.166666667, 49.83333333, 1, 80000, 100000";
        stringArray[422] = "mapinfo:coordsys213";
        stringArray[423] = "8, 999, 4, -185.836, 13.479, -14.527, 7, 6.166666667, 49.83333333, 1, 80000, 100000";
        stringArray[424] = "mapinfo:coordsys214";
        stringArray[425] = "8, 9999, 4, -262.512, 75.745, 44.788, 0.441203, 3.027399, -2.607685, 0, 0, 7, 6.166666667, 49.83333333, 1, 80000, 100000";
        stringArray[426] = "mapinfo:coordsys215";
        stringArray[427] = "8, 999, 4, -262.512, 75.745, 44.788, 7, 6.166666667, 49.83333333, 1, 80000, 100000";
        stringArray[428] = "mapinfo:coordsys216";
        stringArray[429] = "8, 31, 7, 173.010133389, -42.689116583, 1, 300000, 700000";
        stringArray[430] = "mapinfo:coordsys217";
        stringArray[431] = "8, 31, 7, 176.466197250, -37.761249806, 1, 300000, 700000";
        stringArray[432] = "mapinfo:coordsys218";
        stringArray[433] = "8, 31, 7, 168.342872000, -46.600009611, 1, 300002.66, 699999.58";
        stringArray[434] = "mapinfo:coordsys219";
        stringArray[435] = "8, 31, 7, 171.581260056, -41.810802861, 1, 300000, 700000";
        stringArray[436] = "mapinfo:coordsys220";
        stringArray[437] = "8, 31, 7, 172.672046500, -40.714759056, 1, 300000, 700000";
        stringArray[438] = "mapinfo:coordsys221";
        stringArray[439] = "8, 31, 7, 171.360748472, -43.748711556, 1, 300000, 700000";
        stringArray[440] = "mapinfo:coordsys222";
        stringArray[441] = "8, 31, 7, 171.549771306, -42.333694278, 1, 300000, 700000";
        stringArray[442] = "mapinfo:coordsys223";
        stringArray[443] = "8, 31, 7, 176.673680528, -39.650929306, 1, 300000, 700000";
        stringArray[444] = "mapinfo:coordsys224";
        stringArray[445] = "8, 31, 7, 170.979993500, -42.886322361, 1, 300000, 700000";
        stringArray[446] = "mapinfo:coordsys225";
        stringArray[447] = "8, 31, 7, 168.606267000, -43.977802889, 1, 300000, 700000";
        stringArray[448] = "mapinfo:coordsys226";
        stringArray[449] = "8, 31, 7, 172.109028194, -41.289911528, 1, 300000, 700000";
        stringArray[450] = "mapinfo:coordsys227";
        stringArray[451] = "8, 31, 7, 169.467755083, -44.735267972, 1, 300000, 700000";
        stringArray[452] = "mapinfo:coordsys228";
        stringArray[453] = "8, 31, 7, 173.802074111, -41.544486667, 1, 300000, 700000";
        stringArray[454] = "mapinfo:coordsys229";
        stringArray[455] = "8, 31, 7, 174.764339361, -36.879865278, 0.9999, 300000, 700000";
        stringArray[456] = "mapinfo:coordsys230";
        stringArray[457] = "8, 31, 7, 168.398641194, -45.132902583, 1, 300000, 700000";
        stringArray[458] = "mapinfo:coordsys231";
        stringArray[459] = "8, 31, 7, 172.727193583, -43.590637583, 1, 300000, 700000";
        stringArray[460] = "mapinfo:coordsys232";
        stringArray[461] = "8, 31, 7, 167.738861778, -45.563726167, 1, 300000, 700000";
        stringArray[462] = "mapinfo:coordsys233";
        stringArray[463] = "8, 31, 7, 173.299316806, -41.274544722, 1, 300000, 700000";
        stringArray[464] = "mapinfo:coordsys234";
        stringArray[465] = "8, 31, 7, 170.282589111, -45.861513361, 0.99996, 300000, 700000";
        stringArray[466] = "mapinfo:coordsys235";
        stringArray[467] = "8, 31, 7, 170.628595167, -45.816196611, 1, 300000, 700000";
        stringArray[468] = "mapinfo:coordsys236";
        stringArray[469] = "8, 31, 7, 170.260925833, -43.110128139, 1, 300000, 700000";
        stringArray[470] = "mapinfo:coordsys237";
        stringArray[471] = "8, 31, 7, 177.885636278, -38.624702778, 1, 300000, 700000";
        stringArray[472] = "mapinfo:coordsys238";
        stringArray[473] = "8, 31, 7, 174.228011750, -39.135758306, 1, 300000, 700000";
        stringArray[474] = "mapinfo:coordsys239";
        stringArray[475] = "8, 31, 7, 171.057250833, -44.402220361, 1, 300000, 700000";
        stringArray[476] = "mapinfo:coordsys240";
        stringArray[477] = "8, 31, 7, 175.640036806, -39.512470389, 1, 300000, 700000";
        stringArray[478] = "mapinfo:coordsys241";
        stringArray[479] = "8, 31, 7, 175.647349667, -40.925532639, 1, 300000, 700000";
        stringArray[480] = "mapinfo:coordsys242";
        stringArray[481] = "8, 31, 7, 175.488099611, -40.241947139, 1, 300000, 700000";
        stringArray[482] = "mapinfo:coordsys243";
        stringArray[483] = "8, 31, 7, 174.776623111, -41.301319639, 1, 300000, 700000";
        stringArray[484] = "mapinfo:coordsys244";
        stringArray[485] = "9, 62, 7, -96, 23, 20, 60, 0, 0";
        stringArray[486] = "mapinfo:coordsys245";
        stringArray[487] = "9, 62, 7, -96, 23, 29.5, 45.5, 0, 0";
        stringArray[488] = "mapinfo:coordsys246";
        stringArray[489] = "9, 63, 7, -154, 50, 55, 65, 0, 0";
        stringArray[490] = "mapinfo:coordsys247";
        stringArray[491] = "9, 62, 7, -157, 3, 8, 18, 0, 0";
        stringArray[492] = "mapinfo:coordsys248";
        stringArray[493] = "6, 62, 7, -96, 23, 20, 60, 0, 0";
        stringArray[494] = "mapinfo:coordsys249";
        stringArray[495] = "6, 62, 7, -96, 23, 29.5, 45.5, 0, 0";
        stringArray[496] = "mapinfo:coordsys250";
        stringArray[497] = "3, 62, 7, -96, 23, 20, 60, 0, 0";
        stringArray[498] = "mapinfo:coordsys251";
        stringArray[499] = "3, 62, 7, -96, 23, 33, 45, 0, 0";
        stringArray[500] = "mapinfo:coordsys252";
        stringArray[501] = "8, 113, 7, -8.1319061111, 39.6666666667, 1, 200000, 300000";
        stringArray[502] = "mapinfo:coordsys253";
        stringArray[503] = "8, 113, 7, -8.1319061111, 39.6666666667, 1, 0, 0";
        stringArray[504] = "mapinfo:coordsys254";
        stringArray[505] = "8, 114, 7, -8.1319061111, 39.6666666667, 1, 180.598, -86.99";
        stringArray[506] = "mapinfo:coordsys255";
        stringArray[507] = "8, 104, 7, -8.1319061111, 39.6666666667, 1, 0, 0";
        stringArray[508] = "mapinfo:coordsys256";
        stringArray[509] = "8, 66, 7, -55.5, 0, 0.9999, 304800, 0";
        stringArray[510] = "mapinfo:coordsys257";
        stringArray[511] = "8, 66, 7, -58.5, 0, 0.9999, 304800, 0";
        stringArray[512] = "mapinfo:coordsys258";
        stringArray[513] = "8, 66, 7, -61.5, 0, 0.9999, 304800, 0";
        stringArray[514] = "mapinfo:coordsys259";
        stringArray[515] = "8, 66, 7, -64.5, 0, 0.9999, 304800, 0";
        stringArray[516] = "mapinfo:coordsys260";
        stringArray[517] = "8, 66, 7, -67.5, 0, 0.9999, 304800, 0";
        stringArray[518] = "mapinfo:coordsys261";
        stringArray[519] = "8, 66, 7, -70.5, 0, 0.9999, 304800, 0";
        stringArray[520] = "mapinfo:coordsys262";
        stringArray[521] = "8, 66, 7, -73.5, 0, 0.9999, 304800, 0";
        stringArray[522] = "mapinfo:coordsys263";
        stringArray[523] = "8, 66, 7, -76.5, 0, 0.9999, 304800, 0";
        stringArray[524] = "mapinfo:coordsys264";
        stringArray[525] = "8, 66, 7, -79.5, 0, 0.9999, 304800, 0";
        stringArray[526] = "mapinfo:coordsys265";
        stringArray[527] = "8, 74, 7, -55.5, 0, 0.9999, 304800, 0";
        stringArray[528] = "mapinfo:coordsys266";
        stringArray[529] = "8, 74, 7, -58.5, 0, 0.9999, 304800, 0";
        stringArray[530] = "mapinfo:coordsys267";
        stringArray[531] = "8, 74, 7, -61.5, 0, 0.9999, 304800, 0";
        stringArray[532] = "mapinfo:coordsys268";
        stringArray[533] = "8, 74, 7, -64.5, 0, 0.9999, 304800, 0";
        stringArray[534] = "mapinfo:coordsys269";
        stringArray[535] = "8, 74, 7, -67.5, 0, 0.9999, 304800, 0";
        stringArray[536] = "mapinfo:coordsys270";
        stringArray[537] = "8, 74, 7, -70.5, 0, 0.9999, 304800, 0";
        stringArray[538] = "mapinfo:coordsys271";
        stringArray[539] = "8, 74, 7, -73.5, 0, 0.9999, 304800, 0";
        stringArray[540] = "mapinfo:coordsys272";
        stringArray[541] = "8, 74, 7, -76.5, 0, 0.9999, 304800, 0";
        stringArray[542] = "mapinfo:coordsys273";
        stringArray[543] = "8, 74, 7, -79.5, 0, 0.9999, 304800, 0";
        stringArray[544] = "mapinfo:coordsys274";
        stringArray[545] = "9, 19, 7, 23, -23, -18, -32, 0, 0";
        stringArray[546] = "mapinfo:coordsys275";
        stringArray[547] = "3, 19, 7, 23, -23, -18, -32, 0, 0";
        stringArray[548] = "mapinfo:coordsys276";
        stringArray[549] = "8, 19, 7, 17, 0, 1, 0, 0";
        stringArray[550] = "mapinfo:coordsys277";
        stringArray[551] = "8, 19, 7, 19, 0, 1, 0, 0";
        stringArray[552] = "mapinfo:coordsys278";
        stringArray[553] = "8, 19, 7, 19, 0, 1, 0, 3700000";
        stringArray[554] = "mapinfo:coordsys279";
        stringArray[555] = "8, 19, 7, 21, 0, 1, 0, 0";
        stringArray[556] = "mapinfo:coordsys280";
        stringArray[557] = "8, 19, 7, 23, 0, 1, 0, 0";
        stringArray[558] = "mapinfo:coordsys281";
        stringArray[559] = "8, 19, 7, 25, 0, 1, 0, 0";
        stringArray[560] = "mapinfo:coordsys282";
        stringArray[561] = "8, 19, 7, 27, 0, 1, 0, 0";
        stringArray[562] = "mapinfo:coordsys283";
        stringArray[563] = "8, 19, 7, 29, 0, 1, 0, 0";
        stringArray[564] = "mapinfo:coordsys284";
        stringArray[565] = "8, 19, 7, 31, 0, 1, 0, 0";
        stringArray[566] = "mapinfo:coordsys285";
        stringArray[567] = "9, 1005, 7, 23, -23, -18, -32, 0, 0";
        stringArray[568] = "mapinfo:coordsys286";
        stringArray[569] = "3, 1005, 7, 23, -23, -18, -32, 0, 0";
        stringArray[570] = "mapinfo:coordsys287";
        stringArray[571] = "8, 1005, 7, 17, 0, 1, 0, 0";
        stringArray[572] = "mapinfo:coordsys288";
        stringArray[573] = "8, 1005, 7, 19, 0, 1, 0, 0";
        stringArray[574] = "mapinfo:coordsys289";
        stringArray[575] = "8, 1005, 7, 19, 0, 1, 0, 3700000";
        stringArray[576] = "mapinfo:coordsys290";
        stringArray[577] = "8, 1005, 7, 21, 0, 1, 0, 0";
        stringArray[578] = "mapinfo:coordsys291";
        stringArray[579] = "8, 1005, 7, 23, 0, 1, 0, 0";
        stringArray[580] = "mapinfo:coordsys292";
        stringArray[581] = "8, 1005, 7, 25, 0, 1, 0, 0";
        stringArray[582] = "mapinfo:coordsys293";
        stringArray[583] = "8, 1005, 7, 27, 0, 1, 0, 0";
        stringArray[584] = "mapinfo:coordsys294";
        stringArray[585] = "8, 1005, 7, 29, 0, 1, 0, 0";
        stringArray[586] = "mapinfo:coordsys295";
        stringArray[587] = "8, 1005, 7, 31, 0, 1, 0, 0";
        stringArray[588] = "mapinfo:coordsys296";
        stringArray[589] = "8, 112, 7, 15.8082777778, 0, 1, 1500000, 0";
        stringArray[590] = "mapinfo:coordsys297";
        stringArray[591] = "25, 1003, 7, 7.4395833333, 46.9524055555, 600000, 200000";
        stringArray[592] = "mapinfo:coordsys298";
        stringArray[593] = "20, 104, 7, 0, 90, 0.994, 2000000, 2000000";
        stringArray[594] = "mapinfo:coordsys299";
        stringArray[595] = "20, 104, 7, 0, -90, 0.994, 2000000, 2000000";
        stringArray[596] = "mapinfo:coordsys300";
        stringArray[597] = "8, 24, 7, -75, 0, 0.9996, 500000, 10000000";
        stringArray[598] = "mapinfo:coordsys301";
        stringArray[599] = "8, 24, 7, -69, 0, 0.9996, 500000, 0";
        stringArray[600] = "mapinfo:coordsys302";
        stringArray[601] = "8, 24, 7, -69, 0, 0.9996, 500000, 10000000";
        stringArray[602] = "mapinfo:coordsys303";
        stringArray[603] = "8, 24, 7, -63, 0, 0.9996, 500000, 0";
        stringArray[604] = "mapinfo:coordsys304";
        stringArray[605] = "8, 24, 7, -63, 0, 0.9996, 500000, 10000000";
        stringArray[606] = "mapinfo:coordsys305";
        stringArray[607] = "8, 24, 7, -57, 0, 0.9996, 500000, 0";
        stringArray[608] = "mapinfo:coordsys306";
        stringArray[609] = "8, 24, 7, -57, 0, 0.9996, 500000, 10000000";
        stringArray[610] = "mapinfo:coordsys307";
        stringArray[611] = "8, 24, 7, -51, 0, 0.9996, 500000, 0";
        stringArray[612] = "mapinfo:coordsys308";
        stringArray[613] = "8, 24, 7, -51, 0, 0.9996, 500000, 10000000";
        stringArray[614] = "mapinfo:coordsys309";
        stringArray[615] = "8, 24, 7, -33, 0, 0.9996, 500000, 10000000";
        stringArray[616] = "mapinfo:coordsys310";
        stringArray[617] = "8, 66, 7, -141, 0, 0.9996, 500000, 0";
        stringArray[618] = "mapinfo:coordsys311";
        stringArray[619] = "8, 66, 7, -135, 0, 0.9996, 500000, 0";
        stringArray[620] = "mapinfo:coordsys312";
        stringArray[621] = "8, 66, 7, -129, 0, 0.9996, 500000, 0";
        stringArray[622] = "mapinfo:coordsys313";
        stringArray[623] = "8, 66, 7, -123, 0, 0.9996, 500000, 0";
        stringArray[624] = "mapinfo:coordsys314";
        stringArray[625] = "8, 66, 7, -117, 0, 0.9996, 500000, 0";
        stringArray[626] = "mapinfo:coordsys315";
        stringArray[627] = "8, 66, 7, -111, 0, 0.9996, 500000, 0";
        stringArray[628] = "mapinfo:coordsys316";
        stringArray[629] = "8, 66, 7, -105, 0, 0.9996, 500000, 0";
        stringArray[630] = "mapinfo:coordsys317";
        stringArray[631] = "8, 66, 7, -99, 0, 0.9996, 500000, 0";
        stringArray[632] = "mapinfo:coordsys318";
        stringArray[633] = "8, 66, 7, -93, 0, 0.9996, 500000, 0";
        stringArray[634] = "mapinfo:coordsys319";
        stringArray[635] = "8, 66, 7, -87, 0, 0.9996, 500000, 0";
        stringArray[636] = "mapinfo:coordsys320";
        stringArray[637] = "8, 66, 7, -81, 0, 0.9996, 500000, 0";
        stringArray[638] = "mapinfo:coordsys321";
        stringArray[639] = "8, 66, 7, -75, 0, 0.9996, 500000, 0";
        stringArray[640] = "mapinfo:coordsys322";
        stringArray[641] = "8, 66, 7, -69, 0, 0.9996, 500000, 0";
        stringArray[642] = "mapinfo:coordsys323";
        stringArray[643] = "8, 66, 7, -63, 0, 0.9996, 500000, 0";
        stringArray[644] = "mapinfo:coordsys324";
        stringArray[645] = "8, 66, 7, -57, 0, 0.9996, 500000, 0";
        stringArray[646] = "mapinfo:coordsys325";
        stringArray[647] = "8, 66, 7, -51, 0, 0.9996, 500000, 0";
        stringArray[648] = "mapinfo:coordsys326";
        stringArray[649] = "8, 66, 7, -45, 0, 0.9996, 500000, 0";
        stringArray[650] = "mapinfo:coordsys327";
        stringArray[651] = "8, 66, 7, -39, 0, 0.9996, 500000, 0";
        stringArray[652] = "mapinfo:coordsys328";
        stringArray[653] = "8, 66, 7, -33, 0, 0.9996, 500000, 0";
        stringArray[654] = "mapinfo:coordsys329";
        stringArray[655] = "8, 66, 7, -27, 0, 0.9996, 500000, 0";
        stringArray[656] = "mapinfo:coordsys330";
        stringArray[657] = "8, 66, 7, -21, 0, 0.9996, 500000, 0";
        stringArray[658] = "mapinfo:coordsys331";
        stringArray[659] = "8, 66, 7, -15, 0, 0.9996, 500000, 0";
        stringArray[660] = "mapinfo:coordsys332";
        stringArray[661] = "8, 66, 7, -9, 0, 0.9996, 500000, 0";
        stringArray[662] = "mapinfo:coordsys333";
        stringArray[663] = "8, 66, 7, -53, 0, 0.9999, 304800, 0";
        stringArray[664] = "mapinfo:coordsys334";
        stringArray[665] = "8, 66, 7, -56, 0, 0.9999, 304800, 0";
        stringArray[666] = "mapinfo:coordsys335";
        stringArray[667] = "8, 66, 7, -58.5, 0, 0.9999, 304800, 0";
        stringArray[668] = "mapinfo:coordsys336";
        stringArray[669] = "8, 66, 7, -61.5, 0, 0.9999, 304800, 0";
        stringArray[670] = "mapinfo:coordsys337";
        stringArray[671] = "8, 66, 7, -64.5, 0, 0.9999, 304800, 0";
        stringArray[672] = "mapinfo:coordsys338";
        stringArray[673] = "8, 66, 7, -67.5, 0, 0.9999, 304800, 0";
        stringArray[674] = "mapinfo:coordsys339";
        stringArray[675] = "8, 66, 7, -70.5, 0, 0.9999, 304800, 0";
        stringArray[676] = "mapinfo:coordsys340";
        stringArray[677] = "8, 66, 7, -73.5, 0, 0.9999, 304800, 0";
        stringArray[678] = "mapinfo:coordsys341";
        stringArray[679] = "8, 66, 7, -76.5, 0, 0.9999, 304800, 0";
        stringArray[680] = "mapinfo:coordsys342";
        stringArray[681] = "8, 66, 7, -79.5, 0, 0.9999, 304800, 0";
        stringArray[682] = "mapinfo:coordsys343";
        stringArray[683] = "8, 66, 7, -82.5, 0, 0.9999, 304800, 0";
        stringArray[684] = "mapinfo:coordsys344";
        stringArray[685] = "8, 66, 7, -81, 0, 0.9999, 304800, 0";
        stringArray[686] = "mapinfo:coordsys345";
        stringArray[687] = "8, 66, 7, -84, 0, 0.9999, 304800, 0";
        stringArray[688] = "mapinfo:coordsys346";
        stringArray[689] = "8, 66, 7, -87, 0, 0.9999, 304800, 0";
        stringArray[690] = "mapinfo:coordsys347";
        stringArray[691] = "8, 66, 7, -90, 0, 0.9999, 304800, 0";
        stringArray[692] = "mapinfo:coordsys348";
        stringArray[693] = "8, 66, 7, -93, 0, 0.9999, 304800, 0";
        stringArray[694] = "mapinfo:coordsys349";
        stringArray[695] = "8, 66, 7, -96, 0, 0.9999, 304800, 0";
        stringArray[696] = "mapinfo:coordsys350";
        stringArray[697] = "8, 66, 7, -99, 0, 0.9999, 304800, 0";
        stringArray[698] = "mapinfo:coordsys351";
        stringArray[699] = "8, 66, 7, -102, 0, 0.9999, 304800, 0";
        stringArray[700] = "mapinfo:coordsys352";
        stringArray[701] = "8, 66, 7, -105, 0, 0.9999, 304800, 0";
        stringArray[702] = "mapinfo:coordsys353";
        stringArray[703] = "8, 66, 7, -108, 0, 0.9999, 304800, 0";
        stringArray[704] = "mapinfo:coordsys354";
        stringArray[705] = "8, 66, 7, -111, 0, 0.9999, 304800, 0";
        stringArray[706] = "mapinfo:coordsys355";
        stringArray[707] = "8, 66, 7, -114, 0, 0.9999, 304800, 0";
        stringArray[708] = "mapinfo:coordsys356";
        stringArray[709] = "8, 66, 7, -117, 0, 0.9999, 304800, 0";
        stringArray[710] = "mapinfo:coordsys357";
        stringArray[711] = "8, 66, 7, -120, 0, 0.9999, 304800, 0";
        stringArray[712] = "mapinfo:coordsys358";
        stringArray[713] = "8, 66, 7, -123, 0, 0.9999, 304800, 0";
        stringArray[714] = "mapinfo:coordsys359";
        stringArray[715] = "8, 66, 7, -126, 0, 0.9999, 304800, 0";
        stringArray[716] = "mapinfo:coordsys360";
        stringArray[717] = "8, 66, 7, -129, 0, 0.9999, 304800, 0";
        stringArray[718] = "mapinfo:coordsys361";
        stringArray[719] = "8, 66, 7, -132, 0, 0.9999, 304800, 0";
        stringArray[720] = "mapinfo:coordsys362";
        stringArray[721] = "8, 66, 7, -135, 0, 0.9999, 304800, 0";
        stringArray[722] = "mapinfo:coordsys363";
        stringArray[723] = "8, 66, 7, -138, 0, 0.9999, 304800, 0";
        stringArray[724] = "mapinfo:coordsys364";
        stringArray[725] = "8, 66, 7, -141, 0, 0.9999, 304800, 0";
        stringArray[726] = "mapinfo:coordsys365";
        stringArray[727] = "8, 74, 7, -177, 0, 0.9996, 500000, 0";
        stringArray[728] = "mapinfo:coordsys366";
        stringArray[729] = "8, 74, 7, -171, 0, 0.9996, 500000, 0";
        stringArray[730] = "mapinfo:coordsys367";
        stringArray[731] = "8, 74, 7, -9, 0, 0.9996, 500000, 0";
        stringArray[732] = "mapinfo:coordsys531";
        stringArray[733] = "8, 92, 7, -81, 0, 0.9996, 500000, 0";
        stringArray[734] = "mapinfo:coordsys368";
        stringArray[735] = "8, 97, 7, 123, 0, 0.9996, 500000, 0";
        stringArray[736] = "mapinfo:coordsys370";
        stringArray[737] = "8, 97, 7, 129, 0, 0.9996, 500000, 0";
        stringArray[738] = "mapinfo:coordsys371";
        stringArray[739] = "8, 97, 7, 135, 0, 0.9996, 500000, 0";
        stringArray[740] = "mapinfo:coordsys372";
        stringArray[741] = "8, 97, 7, 141, 0, 0.9996, 500000, 0";
        stringArray[742] = "mapinfo:coordsys373";
        stringArray[743] = "8, 97, 7, 147, 0, 0.9996, 500000, 0";
        stringArray[744] = "mapinfo:coordsys374";
        stringArray[745] = "8, 97, 7, 153, 0, 0.9996, 500000, 0";
        stringArray[746] = "mapinfo:coordsys375";
        stringArray[747] = "8, 97, 7, 159, 0, 0.9996, 500000, 0";
        stringArray[748] = "mapinfo:coordsys378";
        stringArray[749] = "3, 62, 8, -91.3333333333, 25.6666666667, 26.1666666667, 27.8333333333, 2000000, 0";
        stringArray[750] = "mapinfo:coordsys387";
        stringArray[751] = "3, 74, 7, -91.3333333333, 25.5, 26.1666666667, 27.8333333333, 1000000, 0";
        stringArray[752] = "mapinfo:coordsys396";
        stringArray[753] = "8, 74, 8, -85.8333333333, 30.5, 0.99996, 656166.6667, 0";
        stringArray[754] = "mapinfo:coordsys397";
        stringArray[755] = "8, 74, 8, -87.5, 30.0, 0.9999333333, 1968500, 0";
        stringArray[756] = "mapinfo:coordsys398";
        stringArray[757] = "7, 74, 8, -133.6666666667, 57, -36.8698976458, 0.9999, 16404166.67, -16404166.67";
        stringArray[758] = "mapinfo:coordsys399";
        stringArray[759] = "8, 74, 8, -142, 54, 0.9999, 1640416.667, 0";
        stringArray[760] = "mapinfo:coordsys400";
        stringArray[761] = "8, 74, 8, -146, 54, 0.9999, 1640416.667, 0";
        stringArray[762] = "mapinfo:coordsys401";
        stringArray[763] = "8, 74, 8, -150, 54, 0.9999, 1640416.667, 0";
        stringArray[764] = "mapinfo:coordsys402";
        stringArray[765] = "8, 74, 8, -154, 54, 0.9999, 1640416.667, 0";
        stringArray[766] = "mapinfo:coordsys403";
        stringArray[767] = "8, 74, 8, -158, 54, 0.9999, 1640416.667, 0";
        stringArray[768] = "mapinfo:coordsys404";
        stringArray[769] = "8, 74, 8, -162, 54, 0.9999, 1640416.667, 0";
        stringArray[770] = "mapinfo:coordsys405";
        stringArray[771] = "8, 74, 8, -166, 54, 0.9999, 1640416.667, 0";
        stringArray[772] = "mapinfo:coordsys406";
        stringArray[773] = "8, 74, 8, -170, 54, 0.9999, 1640416.667, 0";
        stringArray[774] = "mapinfo:coordsys407";
        stringArray[775] = "3, 74, 8, -176,51, 51.8333333333, 53.8333333333, 3280833.333, 0";
        stringArray[776] = "mapinfo:coordsys408";
        stringArray[777] = "8, 74, 3, -110.1666666667, 31, 0.9999, 700000, 0";
        stringArray[778] = "mapinfo:coordsys532";
        stringArray[779] = "8, 74, 8, -110.1666666667, 31, 0.9999, 699998.6, 0";
        stringArray[780] = "mapinfo:coordsys409";
        stringArray[781] = "8, 74, 3, -111.9166666667, 31, 0.9999, 700000, 0";
        stringArray[782] = "mapinfo:coordsys410";
        stringArray[783] = "8, 74, 8, -111.9166666667, 31, 0.9999, 699998.6, 0";
        stringArray[784] = "mapinfo:coordsys411";
        stringArray[785] = "8, 74, 3, -113.75, 31, 0.9999333333, 700000, 0";
        stringArray[786] = "mapinfo:coordsys412";
        stringArray[787] = "8, 74, 8, -113.75, 31, 0.9999333333, 699998.6, 0";
        stringArray[788] = "mapinfo:coordsys413";
        stringArray[789] = "3, 74, 8, -92, 34.3333333333, 34.9333333333, 36.2333333333, 1312333.333, 0";
        stringArray[790] = "mapinfo:coordsys414";
        stringArray[791] = "3, 74, 8, -92, 32.6666666667, 33.3, 34.7666666667, 1312333.333, 1312333.333";
        stringArray[792] = "mapinfo:coordsys415";
        stringArray[793] = "3, 74, 8, -122, 39.3333333333, 40, 41.6666666667, 6561666.667, 1640416.667";
        stringArray[794] = "mapinfo:coordsys416";
        stringArray[795] = "3, 74, 8, -122, 37.6666666667, 38.3333333333, 39.8333333333, 6561666.667, 1640416.667";
        stringArray[796] = "mapinfo:coordsys417";
        stringArray[797] = "3, 74, 8, -120.5, 36.5, 37.0666666667, 38.4333333333, 6561666.667, 1640416.667";
        stringArray[798] = "mapinfo:coordsys418";
        stringArray[799] = "3, 74, 8, -119, 35.3333333333, 36, 37.25, 6561666.667, 1640416.667";
        stringArray[800] = "mapinfo:coordsys419";
        stringArray[801] = "3, 74, 8, -118, 33.5, 34.0333333333, 35.4666666667, 6561666.667, 1640416.667";
        stringArray[802] = "mapinfo:coordsys420";
        stringArray[803] = "3, 74, 8, -116.25, 32.1666666667, 32.7833333333, 33.8833333333, 6561666.667, 1640416.667";
        stringArray[804] = "mapinfo:coordsys421";
        stringArray[805] = "3, 74, 8, -105.5, 39.3333333333, 39.7166666667, 40.7833333333, 3000000, 1000000";
        stringArray[806] = "mapinfo:coordsys422";
        stringArray[807] = "3, 74, 8, -105.5, 37.8333333333, 38.45, 39.75, 3000000, 1000000";
        stringArray[808] = "mapinfo:coordsys423";
        stringArray[809] = "3, 74, 8, -105.5, 36.6666666667, 37.2333333333, 38.4333333333, 3000000, 1000000";
        stringArray[810] = "mapinfo:coordsys424";
        stringArray[811] = "3, 74, 8, -72.75, 40.8333333333, 41.2, 41.8666666667, 1000000, 500000";
        stringArray[812] = "mapinfo:coordsys425";
        stringArray[813] = "8, 74, 8, -75.4166666667, 38, 0.999995, 656166.6667, 0";
        stringArray[814] = "mapinfo:coordsys426";
        stringArray[815] = "8, 74, 8, -81, 24.3333333333, 0.9999411765, 656166.6667, 0";
        stringArray[816] = "mapinfo:coordsys427";
        stringArray[817] = "8, 74, 8, -82, 24.3333333333, 0.9999411765, 656166.6667, 0";
        stringArray[818] = "mapinfo:coordsys428";
        stringArray[819] = "3, 74, 8, -84.5, 29, 29.5833333333, 30.75, 1968500, 0";
        stringArray[820] = "mapinfo:coordsys429";
        stringArray[821] = "8, 74, 8, -82.1666666667, 30, 0.9999, 656166.6667, 0";
        stringArray[822] = "mapinfo:coordsys430";
        stringArray[823] = "8, 74, 8, -84.1666666667, 30, 0.9999, 2296583.333, 0";
        stringArray[824] = "mapinfo:coordsys431";
        stringArray[825] = "8, 74, 8, -155.5, 18.8333333333, 0.9999666667, 1640416.667, 0";
        stringArray[826] = "mapinfo:coordsys432";
        stringArray[827] = "8, 74, 8, -156.6666666667, 20.3333333333, 0.9999666667, 1640416.667, 0";
        stringArray[828] = "mapinfo:coordsys433";
        stringArray[829] = "8, 74, 8, -158, 21.1666666667, 0.99999, 1640416.667, 0";
        stringArray[830] = "mapinfo:coordsys434";
        stringArray[831] = "8, 74, 8, -159.5, 21.8333333333, 0.99999, 1640416.667, 0";
        stringArray[832] = "mapinfo:coordsys435";
        stringArray[833] = "8, 74, 8, -160.1666666667, 21.6666666667, 1, 1640416.667, 0";
        stringArray[834] = "mapinfo:coordsys436";
        stringArray[835] = "8, 74, 8, -112.1666666667, 41.6666666667, 0.9999473684, 656166.6667, 0";
        stringArray[836] = "mapinfo:coordsys437";
        stringArray[837] = "8, 74, 8, -114, 41.6666666667, 0.9999473684, 1640416.667, 0";
        stringArray[838] = "mapinfo:coordsys438";
        stringArray[839] = "8, 74, 8, -115.75, 41.6666666667, 0.9999333333, 2624666.667, 0";
        stringArray[840] = "mapinfo:coordsys439";
        stringArray[841] = "8, 74, 8, -88.3333333333, 36.6666666667, 0.999975, 984250, 0";
        stringArray[842] = "mapinfo:coordsys440";
        stringArray[843] = "8, 74, 8, -90.1666666667, 36.6666666667, 0.9999411765, 2296583.333, 0";
        stringArray[844] = "mapinfo:coordsys441";
        stringArray[845] = "8, 74, 8, -85.6666666667, 37.5, 0.9999666667, 328083.3333, 820208.3333";
        stringArray[846] = "mapinfo:coordsys442";
        stringArray[847] = "8, 74, 8, -87.0833333333, 37.5, 0.9999666667, 2952750, 820208.3333";
        stringArray[848] = "mapinfo:coordsys443";
        stringArray[849] = "3, 74, 8, -93.5, 41.5, 42.0666666667, 43.2666666667, 4921250, 3280833.333";
        stringArray[850] = "mapinfo:coordsys444";
        stringArray[851] = "3, 74, 8, -93.5, 40, 40.6166666667, 41.7833333333, 1640416.667, 0";
        stringArray[852] = "mapinfo:coordsys445";
        stringArray[853] = "3, 74, 8, -98, 38.3333333333, 38.7166666667, 39.7833333333, 1312333.333, 0";
        stringArray[854] = "mapinfo:coordsys446";
        stringArray[855] = "3, 74, 8, -98.5, 36.6666666667, 38.5666666667, 37.2666666667, 1312333.333, 1312333.333";
        stringArray[856] = "mapinfo:coordsys447";
        stringArray[857] = "3, 74, 8, -84.25, 37.5, 37.9666666667, 38.9666666667, 1640416.667, 0";
        stringArray[858] = "mapinfo:coordsys448";
        stringArray[859] = "3, 74, 8, -85.75, 36.3333333333, 36.7333333333, 37.9333333333, 1640416.667, 1640416.667";
        stringArray[860] = "mapinfo:coordsys449";
        stringArray[861] = "3, 74, 8, -92.5, 30.5, 31.1666666667, 32.6666666667, 3280833.333, 0";
        stringArray[862] = "mapinfo:coordsys450";
        stringArray[863] = "3, 74, 8, -91.3333333333, 28.5, 29.3, 30.7, 3280833.333, 0";
        stringArray[864] = "mapinfo:coordsys451";
        stringArray[865] = "3, 74, 8, -91.3333333333, 25.5, 26.1666666667, 27.8333333333, 3280833.333, 0";
        stringArray[866] = "mapinfo:coordsys452";
        stringArray[867] = "8, 74, 8, -68.5, 43.6666666667, 0.9999, 984250, 0";
        stringArray[868] = "mapinfo:coordsys453";
        stringArray[869] = "8, 74, 8, -70.1666666667, 42.8333333333, 0.9999666667, 2952750, 0";
        stringArray[870] = "mapinfo:coordsys454";
        stringArray[871] = "3, 74, 8, -77, 37.6666666667, 38.3, 39.45, 1312333.333, 0";
        stringArray[872] = "mapinfo:coordsys455";
        stringArray[873] = "3, 74, 8, -71.5, 41, 41.7166666667, 42.6833333333, 656166.6667, 2460625";
        stringArray[874] = "mapinfo:coordsys456";
        stringArray[875] = "3, 74, 8, -70.5, 41, 41.2833333333, 41.4833333333, 1640416.667, 0";
        stringArray[876] = "mapinfo:coordsys457";
        stringArray[877] = "3, 74, 3, -87, 44.7833333333, 45.4833333333, 47.0833333333, 26246719.16, 0";
        stringArray[878] = "mapinfo:coordsys458";
        stringArray[879] = "3, 74, 8, -87, 44.7833333333, 45.4833333333, 47.0833333333, 26246666.67, 0";
        stringArray[880] = "mapinfo:coordsys459";
        stringArray[881] = "3, 74, 3, -84.3666666667, 43.3166666667, 44.1833333333, 45.7, 19685039.37, 0";
        stringArray[882] = "mapinfo:coordsys460";
        stringArray[883] = "3, 74, 8, -84.3666666667, 43.3166666667, 44.1833333333, 45.7, 19685000, 0";
        stringArray[884] = "mapinfo:coordsys461";
        stringArray[885] = "3, 74, 3, -84.3666666667, 41.5, 42.1, 43.6666666667, 13123359.58, 0";
        stringArray[886] = "mapinfo:coordsys462";
        stringArray[887] = "3, 74, 8, -84.3666666667, 41.5, 42.1, 43.6666666667, 13123333.33, 0";
        stringArray[888] = "mapinfo:coordsys463";
        stringArray[889] = "3, 74, 8, -93.1, 46.5, 47.0333333333, 48.6333333333, 2624666.667, 328083.3333";
        stringArray[890] = "mapinfo:coordsys464";
        stringArray[891] = "3, 74, 8, -94.25, 45, 45.6166666667, 47.05, 2624666.667, 328083.3333";
        stringArray[892] = "mapinfo:coordsys465";
        stringArray[893] = "3, 74, 8, -94, 43, 43.7833333333, 45.2166666667, 2624666.667, 328083.3333";
        stringArray[894] = "mapinfo:coordsys466";
        stringArray[895] = "8, 74, 8, -88.8333333333, 29.5, 0.99995, 984250, 0";
        stringArray[896] = "mapinfo:coordsys467";
        stringArray[897] = "8, 74, 8, -90.3333333333, 29.5, 0.99995, 2296583.333, 0";
        stringArray[898] = "mapinfo:coordsys468";
        stringArray[899] = "8, 74, 8, -90.5, 35.8333333333, 0.9999333333, 820208.3333, 0";
        stringArray[900] = "mapinfo:coordsys469";
        stringArray[901] = "8, 74, 8, -92.5, 35.8333333333, 0.9999333333, 1640416.667, 0";
        stringArray[902] = "mapinfo:coordsys470";
        stringArray[903] = "8, 74, 8, -94.5, 36.1666666667, 0.9999411765, 2788708.333, 0";
        stringArray[904] = "mapinfo:coordsys471";
        stringArray[905] = "3, 74, 3, -109.5, 44.25, 45, 49, 1968503.937, 0";
        stringArray[906] = "mapinfo:coordsys472";
        stringArray[907] = "3, 74, 8, -109.5, 44.25, 45, 49, 1968500, 0";
        stringArray[908] = "mapinfo:coordsys473";
        stringArray[909] = "3, 74, 8, -100, 39.8333333333, 40, 43, 1640416.667, 0";
        stringArray[910] = "mapinfo:coordsys474";
        stringArray[911] = "8, 74, 8, -115.5833333333, 34.75, 0.9999, 656166.6667, 26246666.67";
        stringArray[912] = "mapinfo:coordsys475";
        stringArray[913] = "8, 74, 8, -116.6666666667, 34.75, 0.9999, 1640416.667, 19685000";
        stringArray[914] = "mapinfo:coordsys476";
        stringArray[915] = "8, 74, 8, -118.5833333333, 34.75, 0.9999, 2624666.667, 13123333.33";
        stringArray[916] = "mapinfo:coordsys477";
        stringArray[917] = "8, 74, 8, -71.6666666667, 42.5, 0.9999666667, 984250, 0";
        stringArray[918] = "mapinfo:coordsys478";
        stringArray[919] = "8, 74, 8, -74.5, 38.8333333334, 0.9999, 492125, 0";
        stringArray[920] = "mapinfo:coordsys479";
        stringArray[921] = "8, 74, 8, -104.3333333333, 31, 0.9999090909, 541337.5, 0";
        stringArray[922] = "mapinfo:coordsys480";
        stringArray[923] = "8, 74, 8, -106.25, 31, 0.9999, 1640416.667, 0";
        stringArray[924] = "mapinfo:coordsys481";
        stringArray[925] = "8, 74, 8, -107.8333333333, 31, 0.9999166667, 2723091.667, 0";
        stringArray[926] = "mapinfo:coordsys482";
        stringArray[927] = "8, 74, 8, -74.5, 38.8333333333, 0.9999, 492125, 0";
        stringArray[928] = "mapinfo:coordsys483";
        stringArray[929] = "8, 74, 8, -76.5833333333, 40, 0.9999375, 820208.3333, 0";
        stringArray[930] = "mapinfo:coordsys484";
        stringArray[931] = "8, 74, 8, -78.5833333333, 40, 0.9999375, 1148291.667, 0";
        stringArray[932] = "mapinfo:coordsys485";
        stringArray[933] = "3, 74, 8, -74, 40.1666666667, 40.6666666667, 41.0333333333, 984250, 0";
        stringArray[934] = "mapinfo:coordsys486";
        stringArray[935] = "3, 74, 8, -79, 33.75, 34.3333333333, 36.1666666667, 2000000, 0";
        stringArray[936] = "mapinfo:coordsys487";
        stringArray[937] = "3, 74, 8, -100.5, 47, 47.4333333333, 48.7333333333, 1968500, 0";
        stringArray[938] = "mapinfo:coordsys488";
        stringArray[939] = "3, 74, 8, -100.5, 45.6666666667, 46.1833333333, 47.4833333333, 1968500, 0";
        stringArray[940] = "mapinfo:coordsys489";
        stringArray[941] = "3, 74, 8, -82.5, 39.6666666667, 40.4333333333, 41.7, 1968500, 0";
        stringArray[942] = "mapinfo:coordsys490";
        stringArray[943] = "3, 74, 8, -82.5, 38, 38.7333333333, 40.0333333333, 1968500, 0";
        stringArray[944] = "mapinfo:coordsys491";
        stringArray[945] = "3, 74, 8, -98, 35, 35.5666666667, 36.7666666667, 1968500, 0";
        stringArray[946] = "mapinfo:coordsys492";
        stringArray[947] = "3, 74, 8, -98, 33.3333333333, 33.9333333333, 35.2333333333, 1968500, 0";
        stringArray[948] = "mapinfo:coordsys493";
        stringArray[949] = "3, 74, 3, -120.5, 43.6666666667, 44.3333333333, 46, 8202099.738, 0";
        stringArray[950] = "mapinfo:coordsys494";
        stringArray[951] = "3, 74, 8, -120.5, 43.6666666667, 44.3333333333, 46, 8202083.333, 0";
        stringArray[952] = "mapinfo:coordsys495";
        stringArray[953] = "3, 74, 3, -120.5, 41.6666666667, 42.3333333333, 44, 4921259.843, 0";
        stringArray[954] = "mapinfo:coordsys496";
        stringArray[955] = "3, 74, 8, -120.5, 41.6666666667, 42.3333333333, 44, 4921250, 0";
        stringArray[956] = "mapinfo:coordsys497";
        stringArray[957] = "3, 74, 8, -77.75, 40.1666666667, 40.8833333333, 41.95, 1968500, 0";
        stringArray[958] = "mapinfo:coordsys498";
        stringArray[959] = "3, 74, 8, -77.75, 39.3333333333, 39.9333333333, 40.9666666667, 1968500, 0";
        stringArray[960] = "mapinfo:coordsys499";
        stringArray[961] = "3, 74, 8, -66.4333333333, 17.8333333333, 18.0333333333, 18.4333333333, 656166.6667, 656166.6667";
        stringArray[962] = "mapinfo:coordsys500";
        stringArray[963] = "8, 74, 8, -71.5, 41.0833333333, 0.99999375, 328083.3333, 0";
        stringArray[964] = "mapinfo:coordsys501";
        stringArray[965] = "3, 74, 3, -81, 31.8333333333, 32.5, 34.8333333333, 2000000, 0";
        stringArray[966] = "mapinfo:coordsys502";
        stringArray[967] = "3, 74, 8, -81, 31.8333333333, 32.5, 34.8333333333, 1999996, 0";
        stringArray[968] = "mapinfo:coordsys503";
        stringArray[969] = "3, 74, 8, -100, 43.8333333333, 44.4166666667, 45.6833333333, 1968500, 0";
        stringArray[970] = "mapinfo:coordsys504";
        stringArray[971] = "3, 74, 8, -100.3333333333, 42.3333333333, 42.8333333333, 44.4, 1968500, 0";
        stringArray[972] = "mapinfo:coordsys505";
        stringArray[973] = "3, 74, 8, -86, 34.3333333333, 35.25, 36.4166666667, 1968500, 0";
        stringArray[974] = "mapinfo:coordsys506";
        stringArray[975] = "3, 74, 8, -101.5, 34, 34.65, 36.1833333333, 656166.6667, 3280833.333";
        stringArray[976] = "mapinfo:coordsys507";
        stringArray[977] = "3, 74, 8, -98.5, 31.6666666667, 32.1333333333, 33.9666666667, 1968500, 6561666.667";
        stringArray[978] = "mapinfo:coordsys508";
        stringArray[979] = "3, 74, 8, -100.3333333333, 29.6666666667, 30.1166666667, 31.8833333333, 2296583.333, 9842500";
        stringArray[980] = "mapinfo:coordsys509";
        stringArray[981] = "3, 74, 8, -99, 27.8333333333, 28.3833333333, 30.2833333333, 1968500, 13123333.33";
        stringArray[982] = "mapinfo:coordsys510";
        stringArray[983] = "3, 74, 8, -98.5, 25.6666666667, 26.1666666667, 27.8333333333, 984250, 16404166.67";
        stringArray[984] = "mapinfo:coordsys511";
        stringArray[985] = "3, 74, 3, -111.5, 40.3333333333, 40.7166666667, 41.7833333333, 1640419.948, 3280839.895";
        stringArray[986] = "mapinfo:coordsys512";
        stringArray[987] = "3, 74, 8, -111.5, 40.3333333333, 40.7166666667, 41.7833333333, 1640416.667, 3280833.333";
        stringArray[988] = "mapinfo:coordsys513";
        stringArray[989] = "3, 74, 3, -111.5, 38.3333333333, 39.0166666667, 40.65, 1640419.948, 6561679.79";
        stringArray[990] = "mapinfo:coordsys514";
        stringArray[991] = "3, 74, 8, -111.5, 38.3333333333, 39.0166666667, 40.65, 1640416.667, 6561666.667";
        stringArray[992] = "mapinfo:coordsys515";
        stringArray[993] = "3, 74, 3, -111.5, 36.6666666667, 37.2166666667, 38.35, 1640419.948, 9842519.685";
        stringArray[994] = "mapinfo:coordsys516";
        stringArray[995] = "3, 74, 8, -111.5, 36.6666666667, 37.2166666667, 38.35, 1640416.667, 9842500";
        stringArray[996] = "mapinfo:coordsys517";
        stringArray[997] = "8, 74, 8, -72.5, 42.5, 0.9999642857, 1640416.667, 0";
        stringArray[998] = "mapinfo:coordsys518";
        stringArray[999] = "3, 74, 8, -78.5, 37.6666666667, 38.0333333333, 39.2, 11482916.67, 6561666.667";
        stringArray[1000] = "mapinfo:coordsys519";
        stringArray[1001] = "3, 74, 8, -78.5, 36.3333333333, 36.7666666667, 37.9666666667, 11482916.67, 3280833.333";
        stringArray[1002] = "mapinfo:coordsys520";
        stringArray[1003] = "3, 74, 8, -120.8333333333, 47, 47.5, 48.7333333333, 1640416.667, 0";
        stringArray[1004] = "mapinfo:coordsys521";
        stringArray[1005] = "3, 74, 8, -120.5, 45.3333333333, 45.8333333333, 47.3333333333, 1640416.667, 0";
        stringArray[1006] = "mapinfo:coordsys522";
        stringArray[1007] = "3, 74, 8, -79.5, 38.5, 39, 40.25, 1968500, 0";
        stringArray[1008] = "mapinfo:coordsys523";
        stringArray[1009] = "3, 74, 8, -81, 37, 37.4833333333, 38.8833333333, 1968500, 0";
        stringArray[1010] = "mapinfo:coordsys524";
        stringArray[1011] = "3, 74, 8, -90, 45.1666666667, 45.5666666667, 46.7666666667, 1968500, 0";
        stringArray[1012] = "mapinfo:coordsys525";
        stringArray[1013] = "3, 74, 8, -90, 43.8333333333, 44.25, 45.5, 1968500, 0";
        stringArray[1014] = "mapinfo:coordsys526";
        stringArray[1015] = "3, 74, 8, -90, 42, 42.7333333333, 44.0666666667, 1968500, 0";
        stringArray[1016] = "mapinfo:coordsys527";
        stringArray[1017] = "8, 74, 8, -105.1666666667, 40.5, 0.9999375, 656166.6667, 0";
        stringArray[1018] = "mapinfo:coordsys528";
        stringArray[1019] = "8, 74, 8, -107.3333333333, 40.5, 0.9999375, 1312333.333, 328083.3333";
        stringArray[1020] = "mapinfo:coordsys529";
        stringArray[1021] = "8, 74, 8, -108.75, 40.5, 0.9999375, 1968500, 0";
        stringArray[1022] = "mapinfo:coordsys530";
        stringArray[1023] = "8, 74, 8, -110.0833333333, 40.5, 0.9999375, 2624666.667, 328083.3333";
        a = stringArray;
        COORDINATEREFERENCESYSTEM = COORDINATEREFERENCESYSTEM;
        b = b;
        c = c;
        d = d;
        e = e;
        f = f;
        g = g;
        h = h;
        i = i;
        j = j;
        k = k;
        l = l;
        m = m;
        n = n;
        o = o;
        p = p;
        q = q;
        r = r;
        s = s;
        t = t;
        u = u;
        v = v;
        w = w;
        x = x;
        y = y;
        z = z;
        aa = aa;
        ab = ab;
        ac = ac;
        ad = ad;
        ae = ae;
        af = af;
        ag = ag;
        ah = ah;
        ai = ai;
        aj = aj;
        ak = ak;
        al = al;
        am = am;
        an = an;
        ao = ao;
        ap = ap;
        aq = aq;
        ar = ar;
        as = as;
        at = at;
        au = au;
        av = av;
        aw = aw;
        ax = ax;
        ay = ay;
        az = az;
        a0 = a0;
        a1 = a1;
        a2 = a2;
        a3 = a3;
        a4 = a4;
        a5 = a5;
        a6 = a6;
        a7 = a7;
        a8 = a8;
        a9 = a9;
        ba = ba;
        bb = bb;
        bc = bc;
        bd = bd;
        be = be;
        bf = bf;
        bg = bg;
        bh = bh;
        bi = bi;
        bj = bj;
        bk = bk;
        bl = bl;
        bm = new Hashtable();
        CoordSysXMLCreator.a();
        int n = 0;
        while (n < a.length) {
            bm.put(a[n], a[n + 1]);
            bm.put(a[n + 1], a[n]);
            n += 2;
        }
    }
}

