/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUT.parser;

import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.ArrayUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AUT_Parser
extends CGGEParser1 {
    static Pattern hnrPattern = null;
    private static final List<FieldType> locFields;

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        StringBuilder streetname;
        Matcher hnrMatcher;
        boolean isSingleLine = this.isSingleLineInput(inputAddress);
        if (!isSingleLine && null != inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE) && (hnrMatcher = hnrPattern.matcher(streetname = new StringBuilder((String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)))).find()) {
            if (StringUtilities.isEmpty((String)((String)inputAddress.getField(FieldType.ADDRESS_NUMBER_FIELD_TYPE)))) {
                inputAddress.setField(FieldType.ADDRESS_NUMBER_FIELD_TYPE, hnrMatcher.group(1));
            } else {
                inputAddress.setField(FieldType.GENERIC_FIELD_3_FIELD_TYPE, hnrMatcher.group(1));
            }
            streetname.replace(hnrMatcher.start(), hnrMatcher.end(), "");
            inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, streetname.toString().trim());
        }
        ParsedAddress[] parsedAddresses = super.parse(inputAddress, scorer);
        if (!isSingleLine) {
            if (parsedAddresses[0].getFields().get(FieldType.ADDRESS_NUMBER_FIELD_TYPE) == null && inputAddress.getField(FieldType.ADDRESS_NUMBER_FIELD_TYPE) != null) {
                parsedAddresses[0].setAddressNumber(this.parserAddressNumber((String)inputAddress.getField(FieldType.ADDRESS_NUMBER_FIELD_TYPE)));
            }
            AddressWord[] streetnameWords = (AddressWord[])parsedAddresses[0].getFields().get(FieldType.STREET_NAME_FIELD_TYPE);
            String hnrFieldType = (String)inputAddress.getField(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
            if (null == streetnameWords && !StringUtilities.isEmpty((String)hnrFieldType)) {
                this.populateStreetField(inputAddress, parsedAddresses);
            } else if (null != streetnameWords) {
                boolean isNotSignificant = true;
                for (AddressWord streetnameWord : streetnameWords) {
                    if (streetnameWord.getWord().matches("\\d+\\w*")) continue;
                    isNotSignificant = false;
                    break;
                }
                if (isNotSignificant) {
                    this.populateStreetField(inputAddress, parsedAddresses);
                }
            }
        }
        return parsedAddresses;
    }

    private void populateStreetField(InputAddress inputAddress, ParsedAddress[] parsedAddresses) {
        if (!inputAddress.isEmpty(FieldType.POST_ADDRESS_FIELD_TYPE)) {
            this.populate(inputAddress, parsedAddresses, (AddressWord[])parsedAddresses[0].getFields().get(FieldType.POST_ADDRESS_FIELD_TYPE));
        }
        if (!inputAddress.isEmpty(FieldType.AREA_NAME_4_FIELD_TYPE)) {
            this.populate(inputAddress, parsedAddresses, (AddressWord[])parsedAddresses[0].getFields().get(FieldType.AREA_NAME_4_FIELD_TYPE));
        }
        if (!inputAddress.isEmpty(FieldType.AREA_NAME_3_FIELD_TYPE)) {
            this.populate(inputAddress, parsedAddresses, (AddressWord[])parsedAddresses[0].getFields().get(FieldType.AREA_NAME_3_FIELD_TYPE));
        }
    }

    private void populate(InputAddress inputAddress, ParsedAddress[] parsedAddresses, AddressWord[] addressWords) {
        inputAddress.setField(FieldType.GENERIC_FIELD_4_FIELD_TYPE, "ISRURAL");
        if (null == parsedAddresses[0].getField(FieldType.STREET_NAME_FIELD_TYPE)) {
            parsedAddresses[0].setField(FieldType.STREET_NAME_FIELD_TYPE, addressWords);
        } else {
            parsedAddresses[0].setField(FieldType.STREET_NAME_FIELD_TYPE, ArrayUtils.combineArrays((Object[])parsedAddresses[0].getField(FieldType.STREET_NAME_FIELD_TYPE), addressWords));
        }
    }

    boolean isSingleLineInput(InputAddress inAddr) {
        if (inAddr != null) {
            for (FieldType locField : locFields) {
                if (inAddr.isEmpty(locField)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        hnrPattern = Pattern.compile("\\b((\\d{1,2})*\\s*(Stiege|Parzelle)\\s*\\d{1,2})\\b");
        locFields = Arrays.asList(FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE, FieldType.POST_ADDRESS_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE);
    }
}

