/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.BGR.matcher;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;

public class BGRMatcher
extends CGGEMatcher1 {
    public static double STREET_SCORE_BOOST = 0.02;
    public static double STREET_SCORE_THRESHOLD = 0.92;

    @Override
    public boolean calculateCloseMatch(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, GeocodeOptions options, MatchingOptions matchOptions) throws CGGEInternalException {
        boolean isClose = super.calculateCloseMatch(scoringAddr, parsedAddr, options, matchOptions);
        if (parsedAddr == null) {
            return isClose;
        }
        AddressWord[] inpAddressWords = (AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (inpAddressWords == null) {
            return isClose;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inpAddressWords.length; ++i) {
            String word = inpAddressWords[i].getWord();
            sb.append(word);
        }
        String inputStreetCombined = sb.toString();
        if (isClose) {
            InternalFieldValue ifv = (InternalFieldValue)scoringAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
            FieldScore score = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
            if (null == ifv || score == null) {
                return isClose;
            }
            AddressWord[] streetAddressWords = (AddressWord[])ifv.getFieldValue();
            StringBuilder sb1 = new StringBuilder();
            for (int i = 0; i < streetAddressWords.length; ++i) {
                AddressWord streetWord = streetAddressWords[i];
                short wordAttrib = streetWord.getAttributes();
                if (CodedWord.isThoroughfareTypeWord(wordAttrib)) continue;
                String word = streetAddressWords[i].getWord();
                sb1.append(word);
            }
            String candStreetCombined = sb1.toString();
            if (inputStreetCombined.toUpperCase().contains(candStreetCombined.toUpperCase())) {
                score.m_value += STREET_SCORE_BOOST;
            }
            for (int i = 0; i < streetAddressWords.length; ++i) {
                AddressWord streetWord = streetAddressWords[i];
                short wordAttrib = streetWord.getAttributes();
                if (!CodedWord.isNumber(wordAttrib) && !CodedWord.isNumeric(wordAttrib) || !(score.m_value < STREET_SCORE_THRESHOLD)) continue;
                isClose = false;
            }
        }
        scoringAddr.setCloseMatch(isClose);
        return isClose;
    }
}

